/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import me.jfenn.bingo.common.map.MapColorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000b\u001a\u00020\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0011J8\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0011J\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b \u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b!\u0010\u0011R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\"\u0010\u0011R\u001b\u0010&\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010\u0011R\u001b\u0010)\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010$\u001a\u0004\b(\u0010\u0011R\u001b\u0010.\u001a\u00020*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010$\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lme/jfenn/bingo/common/map/Color;", "", "", "r", "g", "b", "a", "<init>", "(IIII)V", "Lkotlin/Function1;", "mapper", "map", "(Lkotlin/jvm/functions/Function1;)Lme/jfenn/bingo/common/map/Color;", "other", "mix", "(Lme/jfenn/bingo/common/map/Color;)Lme/jfenn/bingo/common/map/Color;", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lme/jfenn/bingo/common/map/Color;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getR", "getG", "getB", "getA", "asInt$delegate", "Lkotlin/Lazy;", "getAsInt", "asInt", "asIntWithAlpha$delegate", "getAsIntWithAlpha", "asIntWithAlpha", "", "asByte$delegate", "getAsByte", "()B", "asByte", "Companion", "bingo-common"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int r;
    private final int g;
    private final int b;
    private final int a;
    @NotNull
    private final Lazy asInt$delegate;
    @NotNull
    private final Lazy asIntWithAlpha$delegate;
    @NotNull
    private final Lazy asByte$delegate;
    @NotNull
    private static final Color BLACK = Companion.fromInt(-16777216);
    @NotNull
    private static final Color TRANSPARENT = Companion.fromInt(0);

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.asInt$delegate = LazyKt.lazy(() -> Color.asInt_delegate$lambda$0(this));
        this.asIntWithAlpha$delegate = LazyKt.lazy(() -> Color.asIntWithAlpha_delegate$lambda$0(this));
        this.asByte$delegate = LazyKt.lazy(() -> Color.asByte_delegate$lambda$0(this));
    }

    public /* synthetic */ Color(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    public final int getR() {
        return this.r;
    }

    public final int getG() {
        return this.g;
    }

    public final int getB() {
        return this.b;
    }

    public final int getA() {
        return this.a;
    }

    @NotNull
    public final Color map(@NotNull Function1<? super Integer, Integer> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new Color(((Number)mapper.invoke((Object)this.r)).intValue(), ((Number)mapper.invoke((Object)this.g)).intValue(), ((Number)mapper.invoke((Object)this.b)).intValue(), this.a);
    }

    public final int getAsInt() {
        Lazy lazy = this.asInt$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getAsIntWithAlpha() {
        Lazy lazy = this.asIntWithAlpha$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final byte getAsByte() {
        Lazy lazy = this.asByte$delegate;
        return ((Number)lazy.getValue()).byteValue();
    }

    @NotNull
    public final Color mix(@NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float alpha = (float)other.a / 255.0f;
        return new Color((int)((float)this.r * (1.0f - alpha) + (float)other.r * alpha), (int)((float)this.g * (1.0f - alpha) + (float)other.g * alpha), (int)((float)this.b * (1.0f - alpha) + (float)other.b * alpha), this.a);
    }

    public final int component1() {
        return this.r;
    }

    public final int component2() {
        return this.g;
    }

    public final int component3() {
        return this.b;
    }

    public final int component4() {
        return this.a;
    }

    @NotNull
    public final Color copy(int r, int g, int b, int a) {
        return new Color(r, g, b, a);
    }

    public static /* synthetic */ Color copy$default(Color color2, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = color2.r;
        }
        if ((n5 & 2) != 0) {
            n2 = color2.g;
        }
        if ((n5 & 4) != 0) {
            n3 = color2.b;
        }
        if ((n5 & 8) != 0) {
            n4 = color2.a;
        }
        return color2.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Color(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.r);
        result = result * 31 + Integer.hashCode(this.g);
        result = result * 31 + Integer.hashCode(this.b);
        result = result * 31 + Integer.hashCode(this.a);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        Color color2 = (Color)other;
        if (this.r != color2.r) {
            return false;
        }
        if (this.g != color2.g) {
            return false;
        }
        if (this.b != color2.b) {
            return false;
        }
        return this.a == color2.a;
    }

    private static final int asInt_delegate$lambda$0(Color this$0) {
        return MapColorsKt.rgb(this$0.r, this$0.g, this$0.b);
    }

    private static final int asIntWithAlpha_delegate$lambda$0(Color this$0) {
        return MapColorsKt.rgba(this$0.r, this$0.g, this$0.b, this$0.a);
    }

    private static final byte asByte_delegate$lambda$0(Color this$0) {
        return MapColorsKt.closestColorByte(this$0.getAsInt());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/common/map/Color$Companion;", "", "<init>", "()V", "", "i", "Lme/jfenn/bingo/common/map/Color;", "fromInt", "(I)Lme/jfenn/bingo/common/map/Color;", "", "string", "fromString", "(Ljava/lang/String;)Lme/jfenn/bingo/common/map/Color;", "BLACK", "Lme/jfenn/bingo/common/map/Color;", "getBLACK", "()Lme/jfenn/bingo/common/map/Color;", "TRANSPARENT", "getTRANSPARENT", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nMapColors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapColors.kt\nme/jfenn/bingo/common/map/Color$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getBLACK() {
            return BLACK;
        }

        @NotNull
        public final Color getTRANSPARENT() {
            return TRANSPARENT;
        }

        @NotNull
        public final Color fromInt(int i) {
            return new Color(i >>> 16 & 0xFF, i >>> 8 & 0xFF, i & 0xFF, i >>> 24 & 0xFF);
        }

        @NotNull
        public final Color fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int it = UStringsKt.toUInt((String)StringsKt.removePrefix((String)string, (CharSequence)"#"), (int)16);
            boolean bl = false;
            return Companion.fromInt(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

