/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.map.MapItemService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.inventory.IContainerItemView;
import me.jfenn.bingo.platform.item.IItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0018J\u0017\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010!R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\"R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$\u00a8\u0006%"}, d2={"Lme/jfenn/bingo/common/map/MapItemController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/common/map/MapItemService;", "mapItemService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/common/map/MapItemService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "removePreviewCardItem", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "giveMapCardItem", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/team/BingoTeam;)V", "giveSpectatorMapItems", "removeAllMapItems", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/common/map/MapItemService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/team/TeamService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMapItemController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapItemController.kt\nme/jfenn/bingo/common/map/MapItemController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n1276#3,3:161\n1255#3,2:166\n1321#3,2:169\n1878#4,2:164\n1880#4:168\n*S KotlinDebug\n*F\n+ 1 MapItemController.kt\nme/jfenn/bingo/common/map/MapItemController\n*L\n46#1:161,3\n85#1:166,2\n106#1:169,2\n83#1:164,2\n83#1:168\n*E\n"})
public final class MapItemController
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final MapItemService mapItemService;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TeamService teamService;

    public MapItemController(@NotNull BingoState state, @NotNull BingoConfig config, @NotNull CardViewService cardViewService, @NotNull MapItemService mapItemService, @NotNull IPlayerManager playerManager, @NotNull TeamService teamService, @NotNull ScopedEvents events, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)mapItemService, (String)"mapItemService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.state = state;
        this.config = config;
        this.cardViewService = cardViewService;
        this.mapItemService = mapItemService;
        this.playerManager = playerManager;
        this.teamService = teamService;
        ScopedEvents.onEnter$default(events, GameState.POSTGAME, false, arg_0 -> MapItemController._init_$lambda$0(this, arg_0), 2, null);
        eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> MapItemController._init_$lambda$1(this, arg_0));
    }

    private final void removePreviewCardItem(IPlayerHandle player) {
        for (Pair pair : player.allInventorySlots()) {
            int slot = ((Number)pair.component1()).intValue();
            IItemStack item2 = (IItemStack)pair.component2();
            if (!this.mapItemService.isPreviewMapItem(item2)) continue;
            player.removeStack(slot);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void giveMapCardItem(IPlayerHandle player, BingoTeam team) {
        boolean hasMap;
        void $this$count$iv;
        Object v0;
        block8: {
            if (this.cardViewService.supportsCardHud(player)) {
                return;
            }
            Sequence<Pair<Integer, IItemStack>> sequence = player.allInventorySlots();
            for (Object object : sequence) {
                Pair pair = (Pair)object;
                boolean bl = false;
                IItemStack stack = (IItemStack)pair.component2();
                if (!this.mapItemService.isMapItem(stack)) continue;
                v0 = object;
                break block8;
            }
            v0 = null;
        }
        Pair pair = v0;
        Integer previousSlot = pair != null ? (Integer)pair.getFirst() : null;
        Sequence sequence = SequencesKt.filter(player.allHeldStackViews(), arg_0 -> MapItemController.giveMapCardItem$lambda$1(this, arg_0));
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            boolean bl;
            boolean isItemValid;
            IContainerItemView view = (IContainerItemView)element$iv;
            boolean bl2 = false;
            boolean bl3 = isItemValid = team == null ? this.mapItemService.isPreviewMapItem(view.getStack()) : this.mapItemService.isMapTeamItem(view.getStack(), team);
            if (isItemValid) {
                view.mutate((Function1<? super IItemStack, Unit>)((Function1)MapItemController::giveMapCardItem$lambda$2$0));
                bl = true;
            } else {
                view.mutate((Function1<? super IItemStack, Unit>)((Function1)MapItemController::giveMapCardItem$lambda$2$1));
                bl = false;
            }
            if (!bl || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        boolean bl = hasMap = count$iv > 0;
        if (!hasMap) {
            IItemStack mapItem = team == null ? this.mapItemService.createPreviewMapItem() : this.mapItemService.createMapItem(team);
            Integer n = previousSlot;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl4 = false;
                player.setStack(it, mapItem);
            } else {
                player.giveItemStack(mapItem);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void giveSpectatorMapItems(IPlayerHandle player) {
        if (this.cardViewService.supportsCardHud(player)) {
            return;
        }
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)this.state.getRegisteredTeams(), (int)36);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean hasMap;
            boolean bl;
            void team;
            int i;
            block5: {
                void $this$any$iv;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BingoTeam bingoTeam = (BingoTeam)item$iv;
                i = n;
                boolean bl2 = false;
                Sequence<IItemStack> sequence = player.allHeldStacks();
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    IItemStack it = (IItemStack)element$iv;
                    boolean bl3 = false;
                    if (!this.mapItemService.isMapTeamItem(it, (BingoTeam)team)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (hasMap = bl) continue;
            IItemStack stack = this.mapItemService.createMapItem((BingoTeam)team);
            if (this.state.isLobbyMode()) {
                player.setStack(i, stack);
                continue;
            }
            player.giveItemStack(stack);
        }
    }

    private final void removeAllMapItems(IPlayerHandle player) {
        Sequence $this$forEach$iv = SequencesKt.filter(player.allHeldStackViews(), arg_0 -> MapItemController.removeAllMapItems$lambda$0(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IContainerItemView view = (IContainerItemView)element$iv;
            boolean bl = false;
            view.mutate((Function1<? super IItemStack, Unit>)((Function1)MapItemController::removeAllMapItems$lambda$1$0));
        }
    }

    private static final boolean giveMapCardItem$lambda$1(MapItemController this$0, IContainerItemView it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.mapItemService.isMapItem(it.getStack());
    }

    private static final Unit giveMapCardItem$lambda$2$0(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(1);
        return Unit.INSTANCE;
    }

    private static final Unit giveMapCardItem$lambda$2$1(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(0);
        return Unit.INSTANCE;
    }

    private static final boolean removeAllMapItems$lambda$0(MapItemController this$0, IContainerItemView it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.mapItemService.isMapItem(it.getStack());
    }

    private static final Unit removeAllMapItems$lambda$1$0(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(MapItemController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            this$0.removeAllMapItems(player);
            if (!this$0.state.isLobbyMode() || this$0.cardViewService.supportsCardHud(player)) continue;
            this$0.giveSpectatorMapItems(player);
        }
        if (!this$0.state.isLobbyMode() && this$0.config.getGiveMementoInSurvival()) {
            for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
                BingoTeam team;
                if (this$0.teamService.getPlayerTeam(player) == null) continue;
                IItemStack mapItem = this$0.mapItemService.createMementoMapItem(team);
                player.giveItemStack(mapItem);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MapItemController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            boolean canHaveCards;
            BingoTeam playerTeam = this$0.teamService.getPlayerTeam(player);
            boolean bl = canHaveCards = player.isAlive() && !player.isSpectator();
            if (canHaveCards) {
                if (this$0.cardViewService.isViewingSpectatorCards(player)) {
                    if (this$0.state.isLobbyMode()) {
                        this$0.giveSpectatorMapItems(player);
                    }
                } else if (playerTeam != null && this$0.cardViewService.isViewingTeamCard(player, playerTeam)) {
                    this$0.giveMapCardItem(player, playerTeam);
                }
            }
            if (canHaveCards && this$0.cardViewService.isViewingPreviewCard(player)) {
                this$0.giveMapCardItem(player, null);
            } else {
                this$0.removePreviewCardItem(player);
            }
            if (!this$0.cardViewService.supportsCardHud(player)) continue;
            this$0.removeAllMapItems(player);
        }
        return Unit.INSTANCE;
    }
}

