/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.config.ConfigManagerKt;
import me.jfenn.bingo.common.map.BingoMap;
import me.jfenn.bingo.common.map.CardImageService;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardView;
import me.jfenn.bingo.common.map.Color;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.utils.LruHashMap;
import me.jfenn.bingo.platform.IMapService;
import me.jfenn.bingo.platform.IMapState;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.config.IConfigManager;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 J2\u00020\u0001:\u0003JKLB7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0014\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001bJg\u0010'\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001c2M\b\u0004\u0010&\u001aG\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00130\u001eH\u0082\b\u00a2\u0006\u0004\b'\u0010(J\u0019\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010.\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010-H\u0002\u00a2\u0006\u0004\b.\u0010/J!\u00104\u001a\u00020\u00132\u0006\u00101\u001a\u0002002\b\u00103\u001a\u0004\u0018\u000102H\u0002\u00a2\u0006\u0004\b4\u00105J/\u00108\u001a\u00020\u00132\u0006\u00101\u001a\u0002002\u0006\u0010\u001d\u001a\u00020)2\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b8\u00109J-\u0010@\u001a\u00020=2\b\u00103\u001a\u0004\u0018\u0001022\u0006\u0010;\u001a\u00020:2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010\u00a2\u0006\u0004\b>\u0010?R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010CR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010DR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010ER\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010FR\"\u0010H\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010*0G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010I\u00a8\u0006M"}, d2={"Lme/jfenn/bingo/common/map/MapRenderService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "worldFactory", "Lme/jfenn/bingo/platform/IMapService;", "mapService", "Lme/jfenn/bingo/common/map/CardImageService;", "imageService", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/config/IConfigManager;", "configManager", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/platform/IMapService;Lme/jfenn/bingo/common/map/CardImageService;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/config/IConfigManager;)V", "", "", "items", "", "validateItems", "(Ljava/util/List;)V", "itemPath", "Ljava/io/InputStream;", "readTileImage", "(Ljava/lang/String;)Ljava/io/InputStream;", "clearCache", "()V", "Lme/jfenn/bingo/common/map/MapRenderService$TileImageKey;", "tile", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "x", "y", "", "color", "callback", "drawTileDecorations", "(Lme/jfenn/bingo/common/map/MapRenderService$TileImageKey;Lkotlin/jvm/functions/Function3;)V", "Lme/jfenn/bingo/common/map/CardTile;", "Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "getTileImage", "(Lme/jfenn/bingo/common/map/CardTile;)Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "Lnet/minecraft/class_124;", "getMapColor", "(Lnet/minecraft/class_124;)B", "Lme/jfenn/bingo/platform/IMapState;", "mapState", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "drawMapBorders", "(Lme/jfenn/bingo/platform/IMapState;Lme/jfenn/bingo/common/team/BingoTeam;)V", "itemX", "itemY", "drawMapTile", "(Lme/jfenn/bingo/platform/IMapState;Lme/jfenn/bingo/common/map/CardTile;II)V", "Lme/jfenn/bingo/common/map/BingoMap;", "map", "changedTiles", "Lkotlin/time/Duration;", "update-ZBGTal8", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/common/map/BingoMap;Ljava/util/List;)J", "update", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lme/jfenn/bingo/platform/IMapService;", "Lme/jfenn/bingo/common/map/CardImageService;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/config/IConfigManager;", "Lme/jfenn/bingo/common/utils/LruHashMap;", "imageMap", "Lme/jfenn/bingo/common/utils/LruHashMap;", "Companion", "BingoTileImage", "TileImageKey", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMapRenderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapRenderService.kt\nme/jfenn/bingo/common/map/MapRenderService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,480:1\n196#1,36:489\n233#1:529\n234#1,17:532\n252#1:550\n975#2:481\n1046#2,3:482\n975#2:525\n1046#2,3:526\n1878#3,3:485\n1878#3,2:530\n1880#3:549\n1617#3,9:551\n1869#3:560\n1870#3:562\n1626#3:563\n1#4:488\n1#4:561\n24#5:564\n63#5,3:565\n*S KotlinDebug\n*F\n+ 1 MapRenderService.kt\nme/jfenn/bingo/common/map/MapRenderService\n*L\n269#1:489,36\n269#1:529\n269#1:532,17\n269#1:550\n231#1:481\n231#1:482,3\n269#1:525\n269#1:526,3\n233#1:485,3\n269#1:530,2\n269#1:549\n421#1:551,9\n421#1:560\n421#1:562\n421#1:563\n421#1:561\n451#1:564\n451#1:565,3\n*E\n"})
public final class MapRenderService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger log;
    @NotNull
    private final IServerWorldFactory worldFactory;
    @NotNull
    private final IMapService mapService;
    @NotNull
    private final CardImageService imageService;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IConfigManager configManager;
    @NotNull
    private final LruHashMap<TileImageKey, BingoTileImage> imageMap;
    @NotNull
    private static final Color COLOR_BACKGROUND;
    @NotNull
    private static final Color COLOR_ITEM_SHADOW;
    @NotNull
    private static final Color COLOR_MARGIN;
    @NotNull
    private static final Color COLOR_SHADOW;
    @NotNull
    private static final Color COLOR_ACHIEVED;
    @NotNull
    private static final Color COLOR_FLASHING;
    @NotNull
    private static final Color COLOR_ACHIEVED_SHADOW;
    @NotNull
    private static final Color COLOR_LOCKED;
    @NotNull
    private static final Color COLOR_WHITE;
    private static final int MAP_SIZE = 128;
    private static final int MAP_BORDER = 5;
    private static final int TILE_IMAGE = 16;
    private static final int TILE_PADDING = 3;
    private static final int TILE_MARGIN = 2;
    private static final int TILE_SIZE = 24;
    private static final int IMAGE_SIZE = 22;
    @NotNull
    private static final byte[] IMAGE_FRAME_ADVANCEMENT;
    @NotNull
    private static final byte[] IMAGE_FRAME_FORBIDDEN;
    private static final int NUMBER_WIDTH = 5;
    private static final int NUMBER_HEIGHT = 7;
    @NotNull
    private static final byte[] NUMBERS;

    public MapRenderService(@NotNull Logger log, @NotNull IServerWorldFactory worldFactory, @NotNull IMapService mapService, @NotNull CardImageService imageService, @NotNull BingoState state, @NotNull IConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)worldFactory, (String)"worldFactory");
        Intrinsics.checkNotNullParameter((Object)mapService, (String)"mapService");
        Intrinsics.checkNotNullParameter((Object)imageService, (String)"imageService");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.log = log;
        this.worldFactory = worldFactory;
        this.mapService = mapService;
        this.imageService = imageService;
        this.state = state;
        this.configManager = configManager;
        this.imageMap = new LruHashMap(200);
    }

    public final void validateItems(@NotNull List<String> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        for (String item2 : items) {
            try {
                InputStream inputStream = this.readTileImage(item2);
                Intrinsics.checkNotNull((Object)inputStream);
                inputStream.close();
            }
            catch (Throwable e) {
                Logger log = LoggerFactory.getLogger((String)"bingo");
                log.warn("Missing item image: " + StringsKt.replace$default((String)item2, (char)':', (char)'/', (boolean)false, (int)4, null) + ".png");
            }
        }
    }

    private final InputStream readTileImage(String itemPath) {
        InputStream inputStream;
        InputStream inputStream2;
        String namespace = StringsKt.substringBefore$default((String)itemPath, (char)':', null, (int)2, null);
        String path = StringsKt.substringAfter$default((String)itemPath, (char)':', null, (int)2, null);
        try {
            inputStream2 = ConfigManagerKt.readStream(this.configManager, "images/" + path + ".png", false, (Function0<? extends InputStream>)((Function0)() -> MapRenderService.readTileImage$lambda$0(path)));
        }
        catch (NullPointerException e) {
            inputStream2 = null;
        }
        if ((inputStream = inputStream2) == null) {
            try {
                inputStream2 = ConfigManagerKt.readStream(this.configManager, "images/" + namespace + "/" + path + ".png", false, (Function0<? extends InputStream>)((Function0)() -> MapRenderService.readTileImage$lambda$1(namespace, path)));
            }
            catch (NullPointerException e) {
                inputStream2 = null;
            }
            inputStream = inputStream2;
        }
        return inputStream;
    }

    public final void clearCache() {
        this.imageMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawTileDecorations(TileImageKey tile, Function3<? super Integer, ? super Integer, ? super Byte, Unit> callback) {
        int offset;
        int innerT;
        byte color2;
        int frameIndex;
        int y;
        int x;
        boolean $i$f$drawTileDecorations = false;
        if (tile.getDecoration() == CardTile.Decoration.ADVANCEMENT) {
            for (x = 0; x < 22; ++x) {
                for (y = 0; y < 22; ++y) {
                    frameIndex = x + y * 22;
                    boolean bl = 0 <= frameIndex ? frameIndex < IMAGE_FRAME_ADVANCEMENT.length : false;
                    if (!bl || (color2 = IMAGE_FRAME_ADVANCEMENT[frameIndex]) == 0) continue;
                    callback.invoke((Object)x, (Object)y, (Object)color2);
                }
            }
        }
        if (ArraysKt.contains((Object[])CardTile.Companion.getMULTI_ITEM_ENUMS(), (Object)((Object)tile.getDecoration())) && (innerT = (offset = 6) - 2) <= (frameIndex = offset + 2)) {
            while (true) {
                callback.invoke((Object)offset, (Object)innerT, (Object)COLOR_WHITE.getAsByte());
                callback.invoke((Object)innerT, (Object)offset, (Object)COLOR_WHITE.getAsByte());
                if (innerT == frameIndex) break;
                ++innerT;
            }
        }
        if (tile.getDecoration() == CardTile.Decoration.FORBIDDEN) {
            for (x = 0; x < 22; ++x) {
                for (y = 0; y < 22; ++y) {
                    frameIndex = x + y * 22;
                    boolean bl = 0 <= frameIndex ? frameIndex < IMAGE_FRAME_FORBIDDEN.length : false;
                    if (!bl || (color2 = IMAGE_FRAME_FORBIDDEN[frameIndex]) == 0) continue;
                    callback.invoke((Object)x, (Object)y, (Object)color2);
                }
            }
        }
        if (tile.getCount() > 1) {
            int item$iv$iv;
            void $this$mapTo$iv$iv;
            int n;
            void $this$map$iv;
            CharSequence y2 = String.valueOf(tile.getCount());
            boolean $i$f$map = false;
            void color3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (n = 0; n < $this$mapTo$iv$iv.length(); ++n) {
                void it;
                int n2 = item$iv$iv = $this$mapTo$iv$iv.charAt(n);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CharsKt.digitToInt((char)it));
            }
            List digits = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = digits;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = ((Number)item$iv).intValue();
                int index = n;
                boolean bl = false;
                int startX = 20 - (digits.size() - index) * 6 + 1;
                int startY = 13;
                for (int x2 = 0; x2 < 5; ++x2) {
                    for (int y3 = 0; y3 < 7; ++y3) {
                        byte color4;
                        void digit;
                        void imageIndex = digit * 5 + x2 + y3 * 5 * 10;
                        boolean bl2 = false <= imageIndex ? imageIndex < NUMBERS.length : false;
                        if (!bl2) continue;
                        int drawX = startX + x2;
                        int drawY = startY + y3;
                        boolean bl3 = 0 <= drawX ? drawX < 21 : false;
                        if (!bl3 || (color4 = NUMBERS[imageIndex]) == 0) continue;
                        callback.invoke((Object)drawX, (Object)drawY, (Object)color4);
                        callback.invoke((Object)(drawX + 1), (Object)(drawY + 1), (Object)COLOR_ITEM_SHADOW.getAsByte());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final BingoTileImage getTileImage(CardTile tile) {
        v0 = tile.getMapRenderKey$bingo_common();
        if (v0 == null) {
            return null;
        }
        key = v0;
        if (this.imageMap.containsKey(key)) {
            v1 = (BingoTileImage)this.imageMap.get(key);
            if (v1 == null) {
                v1 = BingoTileImage.Companion.getFALLBACK();
            }
            return v1;
        }
        try {
            var4_3 = key.getImage();
            if (var4_3 == null) ** GOTO lbl-1000
            it = var4_3;
            $i$a$-let-MapRenderService$getTileImage$imageStream$1 = false;
            var5_9 /* !! */  = this.imageService.readCardImageStream((String)it);
            if (var5_9 /* !! */  != null) {
                v2 = var5_9 /* !! */ ;
            } else if ((v2 = this.readTileImage(key.getName())) == null) {
                return null;
            }
            imageStream = v2;
            var5_9 /* !! */  = imageStream;
            var6_11 = null;
            try {
                it = var5_9 /* !! */ ;
                $i$a$-use-MapRenderService$getTileImage$image$1 = false;
                it = ImageIO.read((InputStream)it);
            }
            catch (Throwable $i$a$-use-MapRenderService$getTileImage$image$1) {
                var6_11 = $i$a$-use-MapRenderService$getTileImage$image$1;
                throw $i$a$-use-MapRenderService$getTileImage$image$1;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var5_9 /* !! */ , (Throwable)var6_11);
            }
            image = it;
            Intrinsics.checkNotNull((Object)image);
            tileImage = BingoTileImage.Companion.fromBufferedImage((BufferedImage)image);
            var6_11 = this;
            tile$iv = key;
            $i$f$drawTileDecorations = false;
            if (tile$iv.getDecoration() == CardTile.Decoration.ADVANCEMENT) {
                for (x$iv = 0; x$iv < 22; ++x$iv) {
                    for (y$iv = 0; y$iv < 22; ++y$iv) {
                        frameIndex$iv = x$iv + y$iv * 22;
                        v3 = 0 <= frameIndex$iv ? frameIndex$iv < MapRenderService.IMAGE_FRAME_ADVANCEMENT.length : false;
                        if (!v3 || (color$iv = MapRenderService.IMAGE_FRAME_ADVANCEMENT[frameIndex$iv]) == 0) continue;
                        var13_20 = color$iv;
                        var14_21 = y$iv;
                        x = x$iv;
                        $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                        index = x + y * 22;
                        tileImage.getRegular()[index] = color;
                        tileImage.getFlashing()[index] = color;
                        tileImage.getAchieved()[index] = color;
                    }
                }
            }
            if (ArraysKt.contains((Object[])CardTile.Companion.getMULTI_ITEM_ENUMS(), (Object)tile$iv.getDecoration()) && (innerT$iv = (offset$iv = 6) - 2) <= (frameIndex$iv = offset$iv + 2)) {
                while (true) {
                    color = MapRenderService.COLOR_WHITE.getAsByte();
                    y = innerT$iv;
                    x = offset$iv;
                    $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                    index = x + y * 22;
                    tileImage.getRegular()[index] = color;
                    tileImage.getFlashing()[index] = color;
                    tileImage.getAchieved()[index] = color;
                    color = MapRenderService.COLOR_WHITE.getAsByte();
                    y = offset$iv;
                    x = innerT$iv;
                    $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                    index = x + y * 22;
                    tileImage.getRegular()[index] = color;
                    tileImage.getFlashing()[index] = color;
                    tileImage.getAchieved()[index] = color;
                    if (innerT$iv == frameIndex$iv) break;
                    ++innerT$iv;
                }
            }
            if (tile$iv.getDecoration() == CardTile.Decoration.FORBIDDEN) {
                for (x$iv = 0; x$iv < 22; ++x$iv) {
                    for (y$iv = 0; y$iv < 22; ++y$iv) {
                        frameIndex$iv = x$iv + y$iv * 22;
                        v4 = 0 <= frameIndex$iv ? frameIndex$iv < MapRenderService.IMAGE_FRAME_FORBIDDEN.length : false;
                        if (!v4 || (color$iv = MapRenderService.IMAGE_FRAME_FORBIDDEN[frameIndex$iv]) == 0) continue;
                        color = color$iv;
                        y = y$iv;
                        x = x$iv;
                        $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                        index = x + y * 22;
                        tileImage.getRegular()[index] = color;
                        tileImage.getFlashing()[index] = color;
                        tileImage.getAchieved()[index] = color;
                    }
                }
            }
            if (tile$iv.getCount() > 1) {
                y$iv = String.valueOf(tile$iv.getCount());
                $i$f$map = false;
                color$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList<E>($this$map$iv$iv.length());
                $i$f$mapTo = false;
                for (var20_28 = 0; var20_28 < $this$mapTo$iv$iv$iv.length(); ++var20_28) {
                    var22_30 = item$iv$iv$iv = $this$mapTo$iv$iv$iv.charAt(var20_28);
                    var23_31 = destination$iv$iv$iv;
                    $i$a$-map-MapRenderService$drawTileDecorations$digits$1$iv = false;
                    var23_31.add(CharsKt.digitToInt((char)it$iv));
                }
                digits$iv = (List)destination$iv$iv$iv;
                $this$forEachIndexed$iv$iv = digits$iv;
                $i$f$forEachIndexed = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$forEachIndexed$iv$iv) {
                    if ((var20_28 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    item$iv$iv$iv = ((Number)item$iv$iv).intValue();
                    index$iv = var20_28;
                    $i$a$-forEachIndexed-MapRenderService$drawTileDecorations$1$iv = false;
                    startX$iv = 20 - (digits$iv.size() - index$iv) * 6 + 1;
                    startY$iv = 13;
                    for (x$iv = 0; x$iv < 5; ++x$iv) {
                        for (y$iv = 0; y$iv < 7; ++y$iv) {
                            imageIndex$iv = digit$iv * 5 + x$iv + y$iv * 5 * 10;
                            v5 = false <= imageIndex$iv ? imageIndex$iv < MapRenderService.NUMBERS.length : false;
                            if (!v5) continue;
                            drawX$iv = startX$iv + x$iv;
                            drawY$iv = startY$iv + y$iv;
                            v6 = 0 <= drawX$iv ? drawX$iv < 21 : false;
                            if (!v6 || (color$iv = MapRenderService.NUMBERS[imageIndex$iv]) == 0) continue;
                            var28_36 = color$iv;
                            var29_37 = drawY$iv;
                            x = drawX$iv;
                            $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                            index = x + y * 22;
                            tileImage.getRegular()[index] = color;
                            tileImage.getFlashing()[index] = color;
                            tileImage.getAchieved()[index] = color;
                            color = MapRenderService.COLOR_ITEM_SHADOW.getAsByte();
                            y = drawY$iv + 1;
                            x = drawX$iv + 1;
                            $i$a$-drawTileDecorations-MapRenderService$getTileImage$1 = false;
                            index = x + y * 22;
                            tileImage.getRegular()[index] = color;
                            tileImage.getFlashing()[index] = color;
                            tileImage.getAchieved()[index] = color;
                        }
                    }
                }
            }
            ((Map)this.imageMap).put(key, tileImage);
            return tileImage;
        }
        catch (Throwable e) {
            v7 = tile.getImage().getItem();
            this.log.error("Error reading item image: " + (class_2960)(v7 != null ? v7.getIdentifier() : null), e);
            ((Map)this.imageMap).put(key, null);
            return BingoTileImage.Companion.getFALLBACK();
        }
    }

    private final byte getMapColor(class_124 color2) {
        class_124 class_1242 = color2;
        return switch (class_1242 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[class_1242.ordinal()]) {
            case 1 -> 31;
            case 2 -> 29;
            case 3 -> 12;
            case 4 -> 23;
            case 5 -> 25;
            case 6, 7 -> 21;
            case 8 -> 7;
            case 9 -> 24;
            case 10 -> 28;
            case 11 -> 15;
            case 12 -> 33;
            case 13 -> 20;
            case 14 -> 4;
            case 15 -> 14;
            case 16 -> 30;
            default -> 22;
        };
    }

    private final void drawMapBorders(IMapState mapState, BingoTeam team) {
        int yActual;
        int y;
        int x;
        BingoTeam bingoTeam = team;
        byte borderLight = UByte.constructor-impl((byte)((byte)(this.getMapColor((class_124)(bingoTeam != null ? bingoTeam.getTextColor() : null)) * 4 + 2)));
        BingoTeam bingoTeam2 = team;
        byte borderMid = UByte.constructor-impl((byte)((byte)(this.getMapColor((class_124)(bingoTeam2 != null ? bingoTeam2.getTextColor() : null)) * 4 + 1)));
        BingoTeam bingoTeam3 = team;
        byte borderDark = UByte.constructor-impl((byte)((byte)(this.getMapColor((class_124)(bingoTeam3 != null ? bingoTeam3.getTextColor() : null)) * 4 + 3)));
        for (x = 0; x < 128; ++x) {
            mapState.setColor(x, 0, borderLight);
            mapState.setColor(0, x, borderLight);
            mapState.setColor(x, 127, borderDark);
            mapState.setColor(127, x, borderDark);
        }
        for (x = 1; x < 127; ++x) {
            for (y = 1; y < 4; ++y) {
                int yInv = 128 - y - 1;
                mapState.setColor(x, y, borderMid);
                mapState.setColor(y, x, borderMid);
                mapState.setColor(x, yInv, borderMid);
                mapState.setColor(yInv, x, borderMid);
            }
        }
        for (x = 4; x < 124; ++x) {
            mapState.setColor(x, 4, borderDark);
            mapState.setColor(4, x, borderDark);
            mapState.setColor(x, 123, borderLight);
            mapState.setColor(123, x, borderLight);
        }
        for (x = 5; x < 123; ++x) {
            for (y = 1; y < 5; ++y) {
                yActual = 5 + y * 24 - 2 + 1;
                mapState.setColor(x, yActual, COLOR_SHADOW.getAsByte());
                mapState.setColor(yActual, x, COLOR_SHADOW.getAsByte());
            }
        }
        for (x = 5; x < 123; ++x) {
            for (y = 1; y < 5; ++y) {
                yActual = 5 + y * 24 - 2;
                mapState.setColor(x, yActual, COLOR_MARGIN.getAsByte());
                mapState.setColor(yActual, x, COLOR_MARGIN.getAsByte());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawMapTile(IMapState mapState, CardTile tile, int itemX, int itemY) {
        int x;
        int n;
        int innerT;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        BingoTileImage tileImage;
        boolean isRegularTile;
        block30: {
            block27: {
                block28: {
                    block29: {
                        block26: {
                            block25: {
                                boolean bl = 0 <= itemX ? itemX < 5 : false;
                                if (!bl) break block25;
                                if (0 <= itemY ? itemY < 5 : false) break block26;
                            }
                            this.log.error("drawMapTile() called with an invalid item position! (" + itemX + "," + itemY + ")");
                            return;
                        }
                        isRegularTile = false;
                        BingoTileImage bingoTileImage = this.getTileImage(tile);
                        if (bingoTileImage == null) {
                            bingoTileImage = BingoTileImage.Companion.getEMPTY();
                        }
                        tileImage = bingoTileImage;
                        if (!tile.isHidden()) break block27;
                        if (tile.getItemTier() == null) break block28;
                        BingoTileImage bingoTileImage2 = BingoTileImage.Companion.getHIDDEN_TIERS().get((Object)tile.getItemTier());
                        object = bingoTileImage2;
                        if (bingoTileImage2 == null) break block29;
                        byte[] byArray = object.getRegular();
                        object = byArray;
                        if (byArray != null) break block30;
                    }
                    object = BingoTileImage.Companion.getFALLBACK().getRegular();
                    break block30;
                }
                object = BingoTileImage.Companion.getHIDDEN().getRegular();
                break block30;
            }
            if (tile.isFlashingOnMap()) {
                object = tileImage.getFlashing();
            } else if (tile.isAchieved()) {
                object = tileImage.getAchieved();
            } else {
                isRegularTile = true;
                object = tileImage.getRegular();
            }
        }
        byte[] tileImageArray = object;
        int tileX = 5 + 24 * itemX;
        int tileY = 5 + 24 * itemY;
        int innerMax = 21;
        int innerY = 0;
        while (true) {
            int y = tileY + innerY;
            int mapStateStart = tileX + y * 128;
            int tileImageStart = innerY * 22;
            byte[] arr = isRegularTile && (float)innerY > (float)innerMax * (1.0f - tile.getProgress()) ? tileImage.getFlashing() : tileImageArray;
            mapState.copyFrom(arr, mapStateStart, tileImageStart, tileImageStart + 22);
            if (innerY == innerMax) break;
            ++innerY;
        }
        if (tile.isLocked()) {
            int innerT2 = 0;
            while (true) {
                int x2 = tileX + innerT2;
                int y = tileY + innerT2;
                mapState.setColor(x2, y, COLOR_LOCKED.getAsByte());
                int yInv = tileY + innerMax - innerT2;
                mapState.setColor(x2, yInv, COLOR_LOCKED.getAsByte());
                if (innerT2 > 0) {
                    mapState.setColor(x2 - 1, y, COLOR_LOCKED.getAsByte());
                    mapState.setColor(x2 - 1, yInv, COLOR_LOCKED.getAsByte());
                }
                if (innerT2 == innerMax) break;
                ++innerT2;
            }
        }
        Iterable $this$mapNotNull$iv = tile.getTeamKeys();
        boolean $i$f$mapNotNull = false;
        Iterable yInv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BingoTeam it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = ((BingoTeamKey)element$iv$iv).unbox-impl();
            boolean bl2 = false;
            if (this.state.getTeams().get(BingoTeamKey.box-impl(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List teams2 = (List)destination$iv$iv;
        if (!((Collection)teams2).isEmpty() && (innerT = 0) <= (n = innerMax * 2 + 1)) {
            while (true) {
                int tileTeamX;
                BingoTeam bingoTeam;
                if ((bingoTeam = (BingoTeam)CollectionsKt.getOrNull((List)teams2, (int)(tileTeamX = innerT * teams2.size() / (innerMax * 2 + 1)))) != null && (bingoTeam = bingoTeam.getMapColor()) != null) {
                    BingoTeam itemTeam = bingoTeam;
                    int variant = innerT % 2 == 0 ? 2 : 3;
                    byte color2 = UByte.constructor-impl((byte)((byte)(this.getMapColor((class_124)itemTeam) * 4 + variant)));
                    if (innerT < innerMax) {
                        mapState.setColor(tileX + innerT, tileY, color2);
                        mapState.setColor(tileX, tileY + innerT, color2);
                    } else {
                        mapState.setColor(tileX + innerT - innerMax, tileY + innerMax, color2);
                        mapState.setColor(tileX + innerMax, tileY + innerT - innerMax, color2);
                    }
                }
                if (innerT == n) break;
                ++innerT;
            }
        }
        if ((x = tileX) <= (n = tileX + innerMax)) {
            while (true) {
                int n2;
                int y;
                if ((y = tileY) <= (n2 = tileY + innerMax)) {
                    while (true) {
                        mapState.markDirty(x, y);
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    public final long update-ZBGTal8(@Nullable BingoTeam team, @NotNull BingoMap map, @NotNull List<Integer> changedTiles) {
        long l;
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter(changedTiles, (String)"changedTiles");
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        IMapState iMapState = map.getMapState();
        if (iMapState == null) {
            boolean bl2 = false;
            IMapState state = this.mapService.createMapState((byte)1, true, this.worldFactory.getOverworld());
            this.drawMapBorders(state, team);
            this.mapService.putMapState(map.getMapId(), state);
            map.setMapState(state);
            iMapState = state;
        }
        IMapState state = iMapState;
        CardView cardView = map.getView();
        if (cardView != null) {
            CardView view = cardView;
            Iterator<Integer> iterator = changedTiles.iterator();
            while (iterator.hasNext()) {
                CardTile tile;
                int index = ((Number)iterator.next()).intValue();
                if ((CardTile)CollectionsKt.getOrNull(view.getTiles(), (int)index) == null) continue;
                int x = index % 5;
                int y = index / 5;
                this.drawMapTile(state, tile, x, y);
            }
        }
        long it = l = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl3 = false;
        if (Duration.compareTo-LRDsOJo((long)it, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MILLISECONDS)) >= 0) {
            Object object;
            Object object2 = team;
            this.log.info("Re-drawing map_" + (object2 != null && (object2 = ((BingoTeam)object2).getMap()) != null ? Integer.valueOf(((BingoMap)object2).getMapId()) : null) + " for team " + ((object = team) != null && (object = ((BingoTeam)object).getId()) != null ? StringsKt.removePrefix((String)object, (CharSequence)"bingo_") : null) + " (" + Duration.toString-impl((long)it) + ")");
        }
        return l;
    }

    private static final InputStream readTileImage$lambda$0(String $path) {
        InputStream inputStream = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/images/" + $path + ".png");
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    private static final InputStream readTileImage$lambda$1(String $namespace, String $path) {
        InputStream inputStream = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/images/" + $namespace + "/" + $path + ".png");
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    public static final /* synthetic */ Color access$getCOLOR_ITEM_SHADOW$cp() {
        return COLOR_ITEM_SHADOW;
    }

    public static final /* synthetic */ Color access$getCOLOR_ACHIEVED_SHADOW$cp() {
        return COLOR_ACHIEVED_SHADOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedImage bufferedImage;
        Object it;
        Companion = new Companion(null);
        COLOR_BACKGROUND = new Color(130, 130, 130, 0, 8, null);
        COLOR_ITEM_SHADOW = new Color(100, 100, 100, 0, 8, null);
        COLOR_MARGIN = new Color(199, 199, 199, 0, 8, null);
        COLOR_SHADOW = new Color(20, 20, 20, 0, 8, null);
        COLOR_ACHIEVED = new Color(100, 255, 100, 0, 8, null);
        COLOR_FLASHING = new Color(178, 76, 216, 0, 8, null);
        COLOR_ACHIEVED_SHADOW = new Color(80, 120, 80, 0, 8, null);
        COLOR_LOCKED = new Color(150, 0, 0, 0, 8, null);
        COLOR_WHITE = new Color(255, 255, 255, 0, 8, null);
        Closeable closeable = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/image_frame_advancement.png");
        Companion companion = Companion;
        Throwable throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            it = ImageIO.read((InputStream)it);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object object = it;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
        IMAGE_FRAME_ADVANCEMENT = companion.toMinecraftByteArray((BufferedImage)object);
        closeable = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/image_frame_forbidden.png");
        companion = Companion;
        throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            it = ImageIO.read((InputStream)it);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object object2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"use(...)");
        IMAGE_FRAME_FORBIDDEN = companion.toMinecraftByteArray((BufferedImage)object2);
        closeable = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/numbers.png");
        companion = Companion;
        throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            bufferedImage = ImageIO.read((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"use(...)");
        NUMBERS = companion.toMinecraftByteArray(bufferedImage2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u0000 \r2\u00020\u0001:\u0001\rB%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\b\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "", "", "regular", "flashing", "achieved", "<init>", "([B[B[B)V", "[B", "getRegular", "()[B", "getFlashing", "getAchieved", "Companion", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nMapRenderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapRenderService.kt\nme/jfenn/bingo/common/map/MapRenderService$BingoTileImage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,480:1\n1#2:481\n1285#3,2:482\n1299#3,4:484\n*S KotlinDebug\n*F\n+ 1 MapRenderService.kt\nme/jfenn/bingo/common/map/MapRenderService$BingoTileImage\n*L\n127#1:482,2\n127#1:484,4\n*E\n"})
    public static final class BingoTileImage {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final byte[] regular;
        @NotNull
        private final byte[] flashing;
        @NotNull
        private final byte[] achieved;
        @NotNull
        private static final BingoTileImage EMPTY;
        @NotNull
        private static final BingoTileImage FALLBACK;
        @NotNull
        private static final BingoTileImage HIDDEN;
        @NotNull
        private static final Map<TierLabel, BingoTileImage> HIDDEN_TIERS;

        public BingoTileImage(@NotNull byte[] regular, @NotNull byte[] flashing, @NotNull byte[] achieved) {
            Intrinsics.checkNotNullParameter((Object)regular, (String)"regular");
            Intrinsics.checkNotNullParameter((Object)flashing, (String)"flashing");
            Intrinsics.checkNotNullParameter((Object)achieved, (String)"achieved");
            this.regular = regular;
            this.flashing = flashing;
            this.achieved = achieved;
        }

        public /* synthetic */ BingoTileImage(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            int n2;
            byte[] byArray4;
            int n3;
            if ((n & 1) != 0) {
                n3 = 0;
                byArray4 = new byte[484];
                while (n3 < 484) {
                    n2 = n3++;
                    byArray4[n2] = COLOR_BACKGROUND.getAsByte();
                }
                byArray = byArray4;
            }
            if ((n & 2) != 0) {
                n3 = 0;
                byArray4 = new byte[484];
                while (n3 < 484) {
                    n2 = n3++;
                    byArray4[n2] = COLOR_FLASHING.getAsByte();
                }
                byArray2 = byArray4;
            }
            if ((n & 4) != 0) {
                n3 = 0;
                byArray4 = new byte[484];
                while (n3 < 484) {
                    n2 = n3++;
                    byArray4[n2] = COLOR_ACHIEVED.getAsByte();
                }
                byArray3 = byArray4;
            }
            this(byArray, byArray2, byArray3);
        }

        @NotNull
        public final byte[] getRegular() {
            return this.regular;
        }

        @NotNull
        public final byte[] getFlashing() {
            return this.flashing;
        }

        @NotNull
        public final byte[] getAchieved() {
            return this.achieved;
        }

        public BingoTileImage() {
            this(null, null, null, 7, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        static {
            void $this$associateWithTo$iv$iv;
            Object it;
            Companion = new Companion(null);
            EMPTY = new BingoTileImage(null, null, null, 7, null);
            Closeable closeable = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/image_fallback.png");
            Throwable throwable = null;
            try {
                it = (InputStream)closeable;
                boolean bl = false;
                it = ImageIO.read((InputStream)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object it2 = it;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            FALLBACK = Companion.fromBufferedImage((BufferedImage)it2);
            closeable = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/image_hidden.png");
            it2 = null;
            try {
                it = (InputStream)closeable;
                boolean bl2 = false;
                it = ImageIO.read((InputStream)it);
            }
            catch (Throwable bl2) {
                it2 = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)it2);
            }
            it2 = it;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it2);
            HIDDEN = Companion.fromBufferedImage((BufferedImage)it2);
            Iterable $this$associateWith$iv = (Iterable)TierLabel.getEntries();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable bl2 = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                Object it3;
                void tier;
                TierLabel tierLabel = (TierLabel)((Object)element$iv$iv);
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl4 = false;
                String string = tier.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                Closeable closeable2 = MapRenderService.class.getResourceAsStream("/yet-another-minecraft-bingo/image_hidden_" + string + ".png");
                Throwable throwable2 = null;
                try {
                    it3 = (InputStream)closeable2;
                    boolean bl5 = false;
                    it3 = ImageIO.read((InputStream)it3);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Object it4 = it3;
                boolean bl6 = false;
                Intrinsics.checkNotNull((Object)it4);
                BingoTileImage bingoTileImage = Companion.fromBufferedImage((BufferedImage)it4);
                map.put(t, bingoTileImage);
            }
            HIDDEN_TIERS = destination$iv$iv;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR#\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00060\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage$Companion;", "", "<init>", "()V", "Ljava/awt/image/BufferedImage;", "image", "Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "fromBufferedImage", "(Ljava/awt/image/BufferedImage;)Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "EMPTY", "Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "getEMPTY", "()Lme/jfenn/bingo/common/map/MapRenderService$BingoTileImage;", "FALLBACK", "getFALLBACK", "HIDDEN", "getHIDDEN", "", "Lme/jfenn/bingo/common/card/tierlist/TierLabel;", "HIDDEN_TIERS", "Ljava/util/Map;", "getHIDDEN_TIERS", "()Ljava/util/Map;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BingoTileImage getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final BingoTileImage getFALLBACK() {
                return FALLBACK;
            }

            @NotNull
            public final BingoTileImage getHIDDEN() {
                return HIDDEN;
            }

            @NotNull
            public final Map<TierLabel, BingoTileImage> getHIDDEN_TIERS() {
                return HIDDEN_TIERS;
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final BingoTileImage fromBufferedImage(@NotNull BufferedImage image) {
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                tileImage = new BingoTileImage(null, null, null, 7, null);
                for (x = 0; x < 22; ++x) {
                    for (y = 0; y < 22; ++y) {
                        i = x + y * 22;
                        imgX = x - 3;
                        imgY = y - 3;
                        imageNearestX = imgX * image.getWidth() / 16;
                        imageNearestY = imgY * image.getHeight() / 16;
                        v0 = 0 <= imageNearestX ? imageNearestX < image.getWidth() : false;
                        if (!v0) ** GOTO lbl-1000
                        v1 = 0 <= imageNearestY ? imageNearestY < image.getHeight() : false;
                        if (v1) {
                            v2 = Color.Companion.fromInt(image.getRGB(imageNearestX, imageNearestY));
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = Color.Companion.fromInt(0);
                        }
                        color = v2;
                        var12_12 = image.getWidth();
                        var13_13 = imageNearestX - 1;
                        v3 = 0 <= var13_13 ? var13_13 < var12_12 : false;
                        if (!v3) ** GOTO lbl-1000
                        var12_12 = image.getHeight();
                        var13_13 = imageNearestY - 1;
                        v4 = 0 <= var13_13 ? var13_13 < var12_12 : false;
                        if (v4) {
                            v5 = Color.Companion.fromInt(image.getRGB(imageNearestX - 1, imageNearestY - 1));
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = prevColor = Color.Companion.fromInt(0);
                        }
                        if (color.getA() == 0) {
                            if (prevColor.getA() == 0) continue;
                            tileImage.getRegular()[i] = MapRenderService.access$getCOLOR_ITEM_SHADOW$cp().getAsByte();
                            tileImage.getFlashing()[i] = MapRenderService.access$getCOLOR_ITEM_SHADOW$cp().getAsByte();
                            tileImage.getAchieved()[i] = MapRenderService.access$getCOLOR_ACHIEVED_SHADOW$cp().getAsByte();
                            continue;
                        }
                        if (color.getA() < 255) {
                            color = MapRenderService.access$getCOLOR_BACKGROUND$cp().mix(Color.copy$default(color, 0, 0, 0, RangesKt.coerceAtMost((int)(color.getA() * 2), (int)255), 7, null));
                        }
                        tileImage.getRegular()[i] = color.getAsByte();
                        tileImage.getFlashing()[i] = color.getAsByte();
                        tileImage.getAchieved()[i] = MapRenderService.access$getCOLOR_ACHIEVED$cp().mix(Color.copy$default(color, 0, 0, 0, 200, 7, null)).getAsByte();
                    }
                }
                return tileImage;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u0015R\u0014\u0010!\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001d\u00a8\u0006\""}, d2={"Lme/jfenn/bingo/common/map/MapRenderService$Companion;", "", "<init>", "()V", "Ljava/awt/image/BufferedImage;", "", "toMinecraftByteArray", "(Ljava/awt/image/BufferedImage;)[B", "Lme/jfenn/bingo/common/map/Color;", "COLOR_BACKGROUND", "Lme/jfenn/bingo/common/map/Color;", "COLOR_ITEM_SHADOW", "COLOR_MARGIN", "COLOR_SHADOW", "COLOR_ACHIEVED", "COLOR_FLASHING", "COLOR_ACHIEVED_SHADOW", "COLOR_LOCKED", "COLOR_WHITE", "", "MAP_SIZE", "I", "MAP_BORDER", "TILE_IMAGE", "TILE_PADDING", "TILE_MARGIN", "TILE_SIZE", "IMAGE_SIZE", "IMAGE_FRAME_ADVANCEMENT", "[B", "IMAGE_FRAME_FORBIDDEN", "NUMBER_WIDTH", "NUMBER_HEIGHT", "NUMBERS", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] toMinecraftByteArray(BufferedImage $this$toMinecraftByteArray) {
            int n;
            int n2 = 0;
            int n3 = $this$toMinecraftByteArray.getWidth() * $this$toMinecraftByteArray.getHeight();
            byte[] byArray = new byte[n3];
            while (n2 < n3) {
                n = n2++;
                byArray[n] = 0;
            }
            byte[] arr = byArray;
            n3 = $this$toMinecraftByteArray.getWidth();
            for (int x = 0; x < n3; ++x) {
                n = $this$toMinecraftByteArray.getHeight();
                for (int y = 0; y < n; ++y) {
                    Color color2 = Color.Companion.fromInt($this$toMinecraftByteArray.getRGB(x, y));
                    if (color2.getA() == 0) continue;
                    arr[x + y * $this$toMinecraftByteArray.getWidth()] = color2.getAsByte();
                }
            }
            return arr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J<\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\fR\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\u000fR\u0019\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0011\u00a8\u0006!"}, d2={"Lme/jfenn/bingo/common/map/MapRenderService$TileImageKey;", "", "", "name", "image", "", "count", "Lme/jfenn/bingo/common/map/CardTile$Decoration;", "decoration", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILme/jfenn/bingo/common/map/CardTile$Decoration;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "()I", "component4", "()Lme/jfenn/bingo/common/map/CardTile$Decoration;", "copy", "(Ljava/lang/String;Ljava/lang/String;ILme/jfenn/bingo/common/map/CardTile$Decoration;)Lme/jfenn/bingo/common/map/MapRenderService$TileImageKey;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "getImage", "I", "getCount", "Lme/jfenn/bingo/common/map/CardTile$Decoration;", "getDecoration", "bingo-common"})
    public static final class TileImageKey {
        @NotNull
        private final String name;
        @Nullable
        private final String image;
        private final int count;
        @Nullable
        private final CardTile.Decoration decoration;

        public TileImageKey(@NotNull String name2, @Nullable String image2, int count, @Nullable CardTile.Decoration decoration) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.image = image2;
            this.count = count;
            this.decoration = decoration;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getImage() {
            return this.image;
        }

        public final int getCount() {
            return this.count;
        }

        @Nullable
        public final CardTile.Decoration getDecoration() {
            return this.decoration;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.image;
        }

        public final int component3() {
            return this.count;
        }

        @Nullable
        public final CardTile.Decoration component4() {
            return this.decoration;
        }

        @NotNull
        public final TileImageKey copy(@NotNull String name2, @Nullable String image2, int count, @Nullable CardTile.Decoration decoration) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new TileImageKey(name2, image2, count, decoration);
        }

        public static /* synthetic */ TileImageKey copy$default(TileImageKey tileImageKey, String string, String string2, int n, CardTile.Decoration decoration, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tileImageKey.name;
            }
            if ((n2 & 2) != 0) {
                string2 = tileImageKey.image;
            }
            if ((n2 & 4) != 0) {
                n = tileImageKey.count;
            }
            if ((n2 & 8) != 0) {
                decoration = tileImageKey.decoration;
            }
            return tileImageKey.copy(string, string2, n, decoration);
        }

        @NotNull
        public String toString() {
            return "TileImageKey(name=" + this.name + ", image=" + this.image + ", count=" + this.count + ", decoration=" + this.decoration + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.image == null ? 0 : this.image.hashCode());
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + (this.decoration == null ? 0 : this.decoration.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TileImageKey)) {
                return false;
            }
            TileImageKey tileImageKey = (TileImageKey)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)tileImageKey.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.image, (Object)tileImageKey.image)) {
                return false;
            }
            if (this.count != tileImageKey.count) {
                return false;
            }
            return this.decoration == tileImageKey.decoration;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[class_124.values().length];
            try {
                nArray[class_124.field_1075.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1074.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1078.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1062.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1058.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1063.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1080.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1077.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1064.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1079.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1065.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1060.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1076.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1061.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1068.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_124.field_1054.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

