/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.menu;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import me.jfenn.bingo.common.event.InteractionEntityEvents;
import me.jfenn.bingo.common.menu.CommonKt;
import me.jfenn.bingo.common.menu.MenuComponent;
import me.jfenn.bingo.common.menu.MenuEntityHandle;
import me.jfenn.bingo.common.menu.MenuPageKt;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IEntity;
import me.jfenn.bingo.platform.IEntityManager;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0013\u0010\u0018\u001a\u00020\u0012*\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u0012*\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J'\u0010\u001e\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u001b*\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010 \u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010#R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010$R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010%R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010&R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lme/jfenn/bingo/common/menu/MenuInstance;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/koin/core/scope/Scope;", "koinScope", "Lnet/minecraft/class_3218;", "world", "Lme/jfenn/bingo/platform/IEntityManager;", "entityManager", "Lme/jfenn/bingo/common/event/InteractionEntityEvents;", "interactionEntityEvents", "Lorg/joml/Matrix4d;", "matrix", "", "instanceTag", "<init>", "(Lorg/slf4j/Logger;Lorg/koin/core/scope/Scope;Lnet/minecraft/class_3218;Lme/jfenn/bingo/platform/IEntityManager;Lme/jfenn/bingo/common/event/InteractionEntityEvents;Lorg/joml/Matrix4d;Ljava/lang/String;)V", "", "tick", "()V", "markDirty", "cleanup", "Lme/jfenn/bingo/platform/IEntity;", "resetPos", "(Lme/jfenn/bingo/platform/IEntity;)V", "transformPos", "T", "Lme/jfenn/bingo/common/menu/MenuEntityHandle;", "info", "spawn", "(Lme/jfenn/bingo/common/menu/MenuEntityHandle;)Lme/jfenn/bingo/platform/IEntity;", "despawn", "(Lme/jfenn/bingo/common/menu/MenuEntityHandle;)V", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_3218;", "Lme/jfenn/bingo/platform/IEntityManager;", "Lme/jfenn/bingo/common/event/InteractionEntityEvents;", "Lorg/joml/Matrix4d;", "Ljava/lang/String;", "Lme/jfenn/bingo/common/menu/MenuComponent;", "menuComponent", "Lme/jfenn/bingo/common/menu/MenuComponent;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMenuInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MenuInstance.kt\nme/jfenn/bingo/common/menu/MenuInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class MenuInstance {
    @NotNull
    private final Logger log;
    @NotNull
    private final class_3218 world;
    @NotNull
    private final IEntityManager entityManager;
    @NotNull
    private final InteractionEntityEvents interactionEntityEvents;
    @NotNull
    private final Matrix4d matrix;
    @NotNull
    private final String instanceTag;
    @NotNull
    private final MenuComponent menuComponent;

    public MenuInstance(@NotNull Logger log, @NotNull Scope koinScope, @NotNull class_3218 world, @NotNull IEntityManager entityManager, @NotNull InteractionEntityEvents interactionEntityEvents, @NotNull Matrix4d matrix, @NotNull String instanceTag) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)koinScope, (String)"koinScope");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)interactionEntityEvents, (String)"interactionEntityEvents");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)instanceTag, (String)"instanceTag");
        this.log = log;
        this.world = world;
        this.entityManager = entityManager;
        this.interactionEntityEvents = interactionEntityEvents;
        this.matrix = matrix;
        this.instanceTag = instanceTag;
        this.menuComponent = CommonKt.component(koinScope, (Function1<? super MenuComponent, Unit>)((Function1)arg_0 -> MenuInstance.menuComponent$lambda$0(this, arg_0)));
    }

    public final void tick() {
        this.menuComponent.tick(this);
    }

    public final void markDirty() {
        this.menuComponent.markDirty();
    }

    public final void cleanup() {
        this.menuComponent.despawn();
    }

    private final void resetPos(IEntity $this$resetPos) {
        $this$resetPos.setPos(new Vector3d());
        $this$resetPos.setYaw(0.0f);
    }

    private final void transformPos(IEntity $this$transformPos) {
        float yawDegrees;
        Vector3d vector3d = this.matrix.transformPosition($this$transformPos.getPos());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        $this$transformPos.setPos(vector3d);
        Vector3d angles = new Vector3d();
        this.matrix.getEulerAnglesXYZ(angles);
        for (yawDegrees = $this$transformPos.getYaw() + (float)MathKt.roundToInt((double)Math.toDegrees(-angles.x - angles.y)); yawDegrees < 0.0f; yawDegrees += 360.0f) {
        }
        if (this.matrix.get(0, 0) == 0.0 && this.matrix.get(1, 1) == 1.0 && this.matrix.get(2, 2) == 0.0) {
            yawDegrees *= (float)-1;
        }
        $this$transformPos.setYaw(yawDegrees);
    }

    @Nullable
    public final <T extends IEntity> T spawn(@NotNull MenuEntityHandle<T> info) {
        IEntity entity;
        IEntity iEntity;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        IEntity iEntity2 = this.entityManager.getEntity(this.world, info.getId());
        if (iEntity2 != null) {
            IEntity iEntity3;
            IEntity it = iEntity3 = iEntity2;
            boolean bl = false;
            iEntity = Intrinsics.areEqual(it.getType(), info.getType()) ? iEntity3 : null;
        } else {
            iEntity = null;
        }
        IEntity iEntity4 = iEntity;
        IEntity iEntity5 = entity = iEntity4 instanceof IEntity ? iEntity4 : null;
        if (entity == null) {
            entity = this.entityManager.createEntity(info.getType(), this.world);
            entity.setUuid(info.getId());
            entity.setCommandTags(SetsKt.setOf((Object)this.instanceTag));
            this.resetPos(entity);
            info.getInit().invoke((Object)entity);
            this.transformPos(entity);
            long chunkPos = class_1923.method_37232((class_2338)new class_2338((int)entity.getPos().x, 0, (int)entity.getPos().z));
            boolean isLoaded = this.world.method_37116(chunkPos);
            if (!isLoaded) {
                entity.discard();
                return null;
            }
            boolean isSuccess = this.entityManager.spawnEntity(this.world, entity);
            if (!isSuccess) {
                this.log.debug("Unable to spawn {} menu entity - discarding...", info.getType());
                entity.discard();
                return null;
            }
        } else {
            entity.setCommandTags(SetsKt.setOf((Object)this.instanceTag));
            this.resetPos(entity);
            info.getInit().invoke((Object)entity);
            this.transformPos(entity);
        }
        if (!Intrinsics.areEqual(entity.getType(), info.getType())) {
            this.log.error("Entity type " + info.getType() + " does not match the entity being updated");
            return null;
        }
        info.getOnUpdate().invoke(entity);
        return (T)entity;
    }

    public final void despawn(@NotNull MenuEntityHandle<?> info) {
        block0: {
            IEntity entity;
            Intrinsics.checkNotNullParameter(info, (String)"info");
            this.interactionEntityEvents.getINTERACT_LISTENERS().remove(info.getId());
            IEntity iEntity = entity = this.entityManager.getEntity(this.world, info.getId());
            if (iEntity == null) break block0;
            iEntity.discard();
        }
    }

    private static final Unit menuComponent$lambda$0(MenuInstance this$0, MenuComponent $this$component) {
        Intrinsics.checkNotNullParameter((Object)$this$component, (String)"$this$component");
        Vector3d translation = new Vector3d(0.5, 2.0, 0.05);
        if (this$0.matrix.get(0, 0) == -1.0 && this$0.matrix.get(1, 1) == 1.0 && this$0.matrix.get(2, 2) == -1.0) {
            translation.add(-1.0, 0.0, -1.0);
        }
        MenuPageKt.registerMenuPage$default($this$component, translation, null, 2, null);
        return Unit.INSTANCE;
    }
}

