/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.platform.scoreboard.ScoreChange;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\r\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/common/scoreboard/ScoreboardView;", "", "", "objectiveName", "<init>", "(Ljava/lang/String;)V", "", "Lme/jfenn/bingo/common/scoreboard/ScoreboardView$ScoreboardItem;", "list", "Lme/jfenn/bingo/platform/scoreboard/ScoreChange;", "createChanges", "(Ljava/util/List;)Ljava/util/List;", "newList", "updateContents", "Ljava/lang/String;", "getObjectiveName", "()Ljava/lang/String;", "", "Ljava/util/UUID;", "players", "Ljava/util/Set;", "getPlayers", "()Ljava/util/Set;", "setPlayers", "(Ljava/util/Set;)V", "", "", "contents", "Ljava/util/Map;", "ScoreboardItem", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreboardView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardView.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1573#2:53\n1604#2,4:54\n2746#2,3:58\n1193#2,2:61\n1267#2,4:63\n*S KotlinDebug\n*F\n+ 1 ScoreboardView.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardView\n*L\n21#1:53\n21#1:54,4\n39#1:58,3\n45#1:61,2\n45#1:63,4\n*E\n"})
public final class ScoreboardView {
    @NotNull
    private final String objectiveName;
    @NotNull
    private Set<UUID> players;
    @NotNull
    private Map<String, Integer> contents;

    public ScoreboardView(@NotNull String objectiveName) {
        Intrinsics.checkNotNullParameter((Object)objectiveName, (String)"objectiveName");
        this.objectiveName = objectiveName;
        this.players = SetsKt.emptySet();
        this.contents = MapsKt.emptyMap();
    }

    @NotNull
    public final String getObjectiveName() {
        return this.objectiveName;
    }

    @NotNull
    public final Set<UUID> getPlayers() {
        return this.players;
    }

    public final void setPlayers(@NotNull Set<UUID> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.players = set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoreChange> createChanges(@NotNull List<ScoreboardItem> list) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void item2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScoreboardItem scoreboardItem = (ScoreboardItem)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScoreChange.Create(item2.getString(), item2.getText(), list.size() - i));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoreChange> updateContents(@NotNull List<ScoreboardItem> newList) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(newList, (String)"newList");
        List changes = new ArrayList();
        Object object = ((Iterable)newList).iterator();
        boolean n = false;
        while (object.hasNext()) {
            Integer prevIndex;
            void entry;
            void i = entry++;
            ScoreboardItem newText = (ScoreboardItem)object.next();
            int newIndex = newList.size() - i;
            Integer n2 = prevIndex = this.contents.get(newText.getString());
            int n3 = newIndex;
            if (n2 != null && n2 == n3) continue;
            boolean bl = prevIndex != null ? changes.add(new ScoreChange.Update(newText.getString(), newText.getText(), newIndex)) : changes.add(new ScoreChange.Create(newText.getString(), newText.getText(), newIndex));
        }
        for (Map.Entry entry : this.contents.entrySet()) {
            boolean bl;
            int i;
            String oldString;
            block6: {
                oldString = (String)entry.getKey();
                i = ((Number)entry.getValue()).intValue();
                Iterable $this$none$iv = newList;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ScoreboardItem it = (ScoreboardItem)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getString(), (Object)oldString)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            changes.add(new ScoreChange.Remove(oldString, null, i));
        }
        object = CollectionsKt.withIndex((Iterable)newList);
        ScoreboardView scoreboardView = this;
        boolean bl = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void i = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            int i2 = indexedValue.component1();
            ScoreboardItem text = (ScoreboardItem)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)text.getString(), (Object)(newList.size() - i2));
            map.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        scoreboardView.contents = destination$iv$iv;
        return changes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/common/scoreboard/ScoreboardView$ScoreboardItem;", "", "", "string", "Lnet/minecraft/class_2561;", "text", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_2561;)V", "Ljava/lang/String;", "getString", "()Ljava/lang/String;", "Lnet/minecraft/class_2561;", "getText", "()Lnet/minecraft/class_2561;", "bingo-common"})
    public static final class ScoreboardItem {
        @NotNull
        private final String string;
        @NotNull
        private final class_2561 text;

        public ScoreboardItem(@NotNull String string, @NotNull class_2561 text) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.string = string;
            this.text = text;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        @NotNull
        public final class_2561 getText() {
            return this.text;
        }
    }
}

