/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoring;

import java.time.Duration;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.common.scoring.GameMessagePacket;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.platform.IPacketBuf;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.packet.PacketConverter;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u00050/123B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJH\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001e\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b\u0005\u0010\u0014R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010)\u001a\u0004\b*\u0010\u0016R\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010+\u001a\u0004\b,\u0010\u0018R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010-\u001a\u0004\b.\u0010\u001a\u00a8\u00064"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "", "Lme/jfenn/bingo/platform/player/PlayerProfile;", "player", "", "isViewerOnTeam", "Lme/jfenn/bingo/common/map/CardTile;", "tile", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;", "messageType", "Lme/jfenn/bingo/platform/text/IText;", "message", "<init>", "(Lme/jfenn/bingo/platform/player/PlayerProfile;ZLme/jfenn/bingo/common/map/CardTile;Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;Lme/jfenn/bingo/platform/text/IText;)V", "Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "toGameMessagePacket", "()Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "component1", "()Lme/jfenn/bingo/platform/player/PlayerProfile;", "component2", "()Z", "component3", "()Lme/jfenn/bingo/common/map/CardTile;", "component4", "()Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;", "component5", "()Lme/jfenn/bingo/platform/text/IText;", "copy", "(Lme/jfenn/bingo/platform/player/PlayerProfile;ZLme/jfenn/bingo/common/map/CardTile;Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;Lme/jfenn/bingo/platform/text/IText;)Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lme/jfenn/bingo/platform/player/PlayerProfile;", "getPlayer", "Z", "Lme/jfenn/bingo/common/map/CardTile;", "getTile", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;", "getMessageType", "Lme/jfenn/bingo/platform/text/IText;", "getMessage", "Companion", "MessageType", "V1", "V2", "V3", "bingo-common"})
public final class ScoreMessagePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PlayerProfile player;
    private final boolean isViewerOnTeam;
    @Nullable
    private final CardTile tile;
    @Nullable
    private final MessageType messageType;
    @NotNull
    private final IText message;

    public ScoreMessagePacket(@Nullable PlayerProfile player, boolean isViewerOnTeam, @Nullable CardTile tile, @Nullable MessageType messageType, @NotNull IText message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.player = player;
        this.isViewerOnTeam = isViewerOnTeam;
        this.tile = tile;
        this.messageType = messageType;
        this.message = message;
    }

    @Nullable
    public final PlayerProfile getPlayer() {
        return this.player;
    }

    public final boolean isViewerOnTeam() {
        return this.isViewerOnTeam;
    }

    @Nullable
    public final CardTile getTile() {
        return this.tile;
    }

    @Nullable
    public final MessageType getMessageType() {
        return this.messageType;
    }

    @NotNull
    public final IText getMessage() {
        return this.message;
    }

    @NotNull
    public final GameMessagePacket toGameMessagePacket() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        String string = BingoTeamKey.constructor-impl("");
        Object object = this.tile;
        if (object == null || (object = ((CardTile)object).getImage()) == null) {
            object = CardTileImage.Companion.getEMPTY();
        }
        CardTile cardTile = this.tile;
        List list = cardTile != null ? cardTile.getImageList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        CardTile cardTile2 = this.tile;
        CardTile.Decoration decoration = cardTile2 != null ? cardTile2.getDecoration() : null;
        MessageType messageType = this.messageType;
        if (messageType == null) {
            messageType = MessageType.ITEM_SCORED;
        }
        return new GameMessagePacket(uUID, duration2, string, (CardTileImage)object, list, decoration, messageType, this.message, false, 256, null);
    }

    @Nullable
    public final PlayerProfile component1() {
        return this.player;
    }

    public final boolean component2() {
        return this.isViewerOnTeam;
    }

    @Nullable
    public final CardTile component3() {
        return this.tile;
    }

    @Nullable
    public final MessageType component4() {
        return this.messageType;
    }

    @NotNull
    public final IText component5() {
        return this.message;
    }

    @NotNull
    public final ScoreMessagePacket copy(@Nullable PlayerProfile player, boolean isViewerOnTeam, @Nullable CardTile tile, @Nullable MessageType messageType, @NotNull IText message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new ScoreMessagePacket(player, isViewerOnTeam, tile, messageType, message);
    }

    public static /* synthetic */ ScoreMessagePacket copy$default(ScoreMessagePacket scoreMessagePacket, PlayerProfile playerProfile, boolean bl, CardTile cardTile, MessageType messageType, IText iText, int n, Object object) {
        if ((n & 1) != 0) {
            playerProfile = scoreMessagePacket.player;
        }
        if ((n & 2) != 0) {
            bl = scoreMessagePacket.isViewerOnTeam;
        }
        if ((n & 4) != 0) {
            cardTile = scoreMessagePacket.tile;
        }
        if ((n & 8) != 0) {
            messageType = scoreMessagePacket.messageType;
        }
        if ((n & 0x10) != 0) {
            iText = scoreMessagePacket.message;
        }
        return scoreMessagePacket.copy(playerProfile, bl, cardTile, messageType, iText);
    }

    @NotNull
    public String toString() {
        return "ScoreMessagePacket(player=" + this.player + ", isViewerOnTeam=" + this.isViewerOnTeam + ", tile=" + this.tile + ", messageType=" + this.messageType + ", message=" + this.message + ")";
    }

    public int hashCode() {
        int result = this.player == null ? 0 : this.player.hashCode();
        result = result * 31 + Boolean.hashCode(this.isViewerOnTeam);
        result = result * 31 + (this.tile == null ? 0 : this.tile.hashCode());
        result = result * 31 + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = result * 31 + this.message.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScoreMessagePacket)) {
            return false;
        }
        ScoreMessagePacket scoreMessagePacket = (ScoreMessagePacket)other;
        if (!Intrinsics.areEqual((Object)this.player, (Object)scoreMessagePacket.player)) {
            return false;
        }
        if (this.isViewerOnTeam != scoreMessagePacket.isViewerOnTeam) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tile, (Object)scoreMessagePacket.tile)) {
            return false;
        }
        if (this.messageType != scoreMessagePacket.messageType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.message, (Object)scoreMessagePacket.message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$Companion;", "", "<init>", "()V", "Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "gameMessagePacket", "", "isViewerOnTeam", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "fromGameMessage", "(Lme/jfenn/bingo/common/scoring/GameMessagePacket;Z)Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScoreMessagePacket fromGameMessage(@NotNull GameMessagePacket gameMessagePacket, boolean isViewerOnTeam) {
            Intrinsics.checkNotNullParameter((Object)gameMessagePacket, (String)"gameMessagePacket");
            return new ScoreMessagePacket(null, isViewerOnTeam, new CardTile(null, gameMessagePacket.getImage(), gameMessagePacket.getImageList(), null, null, null, null, gameMessagePacket.getDecoration(), false, false, false, null, false, 0.0f, null, 32633, null), gameMessagePacket.getMessageType(), gameMessagePacket.getMessage());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$MessageType;", "", "<init>", "(Ljava/lang/String;I)V", "LEADING_TEAM", "LINE_SCORED", "ITEM_SCORED", "CARD_COMPLETED", "bingo-common"})
    public static final class MessageType
    extends Enum<MessageType> {
        public static final /* enum */ MessageType LEADING_TEAM = new MessageType();
        public static final /* enum */ MessageType LINE_SCORED = new MessageType();
        public static final /* enum */ MessageType ITEM_SCORED = new MessageType();
        public static final /* enum */ MessageType CARD_COMPLETED = new MessageType();
        private static final /* synthetic */ MessageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String value) {
            return Enum.valueOf(MessageType.class, value);
        }

        @NotNull
        public static EnumEntries<MessageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = messageTypeArray = new MessageType[]{MessageType.LEADING_TEAM, MessageType.LINE_SCORED, MessageType.ITEM_SCORED, MessageType.CARD_COMPLETED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$V1;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "<init>", "()V", "source", "Lme/jfenn/bingo/platform/IPacketBuf;", "dest", "", "toPacketBuf", "(Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;Lme/jfenn/bingo/platform/IPacketBuf;)V", "buf", "fromPacketBuf", "(Lme/jfenn/bingo/platform/IPacketBuf;)Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "bingo-common"})
    public static final class V1
    implements PacketConverter<ScoreMessagePacket> {
        @NotNull
        public static final V1 INSTANCE = new V1();
        @NotNull
        private static final class_2960 id;

        private V1() {
        }

        @Override
        @NotNull
        public class_2960 getId() {
            return id;
        }

        @Override
        public void toPacketBuf(@NotNull ScoreMessagePacket source, @NotNull IPacketBuf dest) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            if (source.getPlayer() != null) {
                dest.writeBoolean(true);
                String string = source.getPlayer().getUuid().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                dest.writeString(string);
                dest.writeString(source.getPlayer().getName());
            } else {
                dest.writeBoolean(false);
            }
            dest.writeBoolean(source.isViewerOnTeam());
            Object object2 = source.getTile();
            if ((object2 != null && (object2 = ((CardTile)object2).getImage()) != null ? ((CardTileImage)object2).getItem() : null) != null) {
                dest.writeBoolean(true);
                dest.writeItemStack(source.getTile().getImage().getItem());
            } else {
                dest.writeBoolean(false);
            }
            if ((object = source.getMessageType()) == null || (object = object.name()) == null) {
                object = "";
            }
            dest.writeString((String)object);
            dest.writeText(source.getMessage());
        }

        @Override
        @NotNull
        public ScoreMessagePacket fromPacketBuf(@NotNull IPacketBuf buf) {
            MessageType messageType;
            PlayerProfile playerProfile;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            if (buf.readBoolean()) {
                UUID uUID = UUID.fromString(buf.readString());
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                playerProfile = new PlayerProfile(uUID, buf.readString());
            } else {
                playerProfile = null;
            }
            PlayerProfile player = playerProfile;
            boolean isViewerOnTeam = buf.readBoolean();
            IItemStack item2 = buf.readBoolean() ? buf.readItemStack() : null;
            try {
                messageType = MessageType.valueOf(buf.readString());
            }
            catch (Throwable e) {
                messageType = null;
            }
            MessageType messageType2 = messageType;
            IText message = buf.readText();
            return new ScoreMessagePacket(player, isViewerOnTeam, new CardTile(null, new CardTileImage(item2, null, null, 4, null), null, null, null, null, null, null, false, false, false, null, false, 0.0f, null, 32637, null), messageType2, message);
        }

        static {
            class_2960 class_29602 = class_2960.method_43902((String)"yet-another-minecraft-bingo", (String)"score_message");
            Intrinsics.checkNotNull((Object)class_29602);
            id = class_29602;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$V2;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "<init>", "()V", "source", "Lme/jfenn/bingo/platform/IPacketBuf;", "dest", "", "toPacketBuf", "(Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;Lme/jfenn/bingo/platform/IPacketBuf;)V", "buf", "fromPacketBuf", "(Lme/jfenn/bingo/platform/IPacketBuf;)Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "bingo-common"})
    public static final class V2
    implements PacketConverter<ScoreMessagePacket> {
        @NotNull
        public static final V2 INSTANCE = new V2();
        @NotNull
        private static final class_2960 id;

        private V2() {
        }

        @Override
        @NotNull
        public class_2960 getId() {
            return id;
        }

        @Override
        public void toPacketBuf(@NotNull ScoreMessagePacket source, @NotNull IPacketBuf dest) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeNullable(source.getPlayer(), arg_0 -> V2.toPacketBuf$lambda$0(dest, arg_0));
            dest.writeBoolean(source.isViewerOnTeam());
            Object object = source.getTile();
            dest.writeNullable(object != null && (object = ((CardTile)object).getImage()) != null ? ((CardTileImage)object).getItem() : null, (Function1)new Function1<IItemStack, Unit>((Object)dest){

                public final void invoke(IItemStack p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((IPacketBuf)this.receiver).writeItemStack(p0);
                }
            });
            Object object2 = source.getTile();
            dest.writeNullable(object2 != null && (object2 = ((CardTile)object2).getImage()) != null ? ((CardTileImage)object2).getTexture() : null, (Function1)new Function1<String, Unit>((Object)dest){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((IPacketBuf)this.receiver).writeString(p0);
                }
            });
            Object object3 = source.getMessageType();
            if (object3 == null || (object3 = object3.name()) == null) {
                object3 = "";
            }
            dest.writeString((String)object3);
            dest.writeText(source.getMessage());
        }

        @Override
        @NotNull
        public ScoreMessagePacket fromPacketBuf(@NotNull IPacketBuf buf) {
            MessageType messageType;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            PlayerProfile player = (PlayerProfile)buf.readNullable(() -> V2.fromPacketBuf$lambda$0(buf));
            boolean isViewerOnTeam = buf.readBoolean();
            IItemStack item2 = (IItemStack)buf.readNullable((Function0)new Function0<IItemStack>((Object)buf){

                public final IItemStack invoke() {
                    return ((IPacketBuf)this.receiver).readItemStack();
                }
            });
            String image2 = (String)buf.readNullable((Function0)new Function0<String>((Object)buf){

                public final String invoke() {
                    return ((IPacketBuf)this.receiver).readString();
                }
            });
            try {
                messageType = MessageType.valueOf(buf.readString());
            }
            catch (Throwable e) {
                messageType = null;
            }
            MessageType messageType2 = messageType;
            IText message = buf.readText();
            return new ScoreMessagePacket(player, isViewerOnTeam, new CardTile(null, new CardTileImage(item2, image2, null, 4, null), null, null, null, null, null, null, false, false, false, null, false, 0.0f, null, 32637, null), messageType2, message);
        }

        private static final Unit toPacketBuf$lambda$0(IPacketBuf $dest, PlayerProfile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getUuid().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $dest.writeString(string);
            $dest.writeString(it.getName());
            return Unit.INSTANCE;
        }

        private static final PlayerProfile fromPacketBuf$lambda$0(IPacketBuf $buf) {
            UUID uUID = UUID.fromString($buf.readString());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            return new PlayerProfile(uUID, $buf.readString());
        }

        static {
            class_2960 class_29602 = class_2960.method_43902((String)"yet-another-minecraft-bingo", (String)"score_message_v2");
            Intrinsics.checkNotNull((Object)class_29602);
            id = class_29602;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreMessagePacket$V3;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "<init>", "()V", "source", "Lme/jfenn/bingo/platform/IPacketBuf;", "dest", "", "toPacketBuf", "(Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;Lme/jfenn/bingo/platform/IPacketBuf;)V", "buf", "fromPacketBuf", "(Lme/jfenn/bingo/platform/IPacketBuf;)Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "bingo-common"})
    public static final class V3
    implements PacketConverter<ScoreMessagePacket> {
        @NotNull
        public static final V3 INSTANCE = new V3();
        @NotNull
        private static final class_2960 id;

        private V3() {
        }

        @Override
        @NotNull
        public class_2960 getId() {
            return id;
        }

        @Override
        public void toPacketBuf(@NotNull ScoreMessagePacket source, @NotNull IPacketBuf dest) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeNullable(source.getPlayer(), arg_0 -> V3.toPacketBuf$lambda$0(dest, arg_0));
            dest.writeBoolean(source.isViewerOnTeam());
            dest.writeNullable(source.getTile(), arg_0 -> V3.toPacketBuf$lambda$1(dest, arg_0));
            Object object = source.getMessageType();
            if (object == null || (object = object.name()) == null) {
                object = "";
            }
            dest.writeString((String)object);
            dest.writeText(source.getMessage());
        }

        @Override
        @NotNull
        public ScoreMessagePacket fromPacketBuf(@NotNull IPacketBuf buf) {
            MessageType messageType;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            PlayerProfile player = (PlayerProfile)buf.readNullable(() -> V3.fromPacketBuf$lambda$0(buf));
            boolean isViewerOnTeam = buf.readBoolean();
            CardTile tile = (CardTile)buf.readNullable(() -> V3.fromPacketBuf$lambda$1(buf));
            try {
                messageType = MessageType.valueOf(buf.readString());
            }
            catch (Throwable e) {
                messageType = null;
            }
            MessageType messageType2 = messageType;
            IText message = buf.readText();
            return new ScoreMessagePacket(player, isViewerOnTeam, tile, messageType2, message);
        }

        private static final Unit toPacketBuf$lambda$0(IPacketBuf $dest, PlayerProfile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getUuid().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $dest.writeString(string);
            $dest.writeString(it.getName());
            return Unit.INSTANCE;
        }

        private static final Unit toPacketBuf$lambda$1(IPacketBuf $dest, CardTile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CardTile.V5.INSTANCE.toPacketBuf(it, $dest);
            return Unit.INSTANCE;
        }

        private static final PlayerProfile fromPacketBuf$lambda$0(IPacketBuf $buf) {
            UUID uUID = UUID.fromString($buf.readString());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            return new PlayerProfile(uUID, $buf.readString());
        }

        private static final CardTile fromPacketBuf$lambda$1(IPacketBuf $buf) {
            return CardTile.V5.INSTANCE.fromPacketBuf($buf);
        }

        static {
            class_2960 class_29602 = class_2960.method_43902((String)"yet-another-minecraft-bingo", (String)"score_message_v3");
            Intrinsics.checkNotNull((Object)class_29602);
            id = class_29602;
        }
    }
}

