/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.spawn.SpawnKitService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.item.IItemStack;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\"\u00a8\u0006#"}, d2={"Lme/jfenn/bingo/common/spawn/ChestService;", "", "Lorg/slf4j/Logger;", "log", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/spawn/SpawnKitService;", "spawnKitService", "<init>", "(Lorg/slf4j/Logger;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/spawn/SpawnKitService;)V", "Lnet/minecraft/class_3218;", "getSpawnDimension", "()Lnet/minecraft/class_3218;", "", "createChestSpawnpoints", "()V", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/platform/block/BlockPosition;", "createChestSpawnpoint", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/block/BlockPosition;", "createChestBlock", "(Lme/jfenn/bingo/common/team/BingoTeam;)V", "Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/spawn/SpawnKitService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nChestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChestService.kt\nme/jfenn/bingo/common/spawn/ChestService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n774#2:134\n865#2,2:135\n1869#2,2:137\n1878#2,3:139\n*S KotlinDebug\n*F\n+ 1 ChestService.kt\nme/jfenn/bingo/common/spawn/ChestService\n*L\n113#1:130\n113#1:131,3\n114#1:134\n114#1:135,2\n115#1:137,2\n119#1:139,3\n*E\n"})
public final class ChestService {
    @NotNull
    private final Logger log;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final SpawnKitService spawnKitService;

    public ChestService(@NotNull Logger log, @NotNull MinecraftServer server, @NotNull BingoOptions options, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull SpawnKitService spawnKitService) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)spawnKitService, (String)"spawnKitService");
        this.log = log;
        this.server = server;
        this.options = options;
        this.config = config;
        this.state = state;
        this.spawnKitService = spawnKitService;
    }

    private final class_3218 getSpawnDimension() {
        class_3218 class_32182;
        Object v1;
        block2: {
            Iterable iterable = this.server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getWorlds(...)");
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                class_3218 it = (class_3218)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.method_27983().method_29177().toString(), (Object)this.options.getSpawnDimension())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((class_32182 = (class_3218)v1) == null) {
            ChestService $this$getSpawnDimension_u24lambda_u241 = this;
            boolean bl = false;
            $this$getSpawnDimension_u24lambda_u241.log.error("[SpawnService] Could not find spawnDimension '" + $this$getSpawnDimension_u24lambda_u241.options.getSpawnDimension() + "'; defaulting to minecraft:overworld");
            class_3218 class_32183 = $this$getSpawnDimension_u24lambda_u241.server.method_30002();
            class_32182 = class_32183;
            Intrinsics.checkNotNullExpressionValue((Object)class_32183, (String)"run(...)");
        }
        return class_32182;
    }

    public final void createChestSpawnpoints() {
        if (!this.options.isTeamKit()) {
            return;
        }
        for (BingoTeam team : this.state.getRegisteredTeams()) {
            if (team.getChestSpawnpoint() != null) continue;
            this.createChestSpawnpoint(team);
        }
    }

    private final BlockPosition createChestSpawnpoint(BingoTeam team) {
        class_2338 chestBlockPos;
        if (!this.options.isTeamKit()) {
            return null;
        }
        if (!this.state.isLobbyMode()) {
            return null;
        }
        class_3218 world = this.getSpawnDimension();
        BlockPosition blockPosition = team.getSpawnpoint();
        if (blockPosition == null) {
            ChestService $this$createChestSpawnpoint_u24lambda_u240 = this;
            boolean bl = false;
            $this$createChestSpawnpoint_u24lambda_u240.log.error("[ChestService] createChestSpawnpoint - Cannot create a team chest, as the team does not have a spawn point!");
            return null;
        }
        BlockPosition spawnpoint = blockPosition;
        class_2791 chunk = world.method_22350(spawnpoint.toBlockPos());
        if (world.method_8597().comp_643()) {
            v1 = new class_2338(spawnpoint.getX() + 1, spawnpoint.getY(), spawnpoint.getZ());
        } else {
            Object v2;
            block9: {
                List list;
                class_2902 heightmap = chunk.method_12032(class_2902.class_2903.field_13203);
                List $this$createChestSpawnpoint_u24lambda_u241 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        $this$createChestSpawnpoint_u24lambda_u241.add(new Pair((Object)x, (Object)z));
                    }
                }
                Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.shuffled((Iterable)CollectionsKt.build((List)list))), arg_0 -> ChestService.createChestSpawnpoint$lambda$2(heightmap, chunk, arg_0));
                for (Object e : sequence) {
                    class_2338 blockPos = (class_2338)e;
                    boolean bl2 = false;
                    if (!(world.method_22347(blockPos) || world.method_8320(blockPos).method_26220((class_1922)world, blockPos).method_1110())) continue;
                    v2 = e;
                    break block9;
                }
                v2 = null;
            }
            v1 = chestBlockPos = (class_2338)v2;
        }
        if (chestBlockPos == null) {
            this.log.error("[ChestService] createChestSpawnpoint - No valid locations to create a team kit chest!");
            return null;
        }
        BlockPosition position = BlockPosition.Companion.fromBlockPos(chestBlockPos);
        team.setChestSpawnpoint(position);
        return position;
    }

    /*
     * WARNING - void declaration
     */
    public final void createChestBlock(@NotNull BingoTeam team) {
        void $this$forEachIndexed$iv;
        Iterable $this$forEach$iv;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        if (!this.options.isTeamKit()) {
            return;
        }
        if (!this.state.isLobbyMode()) {
            return;
        }
        class_3218 world = this.getSpawnDimension();
        BlockPosition blockPosition = team.getChestSpawnpoint();
        if (blockPosition == null && (blockPosition = this.createChestSpawnpoint(team)) == null) {
            ChestService $this$createChestBlock_u24lambda_u240 = this;
            boolean bl = false;
            $this$createChestBlock_u24lambda_u240.log.error("[ChestService] createChestBlock - Cannot create a team chest, as there is no chestSpawnpoint.");
            return;
        }
        BlockPosition chestSpawnpoint = blockPosition;
        class_2338 chestBlockPos = chestSpawnpoint.toBlockPos();
        world.method_8501(chestBlockPos, class_2246.field_10034.method_9564());
        Object $this$createChestBlock_u24lambda_u240 = world.method_8321(chestBlockPos);
        class_2595 class_25952 = $this$createChestBlock_u24lambda_u240 instanceof class_2595 ? (class_2595)$this$createChestBlock_u24lambda_u240 : null;
        if (class_25952 == null) {
            ChestService $this$createChestBlock_u24lambda_u241 = this;
            boolean bl = false;
            $this$createChestBlock_u24lambda_u241.log.error("[SpawnService] createTeamChest - Creating a team kit chest did not create a block entity. This should never happen!!");
            return;
        }
        class_2595 entity = class_25952;
        class_2680 torchState = class_2246.field_10336.method_9564();
        $this$createChestBlock_u24lambda_u240 = (Iterable)class_2350.class_2353.field_11062;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void direction;
            class_2350 class_23502 = (class_2350)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(chestBlockPos.method_10093((class_2350)direction));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            class_2338 blockPos = (class_2338)element$iv$iv;
            boolean bl3 = false;
            if (!torchState.method_26184((class_4538)world, blockPos)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2338 blockPos = (class_2338)element$iv;
            boolean bl4 = false;
            world.method_8501(blockPos, torchState);
        }
        $this$forEach$iv = this.spawnKitService.getTeamItems();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void itemStack;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (IItemStack)item$iv;
            int i = n;
            boolean bl5 = false;
            if (this.config.getPreventScoringSpawnKitItems()) {
                itemStack.addCustomTag("bingo_ignore");
            }
            entity.method_5447(i, itemStack.getStack());
        }
    }

    private static final class_2338 createChestSpawnpoint$lambda$2(class_2902 $heightmap, class_2791 $chunk, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        int x = ((Number)pair.component1()).intValue();
        int z = ((Number)pair.component2()).intValue();
        int y = $heightmap.method_12603(x, z);
        return $chunk.method_12004().method_35231(x, y, z);
    }
}

