/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.PlayerGameSummary;
import me.jfenn.bingo.common.stats.packets.StatsCheckPacket;
import me.jfenn.bingo.common.stats.packets.StatsGamePacket;
import me.jfenn.bingo.common.stats.packets.StatsIndexPacket;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.packet.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0014\u001a\u0012\u0012\u0002\b\u0003 \u0013*\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u0012\u0012\u0002\b\u0003 \u0013*\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J5\u0010\u001a\u001a\u0012\u0012\u0002\b\u0003 \u0013*\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u00122\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ5\u0010\u001c\u001a\u0012\u0012\u0002\b\u0003 \u0013*\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u00122\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R8\u0010*\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00180\u0018 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00170)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lme/jfenn/bingo/common/stats/StatsSyncController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/common/stats/StatsService;", "stats", "Lme/jfenn/bingo/platform/IExecutors;", "executors", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/stats/StatsService;Lme/jfenn/bingo/platform/IExecutors;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Ljava/util/concurrent/Future;", "kotlin.jvm.PlatformType", "broadcastHash", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Ljava/util/concurrent/Future;", "sendKnownIds", "", "Ljava/util/UUID;", "gameIds", "checkForMissingIds", "(Lme/jfenn/bingo/platform/IPlayerHandle;Ljava/util/Set;)Ljava/util/concurrent/Future;", "sendRequestedIds", "Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;", "game", "", "insertReceivedGame", "(Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/stats/StatsService;", "Ljava/util/concurrent/ExecutorService;", "executor", "Ljava/util/concurrent/ExecutorService;", "", "pendingPlayerIds", "Ljava/util/Set;", "bingo-common"})
public final class StatsSyncController
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final StatsService stats;
    @NotNull
    private final ExecutorService executor;
    private final Set<UUID> pendingPlayerIds;

    public StatsSyncController(@NotNull Logger log, @NotNull BingoConfig config, @NotNull ServerPacketEvents packets, @NotNull StatsService stats, @NotNull IExecutors executors, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.log = log;
        this.config = config;
        this.packets = packets;
        this.stats = stats;
        this.executor = executors.getIo();
        this.pendingPlayerIds = Collections.newSetFromMap(new ConcurrentHashMap());
        events.onPlayerChannelRegister((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> StatsSyncController._init_$lambda$0(this, arg_0)));
        events.onPlayerDisconnect((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> StatsSyncController._init_$lambda$1(this, arg_0)));
        events.onPacket(this.packets.getStatsHashV1C2S(), arg_0 -> StatsSyncController._init_$lambda$2(this, arg_0));
        events.onPacket(this.packets.getStatsIndexV1C2S(), arg_0 -> StatsSyncController._init_$lambda$3(this, arg_0));
        events.onPacket(this.packets.getStatsGameV1C2S(), arg_0 -> StatsSyncController._init_$lambda$4(this, arg_0));
    }

    private final Future<?> broadcastHash(IPlayerHandle player) {
        return this.executor.submit(() -> StatsSyncController.broadcastHash$lambda$0(this, player));
    }

    private final Future<?> sendKnownIds(IPlayerHandle player) {
        return this.executor.submit(() -> StatsSyncController.sendKnownIds$lambda$0(this, player));
    }

    private final Future<?> checkForMissingIds(IPlayerHandle player, Set<UUID> gameIds) {
        return this.executor.submit(() -> StatsSyncController.checkForMissingIds$lambda$0(this, player, gameIds));
    }

    private final Future<?> sendRequestedIds(IPlayerHandle player, Set<UUID> gameIds) {
        return this.executor.submit(() -> StatsSyncController.sendRequestedIds$lambda$0(gameIds, this, player));
    }

    private final void insertReceivedGame(PlayerGameSummary game) {
        this.stats.insertGame(game.getGame(), CollectionsKt.listOf((Object)game.getTeam()), CollectionsKt.listOf((Object)game.getPlayer()));
    }

    private static final void broadcastHash$lambda$0(StatsSyncController this$0, IPlayerHandle $player) {
        this$0.log.info("[StatsSyncController] Broadcasting stats hash to player {}", (Object)$player.getUuid());
        String hash = this$0.stats.fetchGamesByPlayerSha512($player.getUuid());
        StatsCheckPacket packet = new StatsCheckPacket(hash);
        this$0.packets.getStatsHashV1S2C().send($player, packet);
    }

    private static final void sendKnownIds$lambda$0(StatsSyncController this$0, IPlayerHandle $player) {
        this$0.log.info("[StatsSyncController] Client responded with a hash mismatch - starting sync for player {}", (Object)$player.getUuid());
        for (List ids : StatsService.fetchGamesByPlayer$default(this$0.stats, $player.getUuid(), 0L, 2, null)) {
            StatsIndexPacket packet = new StatsIndexPacket(StatsIndexPacket.Action.BROADCAST, CollectionsKt.toSet((Iterable)ids));
            this$0.log.info("[StatsSyncController] Broadcasting {} known gameIds to the client", (Object)ids.size());
            this$0.packets.getStatsIndexV1S2C().send($player, packet);
            try {
                Thread.sleep(Random.Default.nextLong(50L, 200L));
            }
            catch (InterruptedException e) {
                this$0.log.warn("[StatsSyncController] broadcastKnownIds interrupted!");
                break;
            }
        }
    }

    private static final void checkForMissingIds$lambda$0(StatsSyncController this$0, IPlayerHandle $player, Set $gameIds) {
        Set<UUID> missingIds = this$0.stats.checkIfIdsExist($player.getUuid(), $gameIds);
        if (!((Collection)missingIds).isEmpty()) {
            this$0.log.info("[StatsSyncController] Requesting {} missing gameIds from the client", (Object)missingIds.size());
            this$0.packets.getStatsIndexV1S2C().send($player, new StatsIndexPacket(StatsIndexPacket.Action.REQUEST, missingIds));
        }
    }

    private static final void sendRequestedIds$lambda$0(Set $gameIds, StatsSyncController this$0, IPlayerHandle $player) {
        for (UUID gameId : $gameIds) {
            PlayerGameSummary gameSummary = this$0.stats.findById(gameId, $player.getUuid());
            if (gameSummary == null) {
                this$0.log.error("[StatsSyncController] Requested gameId={}, playerId={} does not exist in the database", (Object)gameId, (Object)$player.getUuid());
                continue;
            }
            StatsGamePacket packet = new StatsGamePacket(gameSummary);
            this$0.packets.getStatsGameV1S2C().send($player, packet);
            try {
                Thread.sleep(Random.Default.nextLong(50L, 200L));
            }
            catch (InterruptedException e) {
                this$0.log.warn("[StatsSyncController] sendRequestedIds interrupted!");
                break;
            }
        }
    }

    private static final Unit _init_$lambda$0(StatsSyncController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        if (!this$0.packets.getStatsHashV1S2C().isSupported(player)) {
            return Unit.INSTANCE;
        }
        if (this$0.pendingPlayerIds.contains(player.getUuid())) {
            return Unit.INSTANCE;
        }
        this$0.pendingPlayerIds.add(player.getUuid());
        this$0.broadcastHash(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(StatsSyncController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.pendingPlayerIds.remove(player.getUuid());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(StatsSyncController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        this$0.sendKnownIds(it.getPlayer());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(StatsSyncController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((StatsIndexPacket)it.getPacket()).getAction().ordinal()]) {
            case 1: {
                Future<?> future = this$0.checkForMissingIds(it.getPlayer(), ((StatsIndexPacket)it.getPacket()).getGames());
                break;
            }
            case 2: {
                Future<?> future = this$0.sendRequestedIds(it.getPlayer(), ((StatsIndexPacket)it.getPacket()).getGames());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(StatsSyncController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        this$0.insertReceivedGame(((StatsGamePacket)it.getPacket()).getGame());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatsIndexPacket.Action.values().length];
            try {
                nArray[StatsIndexPacket.Action.BROADCAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatsIndexPacket.Action.REQUEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

