/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.impl.networking;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.impl.PlayerHandle;
import me.jfenn.bingo.impl.networking.BingoPayload;
import me.jfenn.bingo.impl.networking.PacketBufImpl;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.packet.IServerNetworking;
import me.jfenn.bingo.platform.packet.IServerPacketHandlerC2S;
import me.jfenn.bingo.platform.packet.IServerPacketHandlerS2C;
import me.jfenn.bingo.platform.packet.PacketConverter;
import me.jfenn.bingo.platform.packet.ServerPacket;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;", "Lme/jfenn/bingo/platform/packet/IServerNetworking;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/event/IEventBus;)V", "T", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "registerC2S", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "registerS2C", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/event/IEventBus;", "ServerPacketHandlerC2S", "ServerPacketHandlerS2C", "bingo"})
public final class ServerNetworkingImpl
implements IServerNetworking {
    @NotNull
    private final Logger log;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final IEventBus eventBus;

    public ServerNetworkingImpl(@NotNull Logger log, @NotNull IItemStackFactory itemStackFactory, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.itemStackFactory = itemStackFactory;
        this.eventBus = eventBus;
    }

    @Override
    @NotNull
    public <T> IServerPacketHandlerC2S<T> registerC2S(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ServerPacketHandlerC2S<T>(converter);
    }

    @Override
    @NotNull
    public <T> IServerPacketHandlerS2C<T> registerS2C(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ServerPacketHandlerS2C<T>(converter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fRP\u0010\u0010\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000f*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e0\u000e \u000f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000f*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R&\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerC2S;", "T", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lnet/minecraft/class_8710$class_9154;", "Lme/jfenn/bingo/impl/networking/BingoPayload;", "kotlin.jvm.PlatformType", "id", "Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_9129;", "codec", "Lnet/minecraft/class_9139;", "bingo"})
    @SourceDebugExtension(value={"SMAP\nServerNetworkingImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerNetworkingImpl.kt\nme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerC2S\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
    public final class ServerPacketHandlerC2S<T>
    implements IServerPacketHandlerC2S<T> {
        @NotNull
        private final PacketConverter<T> converter;
        @NotNull
        private final String name;
        private final class_8710.class_9154<BingoPayload<T>> id;
        @NotNull
        private final class_9139<class_9129, BingoPayload<T>> codec;

        /*
         * WARNING - void declaration
         */
        public ServerPacketHandlerC2S(PacketConverter<T> converter) {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter(converter, (String)"converter");
                this.converter = converter;
                this.name = "packetC2S=" + this.converter.getId();
                class_2960 class_29602 = this.converter.getId();
                ServerPacketHandlerC2S serverPacketHandlerC2S = this;
                boolean bl = false;
                serverPacketHandlerC2S.id = class_8710.method_56483((String)(it.method_12836() + "_" + it.method_12832()));
                class_9139 class_91392 = class_9139.method_56438((arg_0, arg_1) -> ServerPacketHandlerC2S.codec$lambda$0(this, ServerNetworkingImpl.this, arg_0, arg_1), arg_0 -> ServerPacketHandlerC2S.codec$lambda$1(this, ServerNetworkingImpl.this, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"of(...)");
                this.codec = class_91392;
                ServerNetworkingImpl.this.log.debug("[ServerNetworkingInfo] Registering C2S packet {}", (Object)this.converter.getId().toString());
                try {
                    class_8710.class_9155 class_91552 = PayloadTypeRegistry.playC2S().register(this.id, this.codec);
                    Intrinsics.checkNotNull((Object)class_91552);
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already registered", (boolean)false, (int)2, null) : false) break block2;
                    throw new RuntimeException("Error initializing bingo ServerNetworking", e);
                }
            }
            ServerPlayNetworking.registerGlobalReceiver(this.id, (arg_0, arg_1) -> ServerPacketHandlerC2S._init_$lambda$0(ServerNetworkingImpl.this, this, arg_0, arg_1));
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        private static final void codec$lambda$0(ServerPacketHandlerC2S this$0, ServerNetworkingImpl this$1, BingoPayload type, class_9129 buf) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this$0.converter.toPacketBuf(type.getValue(), new PacketBufImpl(buf, this$1.itemStackFactory));
        }

        private static final BingoPayload codec$lambda$1(ServerPacketHandlerC2S this$0, ServerNetworkingImpl this$1, class_9129 b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            class_8710.class_9154 class_91542 = this$0.id;
            Intrinsics.checkNotNullExpressionValue(class_91542, (String)"id");
            return new BingoPayload(class_91542, this$0.converter.fromPacketBuf(new PacketBufImpl(b, this$1.itemStackFactory)));
        }

        private static final void _init_$lambda$0(ServerNetworkingImpl this$0, ServerPacketHandlerC2S this$1, BingoPayload packet, ServerPlayNetworking.Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            class_3222 class_32222 = ctx.player();
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player(...)");
            PlayerHandle player = new PlayerHandle(class_32222, null, 2, null);
            ServerPacket data = new ServerPacket(player, packet.getValue());
            ctx.server().execute(() -> ServerPacketHandlerC2S.lambda$0$0(this$0, this$1, data));
        }

        private static final void lambda$0$0(ServerNetworkingImpl this$0, ServerPacketHandlerC2S this$1, ServerPacket $data) {
            this$0.eventBus.emit(this$1, $data);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000fRP\u0010\u0013\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0012*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00110\u0011 \u0012*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0012*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R&\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerS2C;", "T", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "Lnet/minecraft/class_3222;", "player", "", "isSupported", "(Lnet/minecraft/class_3222;)Z", "packet", "send", "(Lnet/minecraft/class_3222;Ljava/lang/Object;)Z", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "Lnet/minecraft/class_8710$class_9154;", "Lme/jfenn/bingo/impl/networking/BingoPayload;", "kotlin.jvm.PlatformType", "id", "Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_9129;", "codec", "Lnet/minecraft/class_9139;", "bingo"})
    @SourceDebugExtension(value={"SMAP\nServerNetworkingImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerNetworkingImpl.kt\nme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerS2C\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
    public final class ServerPacketHandlerS2C<T>
    implements IServerPacketHandlerS2C<T> {
        @NotNull
        private final PacketConverter<T> converter;
        private final class_8710.class_9154<BingoPayload<T>> id;
        @NotNull
        private final class_9139<class_9129, BingoPayload<T>> codec;

        /*
         * WARNING - void declaration
         */
        public ServerPacketHandlerS2C(PacketConverter<T> converter) {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter(converter, (String)"converter");
                this.converter = converter;
                class_2960 class_29602 = this.converter.getId();
                ServerPacketHandlerS2C serverPacketHandlerS2C = this;
                boolean bl = false;
                serverPacketHandlerS2C.id = class_8710.method_56483((String)(it.method_12836() + "_" + it.method_12832()));
                class_9139 class_91392 = class_9139.method_56438((arg_0, arg_1) -> ServerPacketHandlerS2C.codec$lambda$0(this, ServerNetworkingImpl.this, arg_0, arg_1), arg_0 -> ServerPacketHandlerS2C.codec$lambda$1(this, ServerNetworkingImpl.this, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"of(...)");
                this.codec = class_91392;
                ServerNetworkingImpl.this.log.debug("[ServerNetworkingInfo] Registering S2C packet {}", (Object)this.converter.getId().toString());
                try {
                    class_8710.class_9155 class_91552 = PayloadTypeRegistry.playS2C().register(this.id, this.codec);
                    Intrinsics.checkNotNull((Object)class_91552);
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already registered", (boolean)false, (int)2, null) : false) break block2;
                    throw new RuntimeException("Error initializing bingo ServerNetworking", e);
                }
            }
        }

        @Override
        public boolean isSupported(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return ServerPlayNetworking.canSend((class_3222)player, this.id);
        }

        @Override
        public boolean send(@NotNull class_3222 player, T packet) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (this.isSupported(player)) {
                class_8710.class_9154<BingoPayload<T>> class_91542 = this.id;
                Intrinsics.checkNotNullExpressionValue(class_91542, (String)"id");
                ServerPlayNetworking.send((class_3222)player, (class_8710)new BingoPayload<T>(class_91542, packet));
                return true;
            }
            return false;
        }

        private static final void codec$lambda$0(ServerPacketHandlerS2C this$0, ServerNetworkingImpl this$1, BingoPayload type, class_9129 buf) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this$0.converter.toPacketBuf(type.getValue(), new PacketBufImpl(buf, this$1.itemStackFactory));
        }

        private static final BingoPayload codec$lambda$1(ServerPacketHandlerS2C this$0, ServerNetworkingImpl this$1, class_9129 b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            class_8710.class_9154 class_91542 = this$0.id;
            Intrinsics.checkNotNullExpressionValue(class_91542, (String)"id");
            return new BingoPayload(class_91542, this$0.converter.fromPacketBuf(new PacketBufImpl(b, this$1.itemStackFactory)));
        }
    }
}

