/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.mixin;

import me.jfenn.bingo.common.WorldDeleter;
import me.jfenn.bingo.mixinhandler.MinecraftServerMixinHandler;
import me.jfenn.bingo.platform.scope.BingoKoin;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_11980;
import net.minecraft.class_3242;
import net.minecraft.class_3324;
import net.minecraft.class_5962;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerUnsafeSkipCloseMixin {
    @Unique
    private final Logger log = LoggerFactory.getLogger(MinecraftServerUnsafeSkipCloseMixin.class);
    @Shadow
    private boolean field_35437;
    @Shadow
    @Final
    private class_3242 field_4563;
    @Shadow
    private class_3324 field_4550;
    @Shadow
    private class_5962 field_22250;
    @Shadow
    @Final
    private class_11980 field_62766;

    @Shadow
    public abstract void method_42062();

    @Unique
    private boolean shouldKeepWorldData() {
        MinecraftServer server = (MinecraftServer)this;
        if (BingoKoin.INSTANCE.getScope(server) == null) {
            return true;
        }
        if (!server.method_3816()) {
            return true;
        }
        if (!MinecraftServerMixinHandler.INSTANCE.shouldDeleteWorld(server)) {
            return true;
        }
        return MinecraftServerMixinHandler.INSTANCE.isGamePlaying(server);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_3782"}, cancellable=true)
    public void shutdownUnsafe(CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (this.shouldKeepWorldData()) {
            return;
        }
        if (!MinecraftServerMixinHandler.INSTANCE.isUnsafeSkipWorldClose(server)) {
            return;
        }
        try {
            ((ServerLifecycleEvents.ServerStopping)ServerLifecycleEvents.SERVER_STOPPING.invoker()).onServerStopping(server);
        }
        catch (Throwable e) {
            this.log.error("Error on SERVER_STOPPING", e);
        }
        this.log.info("Stopping server");
        this.field_62766.close();
        if (this.field_22250 != null && this.field_22250.method_34773()) {
            this.method_42062();
        }
        if (this.field_4563 != null) {
            this.field_4563.method_14356();
        }
        this.field_35437 = true;
        if (this.field_4550 != null) {
            this.log.info("Disconnecting players");
            try {
                this.field_4550.method_14597();
            }
            catch (Throwable e) {
                this.log.error("Error on disconnectAllPlayers", e);
            }
        }
        this.log.info("unsafeSkipWorldClose is true; skipping file closing");
        this.log.info("This will likely cause a crash...");
        this.field_35437 = false;
        try {
            ((ServerLifecycleEvents.ServerStopped)ServerLifecycleEvents.SERVER_STOPPED.invoker()).onServerStopped(server);
        }
        catch (Throwable e) {
            this.log.error("Error on SERVER_STOPPED", e);
        }
        WorldDeleter.INSTANCE.invoke(server);
        Runtime.getRuntime().halt(0);
        ci.cancel();
    }

    @Inject(at={@At(value="TAIL")}, method={"method_3782"}, cancellable=true)
    public void shutdownDeleteWorld(CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (this.shouldKeepWorldData()) {
            return;
        }
        try {
            ((ServerLifecycleEvents.ServerStopped)ServerLifecycleEvents.SERVER_STOPPED.invoker()).onServerStopped(server);
        }
        catch (Throwable e) {
            this.log.error("Error on SERVER_STOPPED", e);
        }
        WorldDeleter.INSTANCE.invoke(server);
        ci.cancel();
    }
}

