/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.scheduling.common;

import com.ishland.c2me.base.common.config.ConfigSystem;

public class Config {
    public static final long midTickChunkTasksInterval = new ConfigSystem.ConfigAccessor().key("generalOptimizations.midTickChunkTasksInterval").comment("The task interval of mid-tick chunk tasks in nanoseconds (-1 to disable)  \nMid-tick chunk tasks is to execute chunk tasks during server tick loop  \nto speed up chunk loading and generation  \nThis helps chunks loading and generating under high MSPT but may raise  \nMSPT when chunks are loading or generating  \n \nIt is generally not recommended to adjust this value unless you know  \nwhat you are doing  \n \nIncompatible with Dimensional Threading (dimthread)\n").incompatibleMod("dimthread", "*").getLong(100000L, -1L, new ConfigSystem.LongChecks[0]);
    public static final AutoSaveMode autoSaveMode = (AutoSaveMode)new ConfigSystem.ConfigAccessor().key("generalOptimizations.autoSave.mode").comment("Defines how auto save should be handled  \nVANILLA: Use vanilla auto-save behavior (auto-save performed every tick during ticking)  \nENHANCED: Use C2ME enhanced auto-save (auto-save performed when the server have spare time after ticking)  \nPERIODIC: Use pre-1.18 vanilla auto-save behavior (auto-save performed every 6000 ticks during ticking)  \n \nPlease preserve quotes so this config don't break\n").getEnum(AutoSaveMode.class, (Enum)AutoSaveMode.ENHANCED, (Enum)AutoSaveMode.VANILLA);

    public static void init() {
    }

    public static enum AutoSaveMode {
        VANILLA(false, false),
        ENHANCED(true, true),
        PERIODIC(true, false);

        public final boolean disableVanillaMidTickAutoSave;
        public final boolean enableEnhancedAutoSave;

        private AutoSaveMode(boolean disableVanillaMidTickAutoSave, boolean enableEnhancedAutoSave) {
            this.disableVanillaMidTickAutoSave = disableVanillaMidTickAutoSave;
            this.enableEnhancedAutoSave = enableEnhancedAutoSave;
        }
    }
}

