/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.util;

import net.minecraft.class_3532;
import org.jetbrains.annotations.Range;

public final class ColorUtil {
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int TEXT_COLOR = -2039584;
    public static final int UNEDITABLE_COLOR = -9408400;

    private ColorUtil() {
        throw new UnsupportedOperationException("ColorUtil only contains static definitions.");
    }

    public static float floatColor(@Range(from=0L, to=255L) int colorComponent) {
        return (float)colorComponent / 255.0f;
    }

    public static @Range(from=0L, to=255L) int intColor(float colorComponent) {
        return class_3532.method_15340((int)((int)(colorComponent * 255.0f)), (int)0, (int)255);
    }

    public static int packARGBColor(@Range(from=0L, to=255L) int red, @Range(from=0L, to=255L) int green, @Range(from=0L, to=255L) int blue, @Range(from=0L, to=255L) int alpha) {
        return ((alpha & 0xFF) << 24) + ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
    }

    public static int[] unpackARGBColor(int color) {
        return new int[]{ColorUtil.argbUnpackRed(color), ColorUtil.argbUnpackGreen(color), ColorUtil.argbUnpackBlue(color), ColorUtil.argbUnpackAlpha(color)};
    }

    public static int argbUnpackRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int argbUnpackGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int argbUnpackBlue(int color) {
        return color & 0xFF;
    }

    public static int argbUnpackAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int argbDarken(int color) {
        return ColorUtil.argbMultiply(color, 0.7f);
    }

    public static int argbMultiply(int color, float multiplier) {
        return ColorUtil.argbMultiply(color, multiplier, ColorUtil.argbUnpackAlpha(color));
    }

    public static int argbMultiply(int color, float multiplier, @Range(from=0L, to=255L) int alpha) {
        return ColorUtil.packARGBColor(class_3532.method_15340((int)((int)((float)ColorUtil.argbUnpackRed(color) * multiplier)), (int)0, (int)255), class_3532.method_15340((int)((int)((float)ColorUtil.argbUnpackGreen(color) * multiplier)), (int)0, (int)255), class_3532.method_15340((int)((int)((float)ColorUtil.argbUnpackBlue(color) * multiplier)), (int)0, (int)255), alpha);
    }

    public static int argbMultiply(int a, int b) {
        float aRed = ColorUtil.floatColor(ColorUtil.argbUnpackRed(a));
        float aGreen = ColorUtil.floatColor(ColorUtil.argbUnpackGreen(a));
        float aBlue = ColorUtil.floatColor(ColorUtil.argbUnpackBlue(a));
        float aAlpha = ColorUtil.floatColor(ColorUtil.argbUnpackAlpha(a));
        float bRed = ColorUtil.floatColor(ColorUtil.argbUnpackRed(b));
        float bGreen = ColorUtil.floatColor(ColorUtil.argbUnpackGreen(b));
        float bBlue = ColorUtil.floatColor(ColorUtil.argbUnpackBlue(b));
        float bAlpha = ColorUtil.floatColor(ColorUtil.argbUnpackAlpha(b));
        return ColorUtil.packARGBColor(ColorUtil.intColor(aRed * bRed), ColorUtil.intColor(aGreen * bGreen), ColorUtil.intColor(aBlue * bBlue), ColorUtil.intColor(aAlpha * bAlpha));
    }
}

