/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.tooltip.Tooltip;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jspecify.annotations.Nullable;

public class SpruceSeparatorWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private @Nullable class_2561 title;
    private List<class_5481> titleToRender = List.of();
    private TooltipData tooltip = TooltipData.EMPTY;
    private int tooltipTicks;
    private long lastTick;

    public SpruceSeparatorWidget(Position position, int width, @Nullable class_2561 title) {
        super(position);
        this.width = width;
        this.setTitle(title);
    }

    @Deprecated
    public SpruceSeparatorWidget(@Nullable class_2561 title, int x, int y, int width) {
        this(Position.of(x, y), width, title);
    }

    public Optional<class_2561> getTitle() {
        return Optional.ofNullable(this.title);
    }

    protected int getTitleWidth() {
        if (this.titleToRender.isEmpty()) {
            return 0;
        }
        int max = this.getWidth() - 8;
        int width = 0;
        for (class_5481 line : this.titleToRender) {
            width = Math.max(width, this.client.field_1772.method_30880(line));
        }
        return Math.min(width, max);
    }

    public void setTitle(@Nullable class_2561 title) {
        this.title = title;
        this.titleToRender = this.title != null ? this.client.field_1772.method_1728((class_5348)this.title, this.getWidth() - 8) : List.of();
        Objects.requireNonNull(this.client.field_1772);
        this.height = 9;
        for (int i = 1; i < this.titleToRender.size(); ++i) {
            Objects.requireNonNull(this.client.field_1772);
            this.height += 2 + 9;
        }
    }

    @Override
    public TooltipData getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(TooltipData tooltip) {
        Objects.requireNonNull(tooltip, "Tooltip cannot be null, the absence of a tooltip is represented by TooltipData.EMPTY.");
        this.tooltip = tooltip;
    }

    @Override
    public boolean requiresCursor() {
        return this.tooltip.isEmpty();
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int lineY = this.getY() + this.getHeight() / 2 - 1;
        if (this.title != null) {
            int titleWidth = this.getTitleWidth();
            int titleX = this.getX() + (this.getWidth() / 2 - titleWidth / 2);
            graphics.fill(this.getX(), lineY, titleX - 5, lineY + 2, -2039584);
            graphics.fill(titleX + titleWidth + 5, lineY, this.getX() + this.getWidth(), lineY + 2, -2039584);
            int y = this.getY();
            for (class_5481 line : this.titleToRender) {
                int lineX = this.getX() + (this.getWidth() / 2 - this.client.field_1772.method_30880(line) / 2);
                graphics.drawShadowedText(this.client.field_1772, line, lineX, y, -1);
                Objects.requireNonNull(this.client.field_1772);
                y += 2 + 9;
            }
        } else {
            graphics.fill(this.getX(), lineY, this.getX() + this.getWidth(), lineY + 2, -2039584);
        }
        Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
            this.tooltipTicks = i;
        }, this.lastTick, i -> {
            this.lastTick = i;
        });
    }

    @Override
    protected @Nullable class_2561 getNarrationMessage() {
        return this.getTitle().map(class_2561::getString).filter(title -> !title.isEmpty()).map(title -> class_2561.method_43469((String)"spruceui.narrator.separator", (Object[])new Object[]{title})).orElse(null);
    }
}

