/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.container.tabbed;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.EmptyBackground;
import dev.lambdaurora.spruceui.border.MenuBorder;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceSeparatorWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.container.AbstractSpruceParentWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8027;
import org.jspecify.annotations.Nullable;

public class SpruceTabbedWidget
extends AbstractSpruceParentWidget<SpruceWidget> {
    private final @Nullable List<class_5481> title;
    private final SideTabList list;
    private final Position anchor;
    private boolean isLeft = false;

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable class_2561 title) {
        this(position, width, height, title, Math.max(100, width / 8));
    }

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable class_2561 title, int sideWidth) {
        super(position, SpruceWidget.class);
        int n;
        this.width = width;
        this.height = height;
        List<class_5481> list = this.title = title != null ? this.client.field_1772.method_1728((class_5348)title, sideWidth - 8) : null;
        if (title == null) {
            n = 0;
        } else {
            int n2 = this.title.size();
            Objects.requireNonNull(this.client.field_1772);
            n = 6 + (n2 * 9 + 4);
        }
        int sideTopOffset = n;
        this.list = new SideTabList(Position.of(position, 0, sideTopOffset), sideWidth, height - sideTopOffset);
        this.anchor = Position.of(this, this.list.getWidth(), 0);
    }

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable class_2561 title, int sideWidth, int sideTopOffset) {
        super(position, SpruceWidget.class);
        this.width = width;
        this.height = height;
        this.title = title != null ? this.client.field_1772.method_1728((class_5348)title, sideWidth - 8) : null;
        this.list = new SideTabList(Position.of(position, 0, sideTopOffset), sideWidth, height - sideTopOffset);
        this.anchor = Position.of(this, this.list.getWidth(), 0);
    }

    public SideTabList getList() {
        return this.list;
    }

    public void addTabEntry(class_2561 title, @Nullable class_2561 description, ContainerFactory factory) {
        this.addTabEntry(title, description, factory.build(this.getWidth() - this.list.getWidth(), this.getHeight()));
    }

    public void addTabEntry(class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
        TabEntry entry = this.list.addTabEntry(title, description, container);
        entry.container.getPosition().setAnchor(this.anchor);
    }

    public void addSeparatorEntry(class_2561 title) {
        this.list.addSeparatorEntry(title);
    }

    public boolean removeTabEntry(class_2561 title) {
        return this.list.removeTabEntry(title);
    }

    public boolean removeSeparatorEntry(class_2561 title) {
        return this.list.removeSeparatorEntry(title);
    }

    @Override
    public void setFocused(@Nullable SpruceWidget focused) {
        super.setFocused(focused);
    }

    @Override
    public List<SpruceWidget> children() {
        if (this.list.getCurrentTab() == null) {
            return List.of(this.list);
        }
        return List.of(this.list, this.list.getCurrentTab().container);
    }

    @Override
    public boolean onNavigation(NavigationEvent event) {
        if (this.requiresCursor()) {
            return false;
        }
        if (this.list.getCurrentTab() == null) {
            return super.onNavigation(event);
        }
        if (event.tab()) {
            boolean result = this.list.getCurrentTab().container.onNavigation(event);
            this.setFocused(this.list.getCurrentTab().container.method_25370() ? this.list.getCurrentTab().container : null);
            return result;
        }
        if (event.direction().method_48237() == class_8027.field_41822) {
            boolean result;
            if (event.isLookingForward()) {
                if (this.list.getCurrentTab().container.onNavigation(event)) {
                    this.setFocused(this.list.getCurrentTab().container);
                }
            } else if (this.getFocused() != this.list && !(result = this.list.getCurrentTab().container.onNavigation(event))) {
                this.setFocused(this.list);
            }
            return true;
        }
        if (!this.method_25370()) {
            this.method_25365(true);
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        } else {
            boolean bl = this.isLeft = this.getFocused() == this.list;
        }
        if (this.getFocused() == null) {
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        }
        return this.getFocused().onNavigation(event);
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.title != null) {
            int y = this.getY() + 6;
            for (class_5481 line : this.title) {
                graphics.drawCenteredShadowedText(this.client.field_1772, line, this.getX() + this.list.getWidth() / 2, y, -1);
                y += 9;
            }
        }
        this.list.render(graphics, mouseX, mouseY, delta);
        if (this.list.getCurrentTab() != null) {
            this.list.getCurrentTab().container.render(graphics, mouseX, mouseY, delta);
        }
    }

    public static class SideTabList
    extends SpruceEntryListWidget<Entry> {
        private @Nullable TabEntry currentTab = null;

        protected SideTabList(Position position, int width, int height) {
            super(position, width, height, 0, Entry.class);
            this.setBorder(MenuBorder.TAB_LIST);
            this.setRenderTransition(false);
        }

        public @Nullable TabEntry getCurrentTab() {
            return this.currentTab;
        }

        @Override
        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused) {
                this.setSelected(this.currentTab);
            }
        }

        public void setSelected(@Nullable TabEntry tab) {
            if (this.currentTab != null) {
                this.currentTab.selected = false;
            }
            if (tab != null) {
                tab.method_25365(true);
            }
            this.setFocused(tab);
            this.currentTab = tab;
        }

        public TabEntry addTabEntry(class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
            TabEntry entry = new TabEntry(this, title, description, container);
            this.addEntry(entry);
            if (this.getCurrentTab() == null) {
                this.setSelected(entry);
            }
            return entry;
        }

        public SeparatorEntry addSeparatorEntry(class_2561 title) {
            SeparatorEntry entry = new SeparatorEntry(this, title);
            this.addEntry(entry);
            return entry;
        }

        @Override
        public boolean removeEntry(Entry entry) {
            if (this.getCurrentTab() == entry) {
                this.refocusTabOnRemoval(entry);
            }
            return super.removeEntry(entry);
        }

        public boolean removeTabEntry(class_2561 title) {
            for (Entry entry : this) {
                if (!(entry instanceof TabEntry) || !entry.getTitle().equals((Object)title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        public boolean removeSeparatorEntry(class_2561 title) {
            for (Entry entry : this) {
                if (!(entry instanceof SeparatorEntry) || !entry.getTitle().equals((Object)title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        protected void refocusTabOnRemoval(Entry focused) {
            Entry entry;
            int index;
            int currentIndex = this.children().indexOf(focused);
            for (index = currentIndex - 1; index >= 0; --index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            for (index = currentIndex + 1; index < this.children().size(); ++index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            this.setSelected(null);
        }

        @Override
        public boolean onNavigation(NavigationEvent event) {
            if (this.requiresCursor()) {
                return false;
            }
            Entry old = (Entry)this.getFocused();
            boolean result = super.onNavigation(event);
            Entry focused = (Entry)this.getFocused();
            if (result && old != focused && focused instanceof TabEntry) {
                TabEntry tabEntry = (TabEntry)focused;
                this.setSelected(tabEntry);
            }
            return result;
        }
    }

    public static interface ContainerFactory {
        public AbstractSpruceWidget build(int var1, int var2);
    }

    public static class TabEntry
    extends Entry {
        private final List<class_5481> title;
        private final @Nullable List<class_5481> description;
        private final AbstractSpruceWidget container;
        private boolean selected;

        protected TabEntry(SideTabList parent, class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
            super(parent, title);
            this.title = this.client.field_1772.method_1728((class_5348)title, this.parent.getWidth() - 18);
            this.description = description == null ? null : this.client.field_1772.method_1728((class_5348)description, this.parent.getWidth() - 18);
            this.container = container;
            if (container instanceof SpruceEntryListWidget) {
                SpruceEntryListWidget listWidget = (SpruceEntryListWidget)container;
                listWidget.setAllowOutsideHorizontalNavigation(true);
            }
        }

        @Override
        public int getHeight() {
            int n;
            int n2 = this.title.size();
            Objects.requireNonNull(this.client.field_1772);
            int n3 = 4 + (n2 * 9 + 4);
            if (this.description == null) {
                n = 0;
            } else {
                int n4 = this.description.size();
                Objects.requireNonNull(this.client.field_1772);
                n = n4 * 9 + 4;
            }
            return n3 + n + 4;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                this.selected = true;
            }
        }

        @Override
        protected boolean onMouseClick(class_11909 event, boolean doubleClick) {
            if (event.method_74245() == 0) {
                this.playDownSound();
                this.parent.setSelected(this);
                return true;
            }
            return false;
        }

        @Override
        protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int y = this.getY() + 4;
            for (class_5481 line : this.title) {
                graphics.drawText(this.client.field_1772, line, this.getX() + 4, y, -1, false);
                y += 9;
            }
            if (this.description != null) {
                y += 4;
                for (class_5481 line : this.description) {
                    graphics.drawText(this.client.field_1772, line, this.getX() + 8, y, -1, false);
                    y += 9;
                }
            }
            if (this.isMouseHovered()) {
                graphics.requestCursor(class_11876.field_62455);
            }
        }

        @Override
        protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            super.renderBackground(graphics, mouseX, mouseY, delta);
            if (this.method_25370() && this.parent.method_25370()) {
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight() - 4, 0x2FFFFFFF);
            } else if (this.selected || this.isMouseHovered()) {
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight() - 4, 0x1AFFFFFF);
            }
        }

        public String toString() {
            return "SpruceTabbedWidget$TabEntry{title=" + String.valueOf(this.getTitle()) + ", description=" + String.valueOf(this.description) + ", position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", container=" + String.valueOf(this.container) + ", selected=" + this.selected + ", background=" + String.valueOf(this.getBackground()) + "}";
        }
    }

    public static class SeparatorEntry
    extends Entry {
        private final SpruceSeparatorWidget separatorWidget;

        protected SeparatorEntry(SideTabList parent, class_2561 title) {
            super(parent, title);
            this.separatorWidget = new SpruceSeparatorWidget(Position.of(this, 0, 2), this.getWidth(), title){

                @Override
                public int getWidth() {
                    return this.getWidth();
                }
            };
        }

        public SpruceSeparatorWidget getSeparatorWidget() {
            return this.separatorWidget;
        }

        @Override
        public int getHeight() {
            return this.separatorWidget.getHeight() + 6;
        }

        @Override
        public boolean onNavigation(NavigationEvent event) {
            return this.separatorWidget.onNavigation(event);
        }

        @Override
        protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.separatorWidget.render(graphics, mouseX, mouseY, delta);
        }

        public String toString() {
            return "SpruceTabbedWidget$SeparatorEntry{title=" + String.valueOf(this.getTitle()) + ", position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", background=" + String.valueOf(this.getBackground()) + "}";
        }
    }

    public static abstract class Entry
    extends SpruceEntryListWidget.Entry
    implements WithBackground {
        protected final SideTabList parent;
        private final class_2561 title;
        private Background background = EmptyBackground.EMPTY_BACKGROUND;

        protected Entry(SideTabList parent, class_2561 title) {
            this.parent = parent;
            this.title = title;
        }

        @Override
        public int getWidth() {
            return this.parent.getInnerWidth();
        }

        public class_2561 getTitle() {
            return this.title;
        }

        @Override
        public Background getBackground() {
            return this.background;
        }

        @Override
        public void setBackground(Background background) {
            this.background = background;
        }

        @Override
        protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.getBackground().render(graphics, this, 0, mouseX, mouseY, delta);
        }
    }
}

