/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.border.TexturedBorder;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.WithBorder;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSpruceTextInputWidget<C extends Cursor<C>>
extends AbstractSpruceWidget
implements WithBackground,
WithBorder {
    private final class_2561 title;
    private Background background = new SimpleColorBackground(-16777216);
    private Border border = TexturedBorder.SIMPLE;
    private @Nullable class_2561 placeholder;
    private int editableColor = -2039584;
    private int uneditableColor = -9408400;

    public AbstractSpruceTextInputWidget(Position position, int width, int height, class_2561 title) {
        this(position, width, height, title, null);
    }

    public AbstractSpruceTextInputWidget(Position position, int width, int height, class_2561 title, @Nullable class_2561 placeholder) {
        super(position);
        this.width = width;
        this.height = height;
        this.title = title;
        this.placeholder = placeholder;
    }

    public abstract String getText();

    public abstract void setText(@Nullable String var1);

    public class_2561 getTitle() {
        return this.title;
    }

    public @Nullable class_2561 getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(@Nullable class_2561 placeholder) {
        this.placeholder = placeholder;
    }

    public int getEditableColor() {
        return this.editableColor;
    }

    public void setEditableColor(int editableColor) {
        this.editableColor = editableColor;
    }

    public int getUneditableColor() {
        return this.uneditableColor;
    }

    public void setUneditableColor(int uneditableColor) {
        this.uneditableColor = uneditableColor;
    }

    public int getTextColor() {
        return this.method_37303() ? this.getEditableColor() : this.getUneditableColor();
    }

    public abstract void setCursorToStart();

    public abstract void setCursorToEnd();

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    public int getInnerWidth() {
        return this.getWidth() - 6 - this.getBorder().getThickness() * 2;
    }

    public int getInnerHeight() {
        return this.getHeight() - 6 - this.getBorder().getThickness() * 2;
    }

    protected abstract void sanitize();

    public boolean isEditable() {
        return this.method_37303();
    }

    public boolean isEditorActive() {
        return this.method_37303() && this.method_25370();
    }

    protected abstract C cursor();

    protected abstract Selection selection();

    protected abstract void insertCharacter(String var1);

    @Override
    protected boolean onCharTyped(class_11905 event) {
        if (!this.isEditorActive() || !event.method_74227()) {
            return false;
        }
        if (this.isEditable()) {
            this.insertCharacter(event.method_74226());
            this.selection().cancel();
        }
        return true;
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.getBorder().render(graphics, this, mouseX, mouseY, delta);
        if (this.isMouseHovered()) {
            graphics.requestCursor(this.isEditable() ? class_11876.field_62453 : class_11876.field_62459);
        }
    }

    @Override
    protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.getBackground().render(graphics, this, 0, mouseX, mouseY, delta);
    }

    @Override
    protected class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{this.getTitle(), this.getText()});
    }

    protected static abstract class Selection {
        protected final C anchor;
        protected final C follower;
        protected boolean active = false;
        final /* synthetic */ AbstractSpruceTextInputWidget this$0;

        protected Selection(C anchor, C follower) {
            this.this$0 = this$0;
            this.anchor = anchor;
            this.follower = follower;
        }

        public void cancel() {
            this.anchor.toStart();
            this.follower.toStart();
            this.active = false;
        }

        public void selectAll() {
            this.anchor.toStart();
            this.this$0.cursor().toEnd();
            this.follower.copy(this.this$0.cursor());
            this.active = true;
        }

        public void startSelection() {
            this.anchor.copy(this.this$0.cursor());
            this.follower.copy(this.this$0.cursor());
            this.active = true;
        }

        public void tryStartSelection(boolean hasShiftDown) {
            if (!this.active && hasShiftDown) {
                this.startSelection();
            }
        }

        public void moveToCursor(boolean hasShiftDown) {
            if (!this.active) {
                return;
            }
            if (hasShiftDown) {
                this.follower.copy(this.this$0.cursor());
            } else {
                this.cancel();
            }
        }

        public C getStart() {
            return this.isInverted() ? this.follower : this.anchor;
        }

        public C getEnd() {
            return this.isInverted() ? this.anchor : this.follower;
        }

        protected abstract boolean isInverted();

        public abstract String getSelectedText();
    }

    protected static interface Cursor<C extends Cursor<C>> {
        public void toStart();

        public void toEnd();

        public void copy(C var1);
    }
}

