/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_5481;
import org.jspecify.annotations.Nullable;

public class SpruceTextFieldWidgetBuilder {
    private final Position position;
    private final int width;
    private final int height;
    private @Nullable class_2561 title;
    private @Nullable class_2561 placeholder;
    private @Nullable Consumer<String> onChange;
    private @Nullable Predicate<String> textPredicate;
    private @Nullable BiFunction<String, Integer, class_5481> renderTextProvider;

    public SpruceTextFieldWidgetBuilder(Position position, int width, int height) {
        this.position = position;
        this.width = width;
        this.height = height;
    }

    public SpruceTextFieldWidgetBuilder title(class_2561 title) {
        this.title = title;
        return this;
    }

    public SpruceTextFieldWidgetBuilder placeholder() {
        this.placeholder = this.title;
        return this;
    }

    public SpruceTextFieldWidgetBuilder placeholder(class_2561 placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public SpruceTextFieldWidgetBuilder onChange(Consumer<String> onChange) {
        this.onChange = onChange;
        return this;
    }

    public SpruceTextFieldWidgetBuilder textPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
        return this;
    }

    public SpruceTextFieldWidgetBuilder renderTextProvider(BiFunction<String, Integer, class_5481> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
        return this;
    }

    public SpruceTextFieldWidget build() {
        Objects.requireNonNull(this.title, "Text fields require a title.");
        SpruceTextFieldWidget widget = new SpruceTextFieldWidget(this.position, this.width, this.height, this.title, this.placeholder);
        if (this.onChange != null) {
            widget.setChangedListener(this.onChange);
        }
        if (this.textPredicate != null) {
            widget.setTextPredicate(this.textPredicate);
        }
        if (this.renderTextProvider != null) {
            widget.setRenderTextProvider(this.renderTextProvider);
        }
        return widget;
    }

    public SpruceNamedTextFieldWidget buildNamed() {
        return new SpruceNamedTextFieldWidget(this.build());
    }
}

