/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.async_chunkio;

import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSerializationManager {
    public static final boolean DEBUG = Boolean.getBoolean("c2me.chunkio.debug");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Async Serialization Manager");
    private static final ThreadLocal<ArrayDeque<Scope>> scopeHolder = ThreadLocal.withInitial(ArrayDeque::new);

    public static void push(Scope scope) {
        scopeHolder.get().push(scope);
    }

    public static Scope getScope(class_1923 pos) {
        Scope scope = scopeHolder.get().peek();
        if (pos == null) {
            return scope;
        }
        if (scope != null) {
            if (scope.pos.equals((Object)pos)) {
                return scope;
            }
            LOGGER.error("Scope position mismatch! Expected: {} but got {}.", new Object[]{scope.pos, pos, new Throwable()});
        }
        return null;
    }

    public static void pop(Scope scope) {
        if (scope != scopeHolder.get().peek()) {
            throw new IllegalArgumentException("Scope mismatch");
        }
        scopeHolder.get().pop();
    }

    public static class Scope {
        public final class_1923 pos;
        public final Map<class_2338, class_2487> blockEntities;
        private final AtomicBoolean isOpen = new AtomicBoolean(false);

        public Scope(class_2791 chunk, class_3218 world) {
            this.pos = chunk.method_12004();
            Object2ReferenceLinkedOpenHashMap blockEntities = new Object2ReferenceLinkedOpenHashMap();
            for (class_2338 blockPos : chunk.method_12021()) {
                class_2487 nbt = chunk.method_20598(blockPos, (class_7225.class_7874)world.method_30349());
                if (nbt == null) {
                    LOGGER.warn("Block entity at {} for block {} in chunk {} is missing", new Object[]{blockPos, chunk.method_8320(blockPos), chunk.method_12004()});
                }
                if (blockEntities.containsKey(blockPos)) {
                    LOGGER.warn("Duplicate block entity at {} in chunk {}", (Object)blockPos, (Object)chunk.method_12004());
                    continue;
                }
                blockEntities.put(blockPos, nbt);
            }
            this.blockEntities = blockEntities;
        }

        public void open() {
            if (!this.isOpen.compareAndSet(false, true)) {
                throw new IllegalStateException("Cannot use scope twice");
            }
        }
    }
}

