/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.statuses;

import com.ishland.c2me.base.common.scheduler.AbstractPosAwarePrioritizedTask;
import com.ishland.c2me.base.common.scheduler.LockTokenImpl;
import com.ishland.c2me.base.common.scheduler.ScheduledTask;
import com.ishland.c2me.base.common.scheduler.SchedulingManager;
import com.ishland.c2me.base.common.threadstate.RunningWork;
import com.ishland.c2me.base.common.threadstate.ThreadInstrumentation;
import com.ishland.c2me.base.common.threadstate.ThreadState;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkLoadingContext;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkState;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkStatus;
import com.ishland.c2me.rewrites.chunksystem.common.threadstate.ChunkTaskWork;
import com.ishland.flowsched.executor.LockToken;
import com.ishland.flowsched.scheduler.Cancellable;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.ItemStatus;
import com.ishland.flowsched.scheduler.KeyStatusPair;
import io.reactivex.rxjava3.core.Completable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_9312;
import net.minecraft.class_9767;
import net.minecraft.class_9768;
import net.minecraft.class_9770;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWorldGenerationDelegate
extends NewChunkStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VanillaWorldGenerationDelegate");
    private final class_2806 status;
    private final KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] genDeps;
    private final KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] loadDeps;
    @Nullable
    private final KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] toRemove;
    @Nullable
    private final KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] toAdd;

    private static KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependencyFromStep(class_9770 step) {
        ArrayList<KeyStatusPair> deps = new ArrayList<KeyStatusPair>();
        class_9767 directDependencies = step.comp_2804();
        for (int x = -directDependencies.method_60517(); x <= directDependencies.method_60517(); ++x) {
            for (int z = -directDependencies.method_60517(); z <= directDependencies.method_60517(); ++z) {
                if (x == 0 && z == 0) continue;
                KeyStatusPair dep = new KeyStatusPair((Object)new class_1923(x, z), (ItemStatus)VanillaWorldGenerationDelegate.fromVanillaStatus(directDependencies.method_60514(Math.max(Math.abs(x), Math.abs(z)))));
                deps.add(dep);
            }
        }
        return (KeyStatusPair[])deps.toArray(KeyStatusPair[]::new);
    }

    private static <T> CompletableFuture<T> runTaskWithLock(class_1923 target, int radius, SchedulingManager schedulingManager, Supplier<CompletableFuture<T>> action) {
        ObjectArrayList lockTargets = new ObjectArrayList((2 * radius + 1) * (2 * radius + 1) + 1);
        for (int x = target.field_9181 - radius; x <= target.field_9181 + radius; ++x) {
            for (int z = target.field_9180 - radius; z <= target.field_9180 + radius; ++z) {
                lockTargets.add((Object)new LockTokenImpl(schedulingManager.getId(), class_1923.method_8331((int)x, (int)z), LockTokenImpl.Usage.WORLDGEN));
            }
        }
        ScheduledTask task = new ScheduledTask(target.method_8324(), action, (LockToken[])lockTargets.toArray(LockToken[]::new));
        schedulingManager.enqueue((AbstractPosAwarePrioritizedTask)task);
        return task.getFuture();
    }

    public VanillaWorldGenerationDelegate(int ordinal, class_2806 status) {
        super(ordinal, status);
        this.status = status;
        class_9770 genStep = class_9768.field_51900.method_60518(status);
        class_9770 loadStep = class_9768.field_51901.method_60518(status);
        this.genDeps = VanillaWorldGenerationDelegate.getDependencyFromStep(genStep);
        this.loadDeps = VanillaWorldGenerationDelegate.getDependencyFromStep(loadStep);
        if (this.genDeps.length != this.loadDeps.length) {
            ObjectOpenHashSet toRemove = new ObjectOpenHashSet((Object[])this.genDeps);
            toRemove.removeAll(List.of(this.loadDeps));
            this.toRemove = (KeyStatusPair[])toRemove.toArray(KeyStatusPair[]::new);
            ObjectOpenHashSet toAdd = new ObjectOpenHashSet((Object[])this.loadDeps);
            toAdd.removeAll(List.of(this.genDeps));
            this.toAdd = (KeyStatusPair[])toAdd.toArray(KeyStatusPair[]::new);
        } else if (Arrays.equals(this.genDeps, this.loadDeps)) {
            this.toRemove = EMPTY_DEPENDENCIES;
            this.toAdd = EMPTY_DEPENDENCIES;
        } else {
            LOGGER.warn("VanillaWorldGenerationDelegate with status {} has the same dependencies length for generation and loading", (Object)status);
            this.toRemove = null;
            this.toAdd = null;
        }
    }

    public Completable upgradeToThis(ChunkLoadingContext context, Cancellable cancellable) {
        ChunkState state = (ChunkState)context.holder().getItem().get();
        if (state.reachedStatus().method_12165(this.status)) {
            return Completable.complete();
        }
        class_9312 chunkGenerationContext = ((IThreadedAnvilChunkStorage)context.tacs()).getGenerationContext();
        class_2791 chunk = state.chunk();
        if (chunk.method_12009().method_12165(this.status)) {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                Completable completable = Completable.defer(() -> Completable.fromCompletionStage((CompletionStage)class_9768.field_51901.method_60518(this.status).method_60560(((IThreadedAnvilChunkStorage)context.tacs()).getGenerationContext(), context.chunks(), chunk).whenComplete((chunk1, throwable) -> {
                    if (chunk1 != null) {
                        context.holder().getItem().set(new ChunkState((class_2791)chunk1, (class_2839)chunk1, this.status));
                    }
                })));
                return completable;
            }
        }
        class_9770 step = class_9768.field_51900.method_60518(this.status);
        int radius = Math.max(0, step.comp_2806());
        return Completable.defer(() -> Completable.fromCompletionStage(VanillaWorldGenerationDelegate.runTaskWithLock(chunk.method_12004(), radius, context.schedulingManager(), () -> {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                CompletionStage completionStage = ((CompletableFuture)step.method_60560(chunkGenerationContext, context.chunks(), chunk).whenComplete((chunk1, throwable) -> {
                    if (chunk1 != null) {
                        context.holder().getItem().set(new ChunkState((class_2791)chunk1, (class_2839)chunk1, this.status));
                    }
                })).thenAccept(__ -> {});
                return completionStage;
            }
        })));
    }

    public Completable postUpgradeToThis(ChunkLoadingContext context) {
        return Completable.complete();
    }

    public Completable preDowngradeFromThis(ChunkLoadingContext context, Cancellable cancellable) {
        return Completable.complete();
    }

    public Completable downgradeFromThis(ChunkLoadingContext context, Cancellable cancellable) {
        return Completable.complete();
    }

    @Override
    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependencies(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        class_2791 chunk = ((ChunkState)holder.getItem().get()).chunk();
        if (chunk == null) {
            return this.genDeps;
        }
        if (chunk.method_12009().method_12165(this.status)) {
            return VanillaWorldGenerationDelegate.relativeToAbsoluteDependencies(holder, this.loadDeps);
        }
        return VanillaWorldGenerationDelegate.relativeToAbsoluteDependencies(holder, this.genDeps);
    }

    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToRemove(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        if (this.toRemove == null) {
            return super.getDependenciesToRemove(holder);
        }
        KeyStatusPair[] curDep = holder.getDependencies((ItemStatus)this);
        if (curDep.length == this.loadDeps.length) {
            return EMPTY_DEPENDENCIES;
        }
        if (curDep.length == this.genDeps.length) {
            class_2791 chunk = ((ChunkState)holder.getItem().get()).chunk();
            if (chunk == null) {
                return EMPTY_DEPENDENCIES;
            }
            if (!chunk.method_12009().method_12165(this.status)) {
                return EMPTY_DEPENDENCIES;
            }
            return VanillaWorldGenerationDelegate.relativeToAbsoluteDependencies(holder, this.toRemove);
        }
        LOGGER.warn("Suspicious dependencies length for VanillaWorldGenerationDelegate with status {} on holder {}", (Object)this.status, holder.getKey());
        return super.getDependenciesToRemove(holder);
    }

    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToAdd(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        if (this.toAdd == null) {
            return super.getDependenciesToAdd(holder);
        }
        KeyStatusPair[] curDep = holder.getDependencies((ItemStatus)this);
        if (curDep.length == this.loadDeps.length) {
            return EMPTY_DEPENDENCIES;
        }
        if (curDep.length == this.genDeps.length) {
            class_2791 chunk = ((ChunkState)holder.getItem().get()).chunk();
            if (chunk == null) {
                return EMPTY_DEPENDENCIES;
            }
            if (!chunk.method_12009().method_12165(this.status)) {
                return EMPTY_DEPENDENCIES;
            }
            return VanillaWorldGenerationDelegate.relativeToAbsoluteDependencies(holder, this.toAdd);
        }
        LOGGER.warn("Suspicious dependencies length for VanillaWorldGenerationDelegate with status {} on holder {}", (Object)this.status, holder.getKey());
        return super.getDependenciesToAdd(holder);
    }

    public String toString() {
        return this.status.toString();
    }
}

