/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.structs;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class DynamicPriorityQueue<E> {
    private final AtomicIntegerArray taskCount;
    private final ConcurrentLinkedQueue<E>[] priorities;
    private final ConcurrentHashMap<E, Integer> priorityMap = new ConcurrentHashMap();

    public DynamicPriorityQueue(int priorityCount) {
        this.taskCount = new AtomicIntegerArray(priorityCount);
        this.priorities = new ConcurrentLinkedQueue[priorityCount];
        for (int i = 0; i < priorityCount; ++i) {
            this.priorities[i] = new ConcurrentLinkedQueue();
        }
    }

    public void enqueue(E element, int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            throw new IllegalArgumentException("Priority out of range");
        }
        if (this.priorityMap.putIfAbsent(element, priority) != null) {
            throw new IllegalArgumentException("Element already in queue");
        }
        this.priorities[priority].add(element);
        this.taskCount.incrementAndGet(priority);
    }

    public boolean changePriority(E element, int priority) {
        boolean changeSuccess;
        if (priority < 0 || priority >= this.priorities.length) {
            throw new IllegalArgumentException("Priority out of range");
        }
        int currentPriority = this.priorityMap.getOrDefault(element, -1);
        if (currentPriority == -1 || currentPriority == priority) {
            return false;
        }
        boolean removedFromQueue = this.priorities[currentPriority].remove(element);
        if (!removedFromQueue) {
            return false;
        }
        this.taskCount.decrementAndGet(currentPriority);
        Integer put = this.priorityMap.put(element, priority);
        boolean bl = changeSuccess = put != null && put == currentPriority;
        if (!changeSuccess) {
            return false;
        }
        this.priorities[priority].add(element);
        this.taskCount.incrementAndGet(priority);
        return true;
    }

    public E dequeue() {
        for (int i = 0; i < this.priorities.length; ++i) {
            E element;
            if (this.taskCount.get(i) == 0 || (element = this.priorities[i].poll()) == null) continue;
            this.taskCount.decrementAndGet(i);
            this.priorityMap.remove(element);
            return element;
        }
        return null;
    }

    public boolean contains(E element) {
        return this.priorityMap.containsKey(element);
    }

    public void remove(E element) {
        Integer remove = this.priorityMap.remove(element);
        if (remove == null) {
            return;
        }
        boolean removed = this.priorities[remove].remove(element);
        if (removed) {
            this.taskCount.decrementAndGet(remove);
        }
    }

    public int size() {
        return this.priorityMap.size();
    }
}

