/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.scheduler;

import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.mixin.LevelRendererAccessor;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Closeable;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_4076;

public abstract class ChunkRebuildScheduler
implements Closeable {
    protected final class_310 client = class_310.method_1551();
    protected final DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer;
    private int sourceUpdatedLastTick = 0;

    protected ChunkRebuildScheduler(DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer) {
        this.sectionRebuildDebugRenderer = sectionRebuildDebugRenderer;
    }

    public int getSourceUpdatedLastTick() {
        return this.sourceUpdatedLastTick;
    }

    public void appendF3Debug(Consumer<String> consumer) {
    }

    public final void update(DynamicLightSource lightSource, Long2ObjectMap<ChunkRebuildStatus> chunks) {
        if (!chunks.isEmpty()) {
            ++this.sourceUpdatedLastTick;
            this.accept(lightSource, chunks);
        }
    }

    protected abstract void accept(DynamicLightSource var1, Long2ObjectMap<ChunkRebuildStatus> var2);

    public final void remove(DynamicLightSource lightSource) {
        Long2ObjectMap<ChunkRebuildStatus> chunks = lightSource.getDynamicLightChunksToRebuild(true);
        if (!chunks.isEmpty()) {
            ++this.sourceUpdatedLastTick;
        }
        this.remove(lightSource, chunks.keySet());
    }

    protected abstract void remove(DynamicLightSource var1, LongSet var2);

    @Override
    public void close() {
    }

    public void startTick() {
        this.sourceUpdatedLastTick = 0;
    }

    public void endTick() {
    }

    protected final void scheduleChunkRebuild(long chunkPos) {
        this.scheduleChunkRebuild(class_4076.method_18686((long)chunkPos), class_4076.method_18689((long)chunkPos), class_4076.method_18690((long)chunkPos));
        this.sectionRebuildDebugRenderer.scheduleChunkRebuild(chunkPos);
    }

    private void scheduleChunkRebuild(int x, int y, int z) {
        if (this.client.field_1687 != null) {
            ((LevelRendererAccessor)this.client.field_1769).lambdynlights$scheduleChunkRebuild(x, y, z, false);
        }
    }
}

