/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.scheduler;

import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildScheduler;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.util.DynamicLightDebugRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Consumer;

public final class SimpleChunkRebuildScheduler
extends ChunkRebuildScheduler {
    private int rebuildRequestedLastTick = 0;

    public SimpleChunkRebuildScheduler(DynamicLightDebugRenderer.SectionRebuild sectionRebuildDebugRenderer) {
        super(sectionRebuildDebugRenderer);
    }

    @Override
    public void appendF3Debug(Consumer<String> consumer) {
        consumer.accept("Scheduled Chunk Rebuilds (Immediate): %d".formatted(this.rebuildRequestedLastTick));
    }

    @Override
    protected void accept(DynamicLightSource lightSource, Long2ObjectMap<ChunkRebuildStatus> chunks) {
        this.rebuildRequestedLastTick += chunks.size();
        chunks.keySet().forEach(this::scheduleChunkRebuild);
    }

    @Override
    protected void remove(DynamicLightSource lightSource, LongSet chunks) {
        this.rebuildRequestedLastTick += chunks.size();
        chunks.forEach(this::scheduleChunkRebuild);
    }

    @Override
    public void startTick() {
        super.startTick();
        this.rebuildRequestedLastTick = 0;
    }
}

