/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.Unit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class LightSourceLoader<L>
implements class_3302 {
    protected static final String SILENCE_ERROR_KEY = "silence_error";
    private final class_310 client = class_310.method_1551();
    private final ApplicationPredicate applicationPredicate;
    protected final List<LoadedLightSourceResource> loadedLightSources = new ArrayList<LoadedLightSourceResource>();
    protected List<L> lightSources = List.of();

    protected LightSourceLoader(ApplicationPredicate applicationPredicate) {
        this.applicationPredicate = applicationPredicate;
    }

    public abstract class_2960 id();

    public abstract @Unmodifiable Collection<class_2960> dependencies();

    public abstract Logger getLogger();

    public abstract String getResourcePath();

    public String method_22322() {
        return this.id().toString();
    }

    public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor prepareExecutor, class_3302.class_4045 synchronizer, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.load(sharedState.method_72361());
            return Unit.INSTANCE;
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(reloadState -> {
            if (this.client.field_1687 != null) {
                this.apply((class_7225.class_7874)this.client.field_1687.method_30349());
            }
        }, applyExecutor);
    }

    protected void load(class_3300 resourceManager) {
        this.loadedLightSources.clear();
        resourceManager.method_14488("dynamiclights/" + this.getResourcePath(), path -> path.method_12832().endsWith(".json")).forEach(this::load);
    }

    public final void apply(class_7225.class_7874 registryLookup) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryLookup);
        ArrayList lightSources = this.loadedLightSources.stream().filter(data -> this.canApply((class_6903<JsonElement>)ops, (LoadedLightSourceResource)data)).map(data -> this.apply((DynamicOps<JsonElement>)ops, (LoadedLightSourceResource)data)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
        this.doApply(registryLookup, lightSources);
        this.lightSources = lightSources;
    }

    protected void doApply(class_7225.class_7874 registryLookup, List<L> lightSources) {
    }

    protected void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = class_2960.method_60655((String)resourceId.method_12836(), (String)resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            if (!rawJson.isJsonObject()) {
                LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\". Expected JSON object in file.", this.getResourcePath(), id);
                return;
            }
            JsonObject json = rawJson.getAsJsonObject();
            boolean silentError = false;
            if (json.has(SILENCE_ERROR_KEY)) {
                silentError = json.get(SILENCE_ERROR_KEY).getAsBoolean();
                json.remove(SILENCE_ERROR_KEY);
            }
            this.loadedLightSources.add(new LoadedLightSourceResource(id, json, silentError));
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\".", this.getResourcePath(), id, e);
        }
    }

    protected abstract Optional<L> apply(DynamicOps<JsonElement> var1, LoadedLightSourceResource var2);

    protected boolean canApply(class_6903<JsonElement> ops, LoadedLightSourceResource loadedData) {
        return this.applicationPredicate.canApply(this, ops, loadedData);
    }

    @FunctionalInterface
    public static interface ApplicationPredicate {
        public boolean canApply(LightSourceLoader<?> var1, class_6903<JsonElement> var2, LoadedLightSourceResource var3);

        public static class Pending
        implements ApplicationPredicate {
            private @Nullable ApplicationPredicate wrapped;

            public void set(@Nullable ApplicationPredicate wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public boolean canApply(LightSourceLoader<?> loader, class_6903<JsonElement> ops, LoadedLightSourceResource loadedData) {
                return this.wrapped == null || this.wrapped.canApply(loader, ops, loadedData);
            }
        }
    }
}

