/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.OidcDiscoveryResponse;
import java.net.MalformedURLException;
import java.net.URL;

public class OidcAuthority
extends Authority {
    static final String WELL_KNOWN_OPENID_CONFIGURATION = ".well-known/openid-configuration";
    private static final String AUTHORITY_FORMAT = "https://%s/%s/";

    OidcAuthority(URL authorityUrl) throws MalformedURLException {
        super(OidcAuthority.createOidcDiscoveryUrl(authorityUrl), AuthorityType.OIDC);
        this.authority = String.format(AUTHORITY_FORMAT, this.host, this.tenant);
    }

    private static URL createOidcDiscoveryUrl(URL originalAuthority) throws MalformedURLException {
        String authority = originalAuthority.toString();
        authority = authority + WELL_KNOWN_OPENID_CONFIGURATION;
        return new URL(authority);
    }

    void setAuthorityProperties(OidcDiscoveryResponse instanceDiscoveryResponse) {
        this.authorizationEndpoint = instanceDiscoveryResponse.authorizationEndpoint();
        this.tokenEndpoint = instanceDiscoveryResponse.tokenEndpoint();
        this.deviceCodeEndpoint = instanceDiscoveryResponse.deviceCodeEndpoint();
        this.selfSignedJwtAudience = this.tokenEndpoint;
    }
}

