/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import java.net.InetAddress;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.TypeMapping;
import jdk.jfr.events.SocketReadEvent;
import oracle.jrockit.jfr.VMJFR;

@InstrumentationTarget(value="java.net.SocketInputStream")
@TypeMapping(from="oracle.jrockit.jfr.SocketInputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketInputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketInputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    int read(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (!VMJFR.socketReadToken.isEnabled()) {
            return this.read(byArray, n, n2, n3);
        }
        SocketReadEvent socketReadEvent = new SocketReadEvent(VMJFR.socketReadToken);
        int n4 = -1;
        try {
            socketReadEvent.begin();
            n4 = this.read(byArray, n, n2, n3);
        }
        finally {
            String string = this.impl.address.toString();
            int n5 = string.lastIndexOf(47);
            socketReadEvent.host = string.substring(0, n5);
            socketReadEvent.address = string.substring(n5 + 1);
            socketReadEvent.port = this.impl.port;
            socketReadEvent.bytesRead = n4;
            socketReadEvent.timeout = n3;
            socketReadEvent.commit();
        }
        return n4;
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

