/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride;

import io.github.queerbric.pride.PrideFlag;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.jspecify.annotations.Nullable;

public class PrideFlags {
    private static List<PrideFlag> flags = new ArrayList<PrideFlag>();
    private static Map<String, PrideFlag> flagsById = new Object2ObjectOpenHashMap();
    private static final Random DEFAULT_RANDOM = new Random();
    private static final boolean PRIDE_MONTH = Calendar.getInstance(Locale.ENGLISH).get(2) == 5 || Boolean.getBoolean("everyMonthIsPrideMonth");

    protected static void setFlags(List<PrideFlag> flags) {
        PrideFlags.flags = Collections.unmodifiableList(flags);
        Object2ObjectOpenHashMap flagsById = new Object2ObjectOpenHashMap(flags.size());
        for (PrideFlag flag : flags) {
            flagsById.put((Object)flag.getId(), (Object)flag);
        }
        PrideFlags.flagsById = Collections.unmodifiableMap(flagsById);
    }

    public static List<PrideFlag> getFlags() {
        return flags;
    }

    public static @Nullable PrideFlag getFlag(String id) {
        return flagsById.get(id);
    }

    public static @Nullable PrideFlag getRandomFlag(Random random) {
        if (flags.isEmpty()) {
            return null;
        }
        return flags.get(random.nextInt(flags.size()));
    }

    public static @Nullable PrideFlag getRandomFlag() {
        return PrideFlags.getRandomFlag(DEFAULT_RANDOM);
    }

    public static boolean isPrideMonth() {
        return PRIDE_MONTH;
    }
}

