/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class PrideData {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");
    public static final Codec<Integer> COLOR_CODEC = Codec.STRING.flatXmap(raw -> {
        if (!HEX_COLOR_PATTERN.matcher((CharSequence)raw).matches()) {
            return DataResult.error(() -> raw + " is not a valid color, must be a six-digit hex color like #ff00ff");
        }
        int color = Integer.parseInt(raw.substring(1), 16);
        return DataResult.success((Object)(color | 0xFF000000));
    }, color -> {
        int rgb = color & 0xFFFFFF;
        Object hex = Integer.toHexString(rgb);
        if (((String)hex).length() < 6) {
            hex = "0".repeat(6 - ((String)hex).length()) + (String)hex;
        }
        return DataResult.success((Object)("#" + (String)hex));
    });
    public static final Codec<IntList> COLOR_LIST_CODEC = COLOR_CODEC.listOf().xmap(colors -> {
        IntArrayList list = new IntArrayList(colors.size());
        list.addAll((Collection)colors);
        return list;
    }, Function.identity());

    private PrideData() {
        throw new UnsupportedOperationException("PrideData only contains static definitions.");
    }
}

