/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.api;

import com.mojang.logging.LogUtils;
import dev.yumi.commons.event.Event;
import dev.yumi.mc.core.api.YumiEvents;
import dev.yumi.mc.core.api.event.EventAwareListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5539;
import net.minecraft.class_6396;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class CrashReportEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<class_2960, Creation> CREATE = YumiEvents.EVENTS.create(Creation.class, listeners -> report -> {
        for (Creation listener : listeners) {
            try {
                listener.onCrashReportCreation(report);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger crash report listener {}:", (Object)listener, (Object)e);
            }
        }
    });
    public static final Event<class_2960, SystemDetailsPopulation> SYSTEM_DETAILS_POPULATE = YumiEvents.EVENTS.create(SystemDetailsPopulation.class, listeners -> report -> {
        for (SystemDetailsPopulation listener : listeners) {
            try {
                listener.onCrashReportSystemDetailsPopulation(report);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger system details population listener {}:", (Object)listener, (Object)e);
            }
        }
    });
    public static final Event<class_2960, EntityDetailsPopulation> ENTITY_DETAILS_POPULATE = YumiEvents.EVENTS.create(EntityDetailsPopulation.class, listeners -> (entity, category) -> {
        for (EntityDetailsPopulation listener : listeners) {
            try {
                listener.onCrashReportEntityDetailsPopulation(entity, category);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger entity details population listener {}:", (Object)listener, (Object)e);
            }
        }
    });
    public static final Event<class_2960, BlockEntityDetailsPopulation> BLOCK_ENTITY_DETAILS_POPULATE = YumiEvents.EVENTS.create(BlockEntityDetailsPopulation.class, listeners -> (blockEntity, category) -> {
        for (BlockEntityDetailsPopulation listener : listeners) {
            try {
                listener.onCrashReportBlockEntityDetailsPopulation(blockEntity, category);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger block entity details population listener {}:", (Object)listener, (Object)e);
            }
        }
    });
    public static final Event<class_2960, BlockDetailsPopulation> BLOCK_DETAILS_POPULATE = YumiEvents.EVENTS.create(BlockDetailsPopulation.class, listeners -> (level, pos, state, category) -> {
        for (BlockDetailsPopulation listener : listeners) {
            try {
                listener.onCrashReportBlockDetailsPopulation(level, pos, state, category);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger block details population listener {}:", (Object)listener, (Object)e);
            }
        }
    });
    public static final Event<class_2960, LevelDetailsPopulation> LEVEL_DETAILS_POPULATE = YumiEvents.EVENTS.create(LevelDetailsPopulation.class, listeners -> (level, category) -> {
        for (LevelDetailsPopulation listener : listeners) {
            try {
                listener.onCrashReportLevelDetailsPopulation(level, category);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to trigger level details population listener {}:", (Object)listener, (Object)e);
            }
        }
    });

    @FunctionalInterface
    public static interface LevelDetailsPopulation
    extends EventAwareListener {
        public void onCrashReportLevelDetailsPopulation(class_1937 var1, class_129 var2);
    }

    @FunctionalInterface
    public static interface BlockDetailsPopulation
    extends EventAwareListener {
        public void onCrashReportBlockDetailsPopulation(class_5539 var1, class_2338 var2, @Nullable class_2680 var3, class_129 var4);
    }

    @FunctionalInterface
    public static interface BlockEntityDetailsPopulation
    extends EventAwareListener {
        public void onCrashReportBlockEntityDetailsPopulation(class_2586 var1, class_129 var2);
    }

    @FunctionalInterface
    public static interface EntityDetailsPopulation
    extends EventAwareListener {
        public void onCrashReportEntityDetailsPopulation(class_1297 var1, class_129 var2);
    }

    @FunctionalInterface
    public static interface SystemDetailsPopulation
    extends EventAwareListener {
        public void onCrashReportSystemDetailsPopulation(class_6396 var1);
    }

    @FunctionalInterface
    public static interface Creation
    extends EventAwareListener {
        public void onCrashReportCreation(class_128 var1);
    }
}

