/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.api;

import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.impl.YumiModsImpl;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.UnmodifiableView;

public interface YumiMods {
    public static YumiMods get() {
        return YumiModsImpl.INSTANCE;
    }

    public boolean isDevelopmentEnvironment();

    public Path getGameDirectory();

    public Path getConfigDirectory();

    public Optional<ModContainer> getMod(String var1);

    public boolean isModLoaded(String var1);

    public @UnmodifiableView Collection<ModContainer> getMods();

    public <T> List<EntrypointContainer<T>> getEntrypoints(String var1, Class<T> var2);

    default public <T> void invokeEntrypoints(String key, Class<T> type, BiConsumer<T, ModContainer> action) {
        List<EntrypointContainer<T>> entrypoints = this.getEntrypoints(key, type);
        for (EntrypointContainer<T> entrypoint : entrypoints) {
            action.accept(entrypoint.value(), entrypoint.mod());
        }
    }
}

