/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl;

import dev.yumi.mc.core.impl.neoforge.DeferredRegisterUndeferrer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForgeMod;

interface CurrentRuntime {
    public boolean isDevelopmentEnvironment();

    public Path getGameDirectory();

    public Path getConfigDirectory();

    default public void init() {
    }

    public static class NeoForgeRuntime
    implements CurrentRuntime {
        @Override
        public boolean isDevelopmentEnvironment() {
            return !FMLEnvironment.isProduction();
        }

        @Override
        public Path getGameDirectory() {
            return FMLPaths.GAMEDIR.get();
        }

        @Override
        public Path getConfigDirectory() {
            return FMLPaths.CONFIGDIR.get();
        }

        @Override
        public void init() {
            for (Field field : NeoForgeMod.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(DeferredRegisterUndeferrer.class)) continue;
                field.setAccessible(true);
                try {
                    DeferredRegisterUndeferrer register = (DeferredRegisterUndeferrer)field.get(null);
                    register.yumi$registerNow();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class FabricRuntime
    implements CurrentRuntime {
        @Override
        public boolean isDevelopmentEnvironment() {
            return FabricLoader.getInstance().isDevelopmentEnvironment();
        }

        @Override
        public Path getGameDirectory() {
            return FabricLoader.getInstance().getGameDir();
        }

        @Override
        public Path getConfigDirectory() {
            return FabricLoader.getInstance().getConfigDir();
        }
    }
}

