/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl;

import com.mojang.logging.LogUtils;
import dev.yumi.commons.event.Event;
import dev.yumi.mc.core.api.CrashReportEvents;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.YumiEvents;
import dev.yumi.mc.core.api.YumiMods;
import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.api.entrypoint.ModInitializer;
import dev.yumi.mc.core.impl.CurrentRuntime;
import dev.yumi.mc.core.impl.EventSideTarget;
import dev.yumi.mc.core.impl.YumiModsImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_2960;
import net.minecraft.class_6396;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class YumiFoundationMod
implements ModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 SYSTEM_DETAILS_POPULATION_PHASE = class_2960.method_60655((String)"yumi", (String)"populate_system_details");

    @Override
    public void onInitialize(ModContainer mod) {
        CrashReportEvents.SYSTEM_DETAILS_POPULATE.addPhaseOrdering((Comparable)((class_2960)CrashReportEvents.SYSTEM_DETAILS_POPULATE.defaultPhaseId()), (Comparable)SYSTEM_DETAILS_POPULATION_PHASE);
        CrashReportEvents.SYSTEM_DETAILS_POPULATE.register((Comparable)SYSTEM_DETAILS_POPULATION_PHASE, details -> details.method_37122("Yumi MC Core", mod.getVersionString()));
    }

    public static void initialize() {
        LOGGER.info("Initializing mods (entrypoint {})...", (Object)"yumi:init");
        YumiModsImpl.INSTANCE.runtimes.forEach(CurrentRuntime::init);
        YumiEvents.EVENTS.getCreationEvent().register((manager, event) -> {
            for (EventSideTarget target : EventSideTarget.VALUES) {
                if (!target.listenerClass().isAssignableFrom(event.type())) continue;
                List<EntrypointContainer<?>> entrypoints = YumiMods.get().getEntrypoints(target.entrypointKey(), target.listenerClass());
                for (EntrypointContainer<?> entrypoint : entrypoints) {
                    if (!event.type().isAssignableFrom(entrypoint.getClass())) continue;
                    manager.listenAll(entrypoint, new Event[]{event});
                }
            }
        });
        YumiModsImpl.INSTANCE.invokeEntrypoints("yumi:init", ModInitializer.class, ModInitializer::onInitialize);
    }

    public static void populateSystemDetailsReport(class_6396 details) {
        if (YumiMods.get().getMod("fabric-crash-report-info-v1").isEmpty()) {
            details.method_37123("Mods", () -> {
                StringBuilder builder = new StringBuilder();
                YumiFoundationMod.populateMods(builder, 2, YumiMods.get().getMods().stream().filter(entry -> entry.getContainingMod().isEmpty()).toList(), new Stack<ModContainer>());
                return builder.toString();
            });
        }
    }

    private static void populateMods(StringBuilder builder, int depth, Collection<ModContainer> mods, Stack<ModContainer> parents) {
        for (ModContainer mod : mods.stream().sorted(Comparator.comparing(ModContainer::id)).toList()) {
            builder.append('\n');
            builder.append("\t".repeat(depth));
            builder.append(mod.id()).append(": ").append(mod.getName()).append(" v").append(mod.getVersionString());
            if (parents.contains(mod)) continue;
            parents.push(mod);
            Collection<ModContainer> contained = mod.getContainedMods();
            if (!contained.isEmpty()) {
                YumiFoundationMod.populateMods(builder, depth + 1, contained, parents);
            }
            parents.pop();
        }
    }
}

