/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl;

import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.YumiMods;
import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.impl.CurrentRuntime;
import dev.yumi.mc.core.impl.EnvironmentUtils;
import dev.yumi.mc.core.impl.entrypoint.EntrypointStorage;
import dev.yumi.mc.core.impl.entrypoint.JoinedEntrypointStorage;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import dev.yumi.mc.core.impl.mod.FabricModContainer;
import dev.yumi.mc.core.impl.mod.NeoModContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class YumiModsImpl
implements YumiMods {
    public static final YumiModsImpl INSTANCE = new YumiModsImpl();
    final List<CurrentRuntime> runtimes;
    private final CurrentRuntime runtime;
    private final Map<String, ExtendedModContainer> modsMap = new HashMap<String, ExtendedModContainer>();
    private final List<ExtendedModContainer> mods = new ArrayList<ExtendedModContainer>();
    private final EntrypointStorage entrypointStorage;

    public YumiModsImpl() {
        ArrayList<CurrentRuntime> runtimes = new ArrayList<CurrentRuntime>();
        if (EnvironmentUtils.FABRIC) {
            runtimes.add(new CurrentRuntime.FabricRuntime());
        }
        if (EnvironmentUtils.NEOFORGE) {
            runtimes.add(new CurrentRuntime.NeoForgeRuntime());
        }
        this.runtimes = List.copyOf(runtimes);
        this.runtime = this.runtimes.getFirst();
        List<Supplier<Consumer>> initializers = List.of(() -> NeoModContainer::init, () -> FabricModContainer::init);
        ArrayList<ExtendedModContainer> mods = new ArrayList<ExtendedModContainer>();
        ArrayList<LinkageError> errors = new ArrayList<LinkageError>();
        for (Supplier<Consumer> initializer : initializers) {
            try {
                initializer.get().accept(mods);
            }
            catch (LinkageError e) {
                errors.add(e);
            }
        }
        if (errors.size() == initializers.size()) {
            Error error = (Error)errors.stream().reduce((a, b) -> {
                a.addSuppressed((Throwable)b);
                return a;
            }).orElseThrow();
            throw new IllegalStateException("Failed to initialize ModManager: failed to find any mod loader.", error);
        }
        HashMap<String, ExtendedModContainer> directModsMap = new HashMap<String, ExtendedModContainer>();
        for (ExtendedModContainer mod : mods) {
            directModsMap.put(mod.id(), mod);
        }
        this.mods.addAll(directModsMap.values());
        this.modsMap.putAll(directModsMap);
        for (ExtendedModContainer mod : directModsMap.values()) {
            for (String provided : mod.getProvidedIds()) {
                this.modsMap.put(provided, mod);
            }
        }
        this.entrypointStorage = JoinedEntrypointStorage.init(mods);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return this.runtime.isDevelopmentEnvironment();
    }

    @Override
    public Path getGameDirectory() {
        return this.runtime.getGameDirectory();
    }

    @Override
    public Path getConfigDirectory() {
        return this.runtime.getConfigDirectory();
    }

    @Override
    public Optional<ModContainer> getMod(String id) {
        return Optional.ofNullable((ModContainer)this.modsMap.get(id));
    }

    @Override
    public boolean isModLoaded(String id) {
        return this.modsMap.containsKey(id);
    }

    @Override
    public Collection<ModContainer> getMods() {
        return Collections.unmodifiableList(this.mods);
    }

    @Override
    public <T> List<EntrypointContainer<T>> getEntrypoints(String key, Class<T> type) {
        return this.entrypointStorage.getEntrypoints(key, type);
    }
}

