/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.SimpleStylingNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public final class HoverNode<T, H>
extends SimpleStylingNode {
    private final Action<T, H> action;
    private final T value;

    public HoverNode(TextNode[] children, Action<T, H> action, T value) {
        super(children);
        this.action = action;
        this.value = value;
    }

    public Action<T, H> action() {
        return this.action;
    }

    public T value() {
        return this.value;
    }

    @Override
    protected class_2583 style(ParserContext context) {
        return class_2583.field_24360.method_10949(HoverNode.toVanilla(this.action, this.value, context));
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new HoverNode<T, H>(children, this.action, this.value);
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children, NodeParser parser) {
        if (this.value == null) {
            return this.copyWith(children);
        }
        if (this.action == Action.TEXT_NODE) {
            return new HoverNode<TextNode, class_2568.class_10613>(children, Action.TEXT_NODE, parser.parseNode((TextNode)this.value));
        }
        if (this.action == Action.ENTITY_NODE && ((EntityNodeContent)this.value).name != null) {
            EntityNodeContent val = (EntityNodeContent)this.value;
            return new HoverNode<EntityNodeContent, class_2568.class_10611>(children, Action.ENTITY_NODE, new EntityNodeContent(val.entityType, val.uuid, parser.parseNode(val.name)));
        }
        if (this.action == Action.LAZY_ITEM_STACK && ((LazyItemStackNodeContent)this.value).identifier != null) {
            LazyItemStackNodeContent val = (LazyItemStackNodeContent)this.value;
            return new HoverNode(children, Action.LAZY_ITEM_STACK, new LazyItemStackNodeContent(val.identifier, val.count, val.ops, val.componentMap));
        }
        if (this.action == Action.VANILLA_ITEM_STACK && ((class_2568.class_10612)this.value).comp_3509() != null) {
            class_1799 val = ((class_2568.class_10612)this.value).comp_3509();
            return new HoverNode<class_2568.class_10612, class_2568.class_10612>(children, Action.VANILLA_ITEM_STACK, new class_2568.class_10612(val));
        }
        if (this.action == Action.VANILLA_ENTITY && ((class_2568.class_10611)this.value).comp_3508() != null) {
            class_2568.class_5248 val = ((class_2568.class_10611)this.value).comp_3508();
            return new HoverNode<class_2568.class_10611, class_2568.class_10611>(children, Action.VANILLA_ENTITY, new class_2568.class_10611(val));
        }
        return this.copyWith(children);
    }

    @Nullable
    public static <T> class_2568 toVanilla(Action<T, ?> action, T value, ParserContext context) {
        if (action == Action.TEXT_NODE) {
            return new class_2568.class_10613(((TextNode)value).toText(context.copyWithoutNodeContext(), true));
        }
        if (action == Action.ENTITY_NODE) {
            return new class_2568.class_10611(((EntityNodeContent)value).toVanilla(context.copyWithoutNodeContext()));
        }
        if (action == Action.LAZY_ITEM_STACK) {
            class_7225.class_7874 wrapper;
            if (context.contains(ParserContext.Key.WRAPPER_LOOKUP)) {
                wrapper = context.getOrThrow(ParserContext.Key.WRAPPER_LOOKUP);
            } else if (context.contains(PlaceholderContext.KEY)) {
                wrapper = context.getOrThrow(PlaceholderContext.KEY).server().method_30611();
            } else {
                return null;
            }
            return new class_2568.class_10612(((LazyItemStackNodeContent)value).toVanilla(wrapper));
        }
        if (action == Action.VANILLA_ITEM_STACK) {
            return new class_2568.class_10612(((class_2568.class_10612)value).comp_3509());
        }
        if (action == Action.VANILLA_ENTITY) {
            return new class_2568.class_10611(((class_2568.class_10611)value).comp_3508());
        }
        return null;
    }

    @Override
    public String toString() {
        return "HoverNode{value=" + String.valueOf(this.value) + ", children=" + Arrays.toString(this.children) + "}";
    }

    @Override
    public boolean isDynamicNoChildren() {
        return this.action == Action.TEXT_NODE && ((TextNode)this.value).isDynamic() || this.action == Action.ENTITY_NODE && ((EntityNodeContent)this.value).name.isDynamic() || this.action == Action.LAZY_ITEM_STACK;
    }

    public record Action<T, H>(class_2568.class_5247 vanillaType) {
        public static final Action<TextNode, class_2568.class_10613> TEXT_NODE = new Action(class_2568.class_5247.field_24342);
        public static final Action<LazyItemStackNodeContent<?>, class_2568.class_10612> LAZY_ITEM_STACK = new Action(class_2568.class_5247.field_24343);
        public static final Action<EntityNodeContent, class_2568.class_10611> ENTITY_NODE = new Action(class_2568.class_5247.field_24344);
        public static final Action<class_2568.class_10612, class_2568.class_10612> VANILLA_ITEM_STACK = new Action(class_2568.class_5247.field_24343);
        public static final Action<class_2568.class_10611, class_2568.class_10611> VANILLA_ENTITY = new Action(class_2568.class_5247.field_24344);

        @Override
        public String toString() {
            return "HoverNode$Action{vanillaType={" + this.vanillaType.name() + "}}";
        }
    }

    public record EntityNodeContent(class_1299<?> entityType, UUID uuid, @Nullable TextNode name) {
        public class_2568.class_5248 toVanilla(ParserContext context) {
            return new class_2568.class_5248(this.entityType, this.uuid, Optional.ofNullable(this.name != null ? this.name.toText(context, true) : null));
        }

        @Override
        public String toString() {
            return "HoverNode$EntityNodeContent{id=" + class_1299.method_5890(this.entityType).toString() + ",uuid=[" + this.uuid.toString() + "],name={" + (this.name != null ? this.name.toText().method_54160() : "<NULL>") + "}}";
        }
    }

    public record LazyItemStackNodeContent<T>(class_2960 identifier, int count, DynamicOps<T> ops, T componentMap) {
        public class_1799 toVanilla(class_7225.class_7874 lookup) {
            class_1799 stack = new class_1799((class_6880)lookup.method_46762(class_7924.field_41197).method_46747(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)this.identifier)));
            stack.method_7939(this.count);
            if (this.componentMap != null) {
                stack.method_59692((class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)lookup.method_57093(this.ops), this.componentMap).getOrThrow()).getFirst());
            }
            return stack;
        }

        @Override
        public String toString() {
            return "HoverNode$LazyItemStackNodeContent{id=" + this.identifier.toString() + ",count=" + this.count + ",ops=[" + this.ops.toString() + "],components={" + this.componentMap.toString() + "}}";
        }
    }
}

