/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_161;
import net.minecraft.class_2405;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import net.minecraft.class_8779;

public abstract class FabricAdvancementProvider
implements class_2405 {
    protected final FabricDataOutput output;
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registryLookup;

    protected FabricAdvancementProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.output = output;
        this.pathResolver = output.method_60917(class_7924.field_52177);
        this.registryLookup = registryLookup;
    }

    public abstract void generateAdvancement(class_7225.class_7874 var1, Consumer<class_8779> var2);

    protected Consumer<class_8779> withConditions(Consumer<class_8779> exporter, ResourceCondition ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return advancement -> {
            FabricDataGenHelper.addConditions(advancement, conditions);
            exporter.accept((class_8779)advancement);
        };
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registryLookup.thenCompose(lookup -> {
            HashSet identifiers = Sets.newHashSet();
            HashSet advancements = Sets.newHashSet();
            this.generateAdvancement((class_7225.class_7874)lookup, advancements::add);
            class_6903 ops = lookup.method_57093((DynamicOps)JsonOps.INSTANCE);
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (class_8779 advancement : advancements) {
                if (!identifiers.add(advancement.comp_1919())) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(advancement.comp_1919()));
                }
                JsonObject advancementJson = ((JsonElement)class_161.field_47179.encodeStart((DynamicOps)ops, (Object)advancement.comp_1920()).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                FabricDataGenHelper.addConditions(advancementJson, FabricDataGenHelper.consumeConditions(advancement));
                futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)this.getOutputPath(advancement)));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    private Path getOutputPath(class_8779 advancement) {
        return this.pathResolver.method_44107(advancement.comp_1919());
    }

    public String method_10321() {
        return "Advancements";
    }
}

