/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7877;
import net.minecraft.class_7887;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricDataGenHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricDataGenHelper.class);
    public static final boolean ENABLED = System.getProperty("fabric-api.datagen") != null;
    private static final String OUTPUT_DIR = System.getProperty("fabric-api.datagen.output-dir");
    private static final boolean STRICT_VALIDATION = System.getProperty("fabric-api.datagen.strict-validation") != null;
    private static final @Nullable String MOD_ID_FILTER = System.getProperty("fabric-api.datagen.modid");
    private static final String ENTRYPOINT_KEY = "fabric-datagen";
    private static final Map<Object, ResourceCondition[]> CONDITIONS_MAP = new IdentityHashMap<Object, ResourceCondition[]>();

    private FabricDataGenHelper() {
    }

    public static void run() {
        try {
            FabricDataGenHelper.runInternal();
        }
        catch (Throwable t) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to run data generation", t);
            System.exit(-1);
        }
    }

    private static void runInternal() {
        Path outputDir = Paths.get(Objects.requireNonNull(OUTPUT_DIR, "No output dir provided with the 'fabric-api.datagen.output-dir' property"), new String[0]);
        List dataGeneratorInitializers = FabricLoader.getInstance().getEntrypointContainers(ENTRYPOINT_KEY, DataGeneratorEntrypoint.class);
        if (dataGeneratorInitializers.isEmpty()) {
            LOGGER.warn("No data generator entrypoints are defined. Implement {} and add your class to the '{}' entrypoint key in your fabric.mod.json.", (Object)DataGeneratorEntrypoint.class.getName(), (Object)ENTRYPOINT_KEY);
        }
        List<DataGeneratorEntrypoint> entrypoints = dataGeneratorInitializers.stream().map(EntrypointContainer::getEntrypoint).toList();
        CompletableFuture<class_7225.class_7874> registriesFuture = CompletableFuture.supplyAsync(() -> FabricDataGenHelper.createRegistryWrapper(entrypoints), (Executor)class_156.method_18349());
        Object2IntOpenHashMap jsonKeySortOrders = (Object2IntOpenHashMap)class_2405.field_39212;
        Object2IntOpenHashMap defaultJsonKeySortOrders = new Object2IntOpenHashMap((Object2IntMap)jsonKeySortOrders);
        for (EntrypointContainer entrypointContainer : dataGeneratorInitializers) {
            String id = entrypointContainer.getProvider().getMetadata().getId();
            if (MOD_ID_FILTER != null && !id.equals(MOD_ID_FILTER)) continue;
            LOGGER.info("Running data generator for {}", (Object)id);
            try {
                DataGeneratorEntrypoint entrypoint = (DataGeneratorEntrypoint)entrypointContainer.getEntrypoint();
                String effectiveModId = entrypoint.getEffectiveModId();
                ModContainer modContainer = entrypointContainer.getProvider();
                HashSet keys = new HashSet();
                entrypoint.addJsonKeySortOrders((key, value) -> {
                    Objects.requireNonNull(key, "Tried to register a priority for a null key");
                    jsonKeySortOrders.put((Object)key, value);
                    keys.add(key);
                });
                if (effectiveModId != null) {
                    modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(effectiveModId).orElseThrow(() -> new RuntimeException("Failed to find effective mod container for mod id (%s)".formatted(effectiveModId)));
                }
                FabricDataGenerator dataGenerator = new FabricDataGenerator(outputDir, modContainer, STRICT_VALIDATION, registriesFuture);
                entrypoint.onInitializeDataGenerator(dataGenerator);
                dataGenerator.method_10315();
                jsonKeySortOrders.keySet().removeAll(keys);
                jsonKeySortOrders.putAll((Map)defaultJsonKeySortOrders);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to run data generator from mod (%s)".formatted(id), t);
            }
        }
    }

    private static class_7225.class_7874 createRegistryWrapper(List<DataGeneratorEntrypoint> dataGeneratorInitializers) {
        ArrayList<class_7877> builders = new ArrayList<class_7877>();
        builders.add(class_7887.field_40953);
        for (DataGeneratorEntrypoint dataGeneratorEntrypoint : dataGeneratorInitializers) {
            class_7877 class_78772 = new class_7877();
            dataGeneratorEntrypoint.buildRegistry(class_78772);
            builders.add(class_78772);
        }
        class BuilderData {
            final class_5321 key;
            List<class_7877.class_7882<?>> bootstrapFunctions;
            Lifecycle lifecycle;

            BuilderData(class_5321 key) {
                this.key = key;
                this.bootstrapFunctions = new ArrayList();
                this.lifecycle = Lifecycle.stable();
            }

            void with(class_7877.class_7884<?> registryInfo) {
                this.bootstrapFunctions.add(registryInfo.comp_1146());
                this.lifecycle = registryInfo.comp_1145().add(this.lifecycle);
            }

            void apply(class_7877 builder) {
                builder.method_46776(this.key, this.lifecycle, this::bootstrap);
            }

            void bootstrap(class_7891 registerable) {
                for (class_7877.class_7882<?> function : this.bootstrapFunctions) {
                    function.run(registerable);
                }
            }
        }
        HashMap<class_5321, BuilderData> builderDataMap = new HashMap<class_5321, BuilderData>();
        for (class_7655.class_7657 class_76572 : DynamicRegistries.getDynamicRegistries()) {
            builderDataMap.computeIfAbsent(class_76572.comp_985(), x$0 -> new BuilderData((class_5321)x$0));
        }
        for (class_7877 class_78773 : builders) {
            for (class_7877.class_7884 info : class_78773.field_40941) {
                builderDataMap.computeIfAbsent(info.comp_1144(), x$0 -> new BuilderData((class_5321)x$0)).with(info);
            }
        }
        class_7877 class_78774 = new class_7877();
        for (BuilderData value : builderDataMap.values()) {
            value.apply(class_78774);
        }
        class_7225.class_7874 class_78742 = class_78774.method_46780((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167));
        class_7887.method_46823((class_7225.class_7874)class_78742);
        return class_78742;
    }

    public static void addConditions(Object object, ResourceCondition[] conditions) {
        CONDITIONS_MAP.merge(object, conditions, ArrayUtils::addAll);
    }

    public static @Nullable ResourceCondition[] consumeConditions(Object object) {
        return CONDITIONS_MAP.remove(object);
    }

    public static void addConditions(JsonObject baseObject, ResourceCondition ... conditions) {
        if (baseObject.has("fabric:load_conditions")) {
            throw new IllegalArgumentException("Object already has a condition entry: " + String.valueOf(baseObject));
        }
        if (conditions == null || conditions.length == 0) {
            return;
        }
        baseObject.add("fabric:load_conditions", (JsonElement)ResourceCondition.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, Arrays.asList(conditions)).getOrThrow());
    }
}

