/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.scoreboardoverhaul.common.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\nJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\fJ\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R&\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/jfenn/scoreboardoverhaul/common/utils/FrequencySampler;", "", "", "bufferSize", "<init>", "(I)V", "", "id", "", "addHit", "(Ljava/lang/String;)V", "tick", "()V", "clearFrequency", "getFrequency", "(Ljava/lang/String;)I", "clear", "", "threshold", "", "isAboveThreshold", "(Ljava/lang/String;F)Z", "I", "", "Ljava/util/LinkedList;", "frequencyMap", "Ljava/util/Map;", "", "hitSet", "Ljava/util/Set;", "scoreboardoverhaul"})
@SourceDebugExtension(value={"SMAP\nFrequencySampler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrequencySampler.kt\nme/jfenn/scoreboardoverhaul/common/utils/FrequencySampler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n384#2,7:71\n1788#3,4:78\n*S KotlinDebug\n*F\n+ 1 FrequencySampler.kt\nme/jfenn/scoreboardoverhaul/common/utils/FrequencySampler\n*L\n22#1:71,7\n46#1:78,4\n*E\n"})
public final class FrequencySampler {
    private final int bufferSize;
    @NotNull
    private final Map<String, LinkedList<Boolean>> frequencyMap;
    @NotNull
    private final Set<String> hitSet;

    public FrequencySampler(int bufferSize) {
        this.bufferSize = bufferSize;
        this.frequencyMap = new LinkedHashMap();
        this.hitSet = new LinkedHashSet();
    }

    public final void addHit(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.hitSet.add(id);
    }

    public final void tick() {
        for (String id : CollectionsKt.toSet((Iterable)SetsKt.plus(this.frequencyMap.keySet(), (Iterable)this.hitSet))) {
            LinkedList<Boolean> linkedList;
            Map<String, LinkedList<Boolean>> $this$getOrPut$iv = this.frequencyMap;
            boolean $i$f$getOrPut = false;
            LinkedList<Boolean> value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl = false;
                LinkedList answer$iv = new LinkedList();
                $this$getOrPut$iv.put(id, answer$iv);
                linkedList = answer$iv;
            } else {
                linkedList = value$iv;
            }
            LinkedList<Boolean> frequencyList = linkedList;
            while (frequencyList.size() < this.bufferSize) {
                frequencyList.add(false);
            }
            frequencyList.pop();
            boolean wasHit = this.hitSet.contains(id);
            frequencyList.add(wasHit);
        }
        this.hitSet.clear();
    }

    public final void clearFrequency(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.frequencyMap.remove(id);
        this.hitSet.remove(id);
    }

    public final int getFrequency(@NotNull String id) {
        int frequency;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        LinkedList<Boolean> linkedList = this.frequencyMap.get(id);
        if (linkedList == null) {
            return 0;
        }
        LinkedList<Boolean> frequencyList = linkedList;
        Iterable $this$count$iv = frequencyList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = frequency = count$iv;
        }
        if (frequency == 0) {
            this.frequencyMap.remove(id);
        }
        return frequency;
    }

    public final void clear() {
        this.frequencyMap.clear();
        this.hitSet.clear();
    }

    public final boolean isAboveThreshold(@NotNull String id, float threshold) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        int frequency = this.getFrequency(id);
        return (float)frequency / (float)this.bufferSize > threshold;
    }
}

