/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.canceller;

import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.reflection.TargetClassContextExtension;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;

public final class ExtensionCancelApplication
implements IExtension {
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-canceller");

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        TargetClassContextExtension.tryAs(context).ifPresent(contextExtension -> {
            SortedSet<IMixinInfo> mixins = contextExtension.getMixins();
            mixins.removeIf(mixin -> {
                List<String> targetClassNames = mixin.getTargetClasses().stream().map(s -> s.replaceAll("/", ".")).collect(Collectors.toList());
                boolean shouldCancel = MixinCancellerRegistrar.shouldCancel(targetClassNames, mixin.getClassName(), canceller -> LOGGER.debug("Canceller {} cancelled mixin {}", new Object[]{canceller, mixin.getClassName()}));
                if (shouldCancel) {
                    LOGGER.warn("Cancelled mixin {}. Check debug logs for more information.", new Object[]{mixin.getClassName()});
                }
                return shouldCancel;
            });
        });
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

