/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.block;

import java.util.ArrayList;
import java.util.Objects;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.tracking.block.BlockChangeTracker;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.util.deduplication.LithiumInterner;
import net.caffeinemc.mods.lithium.common.util.tuples.WorldSectionBox;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public class SectionedBlockChangeTracker
implements BlockChangeTracker {
    public final WorldSectionBox trackedWorldSections;
    private long maxChangeTime;
    private int timesRegistered;
    boolean isListeningToAll = false;
    private ArrayList<class_4076> sectionsNotListeningTo = null;
    private ArrayList<BlockListeningSection> sectionsUnsubscribed = null;

    public SectionedBlockChangeTracker(WorldSectionBox trackedWorldSections) {
        this.trackedWorldSections = trackedWorldSections;
        this.maxChangeTime = 0L;
    }

    public boolean matchesMovedBox(class_238 box) {
        return this.trackedWorldSections.matchesRelevantBlocksBox(box);
    }

    public static SectionedBlockChangeTracker registerAt(class_1937 world, class_238 entityBoundingBox) {
        WorldSectionBox worldSectionBox = WorldSectionBox.relevantExpandedBlocksBox(world, entityBoundingBox);
        SectionedBlockChangeTracker tracker = new SectionedBlockChangeTracker(worldSectionBox);
        LithiumInterner<SectionedBlockChangeTracker> blockChangeTrackers = ((LithiumData)world).lithium$getData().blockChangeTrackers();
        tracker = blockChangeTrackers.getCanonical(tracker);
        tracker.register();
        return tracker;
    }

    public long getWorldTime() {
        return this.trackedWorldSections.world().method_75260();
    }

    public void register() {
        if (this.timesRegistered == 0) {
            WorldSectionBox trackedSections = this.trackedWorldSections;
            for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
                for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                    class_1937 world = trackedSections.world();
                    class_2791 chunk = world.method_8402(x, z, class_2806.field_12803, false);
                    class_2826[] sectionArray = chunk == null ? null : chunk.method_12006();
                    for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                        if (Pos.SectionYCoord.getMinYSection((class_5539)world) > y || Pos.SectionYCoord.getMaxYSectionExclusive((class_5539)world) <= y) continue;
                        class_4076 sectionPos = class_4076.method_18676((int)x, (int)y, (int)z);
                        if (sectionArray == null) {
                            if (this.sectionsNotListeningTo == null) {
                                this.sectionsNotListeningTo = new ArrayList();
                            }
                            this.sectionsNotListeningTo.add(sectionPos);
                            continue;
                        }
                        class_2826 section = sectionArray[Pos.SectionYIndex.fromSectionCoord((class_5539)world, y)];
                        BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                        blockListeningSection.lithium$addToCallback(this, class_4076.method_18685((int)x, (int)y, (int)z), world);
                    }
                }
            }
            this.isListeningToAll = !(this.sectionsNotListeningTo != null && !this.sectionsNotListeningTo.isEmpty() || this.sectionsUnsubscribed != null && !this.sectionsUnsubscribed.isEmpty());
            this.setChanged(this.getWorldTime());
        }
        ++this.timesRegistered;
    }

    public void unregister() {
        if (--this.timesRegistered > 0) {
            return;
        }
        WorldSectionBox trackedSections = this.trackedWorldSections;
        class_1937 world = trackedSections.world();
        for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
            for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                class_2791 chunk = world.method_8402(x, z, class_2806.field_12803, false);
                class_2826[] sectionArray = chunk == null ? null : chunk.method_12006();
                for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                    if (sectionArray == null || Pos.SectionYCoord.getMinYSection((class_5539)world) > y || Pos.SectionYCoord.getMaxYSectionExclusive((class_5539)world) <= y) continue;
                    class_2826 section = sectionArray[Pos.SectionYIndex.fromSectionCoord((class_5539)world, y)];
                    BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                    blockListeningSection.lithium$removeFromCallback(this);
                }
            }
        }
        this.sectionsNotListeningTo = null;
        LithiumInterner<SectionedBlockChangeTracker> blockChangeTrackers = ((LithiumData)world).lithium$getData().blockChangeTrackers();
        blockChangeTrackers.deleteCanonical(this);
    }

    public void listenToAllSections() {
        boolean changed = false;
        ArrayList<class_4076> notListeningTo = this.sectionsNotListeningTo;
        if (notListeningTo != null) {
            for (int i = notListeningTo.size() - 1; i >= 0; --i) {
                changed = true;
                class_4076 chunkSectionPos = notListeningTo.get(i);
                class_1937 world = this.trackedWorldSections.world();
                class_2791 chunk = world.method_8402(chunkSectionPos.method_10263(), chunkSectionPos.method_10260(), class_2806.field_12803, false);
                if (chunk == null) {
                    return;
                }
                notListeningTo.remove(i);
                class_2826 section = chunk.method_12006()[Pos.SectionYIndex.fromSectionCoord((class_5539)world, chunkSectionPos.method_10264())];
                BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                blockListeningSection.lithium$addToCallback(this, chunkSectionPos.method_18694(), world);
            }
        }
        if (this.sectionsUnsubscribed != null) {
            ArrayList<BlockListeningSection> unsubscribed = this.sectionsUnsubscribed;
            for (int i = unsubscribed.size() - 1; i >= 0; --i) {
                changed = true;
                BlockListeningSection blockListeningSection = unsubscribed.remove(i);
                blockListeningSection.lithium$addToCallback(this, Long.MIN_VALUE, null);
            }
        }
        this.isListeningToAll = true;
        if (changed) {
            this.setChanged(this.getWorldTime());
        }
    }

    @Override
    public boolean setChanged(BlockListeningSection section, int localX, int localY, int localZ, class_2680 oldState, class_2680 newState) {
        if (this.sectionsUnsubscribed == null) {
            this.sectionsUnsubscribed = new ArrayList();
        }
        this.sectionsUnsubscribed.add(section);
        this.setChanged(this.getWorldTime());
        this.isListeningToAll = false;
        return false;
    }

    public void setChanged(long atTime) {
        if (atTime > this.maxChangeTime) {
            this.maxChangeTime = atTime;
        }
    }

    public boolean isUnchangedSince(long lastCheckedTime) {
        if (lastCheckedTime <= this.maxChangeTime) {
            return false;
        }
        if (!this.isListeningToAll) {
            this.listenToAllSections();
            return this.isListeningToAll && lastCheckedTime > this.maxChangeTime;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SectionedBlockChangeTracker that = (SectionedBlockChangeTracker)obj;
        return Objects.equals(this.trackedWorldSections, that.trackedWorldSections);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.trackedWorldSections.hashCode();
    }

    @Override
    public void onChunkSectionInvalidated(class_4076 sectionPos) {
        if (this.sectionsNotListeningTo == null) {
            this.sectionsNotListeningTo = new ArrayList();
        }
        this.sectionsNotListeningTo.add(sectionPos);
        this.setChanged(this.getWorldTime());
        this.isListeningToAll = false;
    }
}

