/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.fapi;

import com.ishland.c2me.base.mixin.access.fapi.IArrayBackedEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleEventInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleEventInvoker.class);
    private static boolean cachedNeedsInvokeChunkLevelTypeChange = false;

    public static void invokeChunkLoaded(class_3218 world, class_2818 chunk, boolean newChunk) {
        try {
            ((ServerChunkEvents.Load)ServerChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad(world, chunk);
            if (newChunk) {
                ((ServerChunkEvents.Generate)ServerChunkEvents.CHUNK_GENERATE.invoker()).onChunkGenerate(world, chunk);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke chunk load event (world={}, pos={}, newChunk={})", new Object[]{world, chunk.method_12004(), newChunk, t});
        }
    }

    public static void invokeChunkUnload(class_3218 world, class_2818 chunk) {
        try {
            ((ServerChunkEvents.Unload)ServerChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(world, chunk);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke chunk unload event (world={}, pos={})", new Object[]{world, chunk.method_12004(), t});
        }
    }

    public static boolean needsInvokeChunkLevelTypeChange() {
        if (cachedNeedsInvokeChunkLevelTypeChange) {
            return true;
        }
        try {
            Event event = ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE;
            if (event instanceof IArrayBackedEvent) {
                IArrayBackedEvent accessor0 = (IArrayBackedEvent)event;
                IArrayBackedEvent accessor = accessor0;
                if (((ServerChunkEvents.LevelTypeChange[])accessor.c2me$getHandlers()).length > 0) {
                    cachedNeedsInvokeChunkLevelTypeChange = true;
                    return true;
                }
            } else {
                LOGGER.warn("Unexpected Event implementation of ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE: {}", (Object)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.getClass().getName());
                cachedNeedsInvokeChunkLevelTypeChange = true;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to check if chunk level type change event is needed", t);
            cachedNeedsInvokeChunkLevelTypeChange = true;
            return true;
        }
    }

    public static void invokeChunkLevelTypeChange(class_3218 world, class_2818 chunk, class_3194 oldLevelType, class_3194 newLevelType) {
        try {
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange(world, chunk, oldLevelType, newLevelType);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to invoke chunk level type change event (world={}, pos={}, oldLevelType={}, newLevelType={})", new Object[]{world, chunk.method_12004(), oldLevelType, newLevelType, t});
        }
    }
}

