/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.quirks;

import com.ishland.c2me.base.mixin.access.IFlowableFluid;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;

public class FlowableFluidUtils {
    public static boolean needsPostProcessing(class_4538 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        if (!fluidState.method_15771()) {
            return true;
        }
        return FlowableFluidUtils.canFlowNormally(world, pos, blockState, fluidState);
    }

    private static boolean canFlowNormally(class_4538 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        if (fluidState.method_15769()) {
            return false;
        }
        class_2338 belowPos = pos.method_10074();
        class_2680 belowBlockState = world.method_8320(belowPos);
        class_3610 belowFluidState = belowBlockState.method_26227();
        if (((IFlowableFluid)fluidState.method_15772()).invokeCanFlowThrough((class_1922)world, pos, blockState, class_2350.field_11033, belowPos, belowBlockState, belowFluidState)) {
            class_3610 fluidState3 = FlowableFluidUtils.getUpdatedState((class_3609)fluidState.method_15772(), world, belowPos, belowBlockState);
            if (fluidState3 == null) {
                return true;
            }
            class_3611 fluid = fluidState3.method_15772();
            if (belowFluidState.method_15764((class_1922)world, belowPos, fluid, class_2350.field_11033) && IFlowableFluid.invokeCanFillWithFluid((class_1922)world, (class_2338)belowPos, (class_2680)belowBlockState, (class_3611)fluid)) {
                return true;
            }
        }
        return (fluidState.method_15771() || !((IFlowableFluid)fluidState.method_15772()).invokeCanFlowDownTo((class_1922)world, pos, blockState, belowPos, belowBlockState)) && FlowableFluidUtils.canSpreadToSidesNormally(world, pos, blockState, fluidState);
    }

    private static boolean canSpreadToSidesNormally(class_4538 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        int nextFluidLevel = fluidState.method_15761() - ((IFlowableFluid)fluidState.method_15772()).invokeGetLevelDecreasePerBlock(world);
        if (((Boolean)fluidState.method_11654((class_2769)class_3609.field_15902)).booleanValue()) {
            nextFluidLevel = 7;
        }
        if (nextFluidLevel > 0) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 offsetPos = pos.method_10093(direction);
                class_2680 offsetBlockState = world.method_8320(offsetPos);
                class_3610 offsetFluidState = offsetBlockState.method_26227();
                if (!((IFlowableFluid)fluidState.method_15772()).invokeCanFlowThrough((class_1922)world, pos, blockState, direction, offsetPos, offsetBlockState, offsetFluidState)) continue;
                class_3610 fluidState2 = FlowableFluidUtils.getUpdatedState((class_3609)fluidState.method_15772(), world, offsetPos, offsetBlockState);
                if (fluidState2 == null) {
                    return true;
                }
                if (!IFlowableFluid.invokeCanFillWithFluid((class_1922)world, (class_2338)offsetPos, (class_2680)offsetBlockState, (class_3611)fluidState2.method_15772())) continue;
                return true;
            }
        }
        return false;
    }

    private static class_3610 getUpdatedState(class_3609 receiver, class_4538 world, class_2338 pos, class_2680 state) {
        int i = 0;
        int j = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338.class_2339 blockPos = mutable.method_25505((class_2382)pos, direction);
            class_2680 blockState = world.method_8320((class_2338)blockPos);
            class_3610 fluidState = blockState.method_26227();
            if (!fluidState.method_15772().method_15780((class_3611)receiver) || !IFlowableFluid.invokeReceivesFlow((class_2350)direction, (class_1922)world, (class_2338)pos, (class_2680)state, (class_2338)blockPos, (class_2680)blockState)) continue;
            if (fluidState.method_15771()) {
                ++j;
            }
            i = Math.max(i, fluidState.method_15761());
        }
        if (j >= 2) {
            return null;
        }
        class_2338.class_2339 blockPos2 = mutable.method_25505((class_2382)pos, class_2350.field_11036);
        class_2680 blockState3 = world.method_8320((class_2338)blockPos2);
        class_3610 fluidState3 = blockState3.method_26227();
        if (!fluidState3.method_15769() && fluidState3.method_15772().method_15780((class_3611)receiver) && IFlowableFluid.invokeReceivesFlow((class_2350)class_2350.field_11036, (class_1922)world, (class_2338)pos, (class_2680)state, (class_2338)blockPos2, (class_2680)blockState3)) {
            return receiver.method_15728(8, true);
        }
        int k = i - ((IFlowableFluid)receiver).invokeGetLevelDecreasePerBlock(world);
        return k <= 0 ? class_3612.field_15906.method_15785() : receiver.method_15728(k, false);
    }

    private static class SpreadCache {
        private final class_3609 flowableFluid;
        private final class_1922 world;
        private final class_2338 startPos;
        private final Short2ObjectMap<class_2680> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap flowDownCache = new Short2BooleanOpenHashMap();

        SpreadCache(class_3609 flowableFluid, class_1922 world, class_2338 startPos) {
            this.flowableFluid = flowableFluid;
            this.world = world;
            this.startPos = startPos;
        }

        public class_2680 getBlockState(class_2338 pos) {
            return this.getBlockState(pos, this.pack(pos));
        }

        private class_2680 getBlockState(class_2338 pos, short packed) {
            return (class_2680)this.stateCache.computeIfAbsent(packed, packedPos -> this.world.method_8320(pos));
        }

        public boolean canFlowDownTo(class_2338 pos) {
            return this.flowDownCache.computeIfAbsent(this.pack(pos), packed -> {
                class_2680 blockState = this.getBlockState(pos, packed);
                class_2338 blockPos2 = pos.method_10074();
                class_2680 blockState2 = this.world.method_8320(blockPos2);
                return ((IFlowableFluid)this.flowableFluid).invokeCanFlowDownTo(this.world, pos, blockState, blockPos2, blockState2);
            });
        }

        private short pack(class_2338 pos) {
            int i = pos.method_10263() - this.startPos.method_10263();
            int j = pos.method_10260() - this.startPos.method_10260();
            return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
        }
    }
}

