/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common.statuses;

import com.ishland.c2me.base.common.threadstate.RunningWork;
import com.ishland.c2me.base.common.threadstate.ThreadInstrumentation;
import com.ishland.c2me.base.common.threadstate.ThreadState;
import com.ishland.c2me.base.common.util.RxJavaUtils;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.base.mixin.access.IVersionedChunkStorage;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkLoadingContext;
import com.ishland.c2me.rewrites.chunksystem.common.ChunkState;
import com.ishland.c2me.rewrites.chunksystem.common.async_chunkio.ChunkIoMainThreadTaskUtils;
import com.ishland.c2me.rewrites.chunksystem.common.statuses.ReadFromDisk;
import com.ishland.c2me.rewrites.chunksystem.common.threadstate.ChunkTaskWork;
import com.ishland.flowsched.scheduler.Cancellable;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.KeyStatusPair;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2839;
import net.minecraft.class_2852;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFromDiskAsync
extends ReadFromDisk {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReadFromDiskAsync");

    public ReadFromDiskAsync(int ordinal) {
        super(ordinal);
    }

    @Override
    public Completable upgradeToThis(ChunkLoadingContext context, Cancellable cancellable) {
        Single single = this.invokeAsyncLoad(context).retryWhen(RxJavaUtils.retryWithExponentialBackoff((int)3, (long)200L, (Throwable[])new Throwable[0])).onErrorResumeNext(throwable -> {
            LOGGER.error("Failed to load chunk {} fully asynchronously, falling back to normal loading", context.holder().getKey(), throwable);
            return this.invokeVanillaLoad(context).retryWhen(RxJavaUtils.retryWithExponentialBackoff((int)3, (long)200L, (Throwable[])new Throwable[]{new RuntimeException("Failed to load chunk fully asynchronously, falling back to normal loading", (Throwable)throwable)}));
        });
        return this.finalizeLoading(context, (Single<class_2839>)single);
    }

    @NonNull
    protected Single<class_2839> invokeAsyncLoad(ChunkLoadingContext context) {
        return this.invokeInitialChunkRead(context).map(chunkSerializer -> {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                ReferenceArrayList mainThreadQueue = new ReferenceArrayList();
                if (chunkSerializer.isPresent()) {
                    ChunkIoMainThreadTaskUtils.push((ReferenceArrayList<Runnable>)mainThreadQueue);
                    try {
                        Pair pair = Pair.of((Object)((class_2852)chunkSerializer.get()).method_12395(((IThreadedAnvilChunkStorage)context.tacs()).getWorld(), ((IThreadedAnvilChunkStorage)context.tacs()).getPointOfInterestStorage(), ((IVersionedChunkStorage)context.tacs()).invokeGetStorageKey(), (class_1923)context.holder().getKey()), (Object)mainThreadQueue);
                        return pair;
                    }
                    finally {
                        ChunkIoMainThreadTaskUtils.pop((ReferenceArrayList<Runnable>)mainThreadQueue);
                    }
                }
                Pair pair = Pair.of((Object)this.createEmptyProtoChunk(context), (Object)mainThreadQueue);
                return pair;
            }
        }).flatMap(pair -> this.postChunkLoading(context, (class_2839)pair.first()).toSingleDefault(pair)).observeOn(Schedulers.from((Executor)((IThreadedAnvilChunkStorage)context.tacs()).getMainThreadExecutor())).map(pair -> {
            try (ThreadState.WorkClosable ignored = ThreadInstrumentation.getCurrent().begin((RunningWork)new ChunkTaskWork(context, this, true));){
                ChunkIoMainThreadTaskUtils.drainQueue((ReferenceArrayList<Runnable>)((ReferenceArrayList)pair.second()));
            }
            return (class_2839)pair.first();
        });
    }

    @Override
    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToRemove(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        return EMPTY_DEPENDENCIES;
    }

    @Override
    public KeyStatusPair<class_1923, ChunkState, ChunkLoadingContext>[] getDependenciesToAdd(ItemHolder<class_1923, ChunkState, ChunkLoadingContext, ?> holder) {
        return EMPTY_DEPENDENCIES;
    }
}

