/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunkio.common;

import com.ibm.asyncutil.util.Either;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.structs.RawByteArrayOutputStream;
import com.ishland.c2me.base.common.util.SneakyThrow;
import com.ishland.c2me.base.mixin.access.IRegionBasedStorage;
import com.ishland.c2me.base.mixin.access.IRegionFile;
import io.netty.util.internal.PlatformDependent;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_4486;
import net.minecraft.class_6836;
import net.minecraft.class_9240;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2MEStorageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Storage");
    private static final AtomicLong SERIAL = new AtomicLong(0L);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final class_2867 storage;
    private final AtomicInteger taskSize = new AtomicInteger();
    private final Long2ReferenceLinkedOpenHashMap<CompletionStage<Either<class_2487, byte[]>>> writeBacklog = new Long2ReferenceLinkedOpenHashMap();
    private final Long2ReferenceLinkedOpenHashMap<CompletionStage<Either<class_2487, byte[]>>> cache = new Long2ReferenceLinkedOpenHashMap();
    private final Queue<Runnable> pendingTasks = PlatformDependent.newMpscQueue();
    private final LongFunction<Executor> backgroundExecutorSupplier;
    private final Executor executor = command -> {
        if (Thread.currentThread() == this) {
            command.run();
        } else {
            boolean empty = this.taskSize.getAndIncrement() == 0;
            this.pendingTasks.add(command);
            if (empty) {
                this.wakeUp();
            }
        }
    };
    private final ObjectArraySet<CompletableFuture<Void>> writeFutures = new ObjectArraySet();
    private final Object sync = new Object();

    public C2MEStorageThread(class_9240 arg, Path path, boolean dsync, LongFunction<Executor> backgroundExecutorSupplier) {
        this.storage = new class_2867(arg, path, dsync);
        if (backgroundExecutorSupplier != null) {
            this.backgroundExecutorSupplier = backgroundExecutorSupplier;
        } else {
            Executor executor1 = GlobalExecutors.prioritizedScheduler.executor(16);
            this.backgroundExecutorSupplier = unused -> executor1;
        }
        this.setName("C2ME Storage #%d".formatted(SERIAL.incrementAndGet()));
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread %s died".formatted(t), e));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            boolean hasWork = false;
            this.runWriteFutureGC();
            if (hasWork |= this.pollTasks()) continue;
            if (this.closing.get()) {
                this.flush0(true);
                try {
                    this.storage.close();
                }
                catch (Throwable t) {
                    LOGGER.error("Error closing storage", t);
                }
                break;
            }
            Object object = this.sync;
            synchronized (object) {
                if (this.taskSize.get() != 0 || this.closing.get()) {
                    continue;
                }
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.closeFuture.complete(null);
        LOGGER.info("Storage thread {} stopped", (Object)this);
    }

    private boolean pollTasks() {
        boolean hasWork = false;
        hasWork = this.handleTasks() || hasWork;
        hasWork = this.writeBacklog() || hasWork;
        return hasWork;
    }

    private boolean hasPendingTasks() {
        return !this.pendingTasks.isEmpty() || !this.writeBacklog.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    public CompletableFuture<class_2487> getChunkData(long pos, class_6836 scanner) {
        CompletableFuture future = new CompletableFuture();
        if (this.closing.get()) {
            future.completeExceptionally(new CancellationException());
            return future.thenApply(Function.identity());
        }
        this.executor.execute(() -> this.read0(pos, future, scanner));
        return future.thenApply(Function.identity());
    }

    public CompletableFuture<Void> setChunkData(long pos, @Nullable class_2487 nbt) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute(() -> {
            this.write0(pos, CompletableFuture.completedFuture(nbt != null ? Either.left((Object)nbt) : null));
            future.complete(null);
        });
        return future;
    }

    public CompletableFuture<Void> setChunkData(long pos, @Nullable byte[] data) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute(() -> {
            this.write0(pos, CompletableFuture.completedFuture(data != null ? Either.right((Object)data) : null));
            future.complete(null);
        });
        return future;
    }

    public CompletableFuture<Void> setChunkData(long pos, CompletionStage<class_2487> nbtFuture) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute(() -> {
            this.write0(pos, nbtFuture.thenApply(nbt -> nbt != null ? Either.left((Object)nbt) : null));
            future.complete(null);
        });
        return future;
    }

    public CompletableFuture<Void> setChunkDataRaw(long pos, CompletionStage<byte[]> dataFuture) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute(() -> {
            this.write0(pos, dataFuture.thenApply(data -> data != null ? Either.right((Object)data) : null));
            future.complete(null);
        });
        return future;
    }

    public CompletableFuture<Void> flush(boolean sync) {
        return CompletableFuture.runAsync(() -> this.flush0(sync), this.executor);
    }

    private void flush0(boolean sync) {
        try {
            do {
                this.runWriteFutureGC();
            } while (this.handleTasks() || this.writeBacklog());
            this.flushBacklog();
            if (sync) {
                this.storage.method_26982();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error flushing storage", t);
        }
    }

    public class_9240 getStorageKey() {
        return this.storage.method_61005();
    }

    public CompletableFuture<Void> close() {
        this.closing.set(true);
        this.wakeUp();
        return this.closeFuture.thenApply(Function.identity());
    }

    private boolean handleTasks() {
        Runnable runnable;
        boolean hasWork = false;
        while ((runnable = this.pendingTasks.poll()) != null) {
            hasWork = true;
            this.taskSize.decrementAndGet();
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error while executing task", t);
            }
        }
        return hasWork;
    }

    private void write0(long pos, CompletionStage<Either<class_2487, byte[]>> nbt) {
        this.cache.put(pos, nbt);
        this.writeBacklog.put(pos, nbt);
    }

    private void read0(long pos, CompletableFuture<class_2487> future, class_6836 scanner) {
        if (this.cache.containsKey(pos)) {
            CompletionStage cachedFuture = (CompletionStage)this.cache.get(pos);
            if (cachedFuture == null) {
                future.complete(null);
            } else {
                cachedFuture.whenComplete((cached, throwable) -> {
                    if (throwable != null) {
                        this.executor.execute(() -> {
                            LOGGER.warn("Retrying read of chunk {} because previous write to chunk threw an exception", (Object)new class_1923(pos));
                            this.read0(pos, future, scanner);
                        });
                        return;
                    }
                    if (cached == null) {
                        future.complete(null);
                    } else if (cached.left().isPresent()) {
                        if (scanner != null) {
                            this.backgroundExecutorSupplier.apply(pos).execute(() -> {
                                try {
                                    ((class_2487)cached.left().get()).method_39876(scanner);
                                    future.complete(null);
                                }
                                catch (Throwable t) {
                                    future.completeExceptionally(t);
                                }
                            });
                        } else {
                            future.complete((class_2487)cached.left().get());
                        }
                    } else {
                        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                            try {
                                DataInputStream input = new DataInputStream(new ByteArrayInputStream((byte[])cached.right().get()));
                                if (scanner != null) {
                                    class_2507.method_39855((DataInput)input, (class_6836)scanner, (class_2505)class_2505.method_53898());
                                    return null;
                                }
                                class_2487 compound = class_2507.method_10627((DataInput)input);
                                return compound;
                            }
                            catch (IOException e) {
                                SneakyThrow.sneaky((Throwable)e);
                                return null;
                            }
                        }, this.backgroundExecutorSupplier.apply(pos)).thenAccept(future::complete)).exceptionally(throwable1 -> {
                            future.completeExceptionally((Throwable)throwable1);
                            return null;
                        });
                    }
                });
            }
        } else {
            this.scheduleChunkRead(pos, future, scanner);
        }
    }

    private boolean writeBacklog() {
        if (!this.writeBacklog.isEmpty()) {
            long pos = this.writeBacklog.firstLongKey();
            CompletionStage nbtFuture = (CompletionStage)this.writeBacklog.removeFirst();
            this.writeChunk(pos, nbtFuture);
            return true;
        }
        return false;
    }

    private void runWriteFutureGC() {
        this.writeFutures.removeIf(CompletableFuture::isDone);
    }

    private void flushBacklog() {
        while (!this.writeFutures.isEmpty()) {
            while (this.writeBacklog()) {
            }
            this.runWriteFutureGC();
            CompletableFuture<Void> allFuture = CompletableFuture.allOf((CompletableFuture[])this.writeFutures.stream().map(future -> future.exceptionally(unused -> null)).distinct().toArray(CompletableFuture[]::new));
            while (!allFuture.isDone()) {
                this.handleTasks();
            }
            this.runWriteFutureGC();
        }
    }

    private void scheduleChunkRead(long pos, CompletableFuture<class_2487> future, class_6836 scanner) {
        try {
            class_1923 pos1 = new class_1923(pos);
            class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
            DataInputStream chunkInputStream = regionFile.method_21873(pos1);
            if (chunkInputStream == null) {
                future.complete(null);
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                try (DataInputStream inputStream = chunkInputStream;){
                    if (scanner != null) {
                        class_2507.method_39855((DataInput)inputStream, (class_6836)scanner, (class_2505)class_2505.method_53898());
                        class_2487 class_24873 = null;
                        return class_24873;
                    }
                    class_2487 class_24872 = class_2507.method_10627((DataInput)inputStream);
                    return class_24872;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, this.backgroundExecutorSupplier.apply(pos)).handle((compound, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete((class_2487)compound);
                }
                return null;
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
    }

    private void writeChunk(long pos, CompletionStage<Either<class_2487, byte[]>> nbtFuture) {
        CompletionStage<Void> writeFuture1 = nbtFuture.thenAcceptAsync(nbt -> {
            if (nbt == null) {
                if (this.cache.get(pos) == nbtFuture) {
                    try {
                        class_1923 pos1 = new class_1923(pos);
                        class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                        regionFile.method_31740(pos1);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), t);
                    }
                    this.cache.remove(pos);
                }
            } else {
                class_4486 compressionFormat;
                class_1923 pos1 = new class_1923(pos);
                try {
                    class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                    compressionFormat = ((IRegionFile)regionFile).getCompressionFormat();
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to get compression format for chunk %s".formatted(pos1), t);
                    compressionFormat = class_4486.method_56567();
                }
                class_4486 finalCompressionFormat = compressionFormat;
                CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        RawByteArrayOutputStream out = new RawByteArrayOutputStream(8096);
                        out.write(0);
                        out.write(0);
                        out.write(0);
                        out.write(0);
                        out.write(finalCompressionFormat.method_21882());
                        try (DataOutputStream dataOutputStream = new DataOutputStream(finalCompressionFormat.method_21886((OutputStream)out));){
                            if (nbt.left().isPresent()) {
                                class_2507.method_10628((class_2487)((class_2487)nbt.left().get()), (DataOutput)dataOutputStream);
                            } else {
                                dataOutputStream.write((byte[])nbt.right().get());
                            }
                        }
                        return out;
                    }
                    catch (Throwable t) {
                        SneakyThrow.sneaky((Throwable)t);
                        return null;
                    }
                }, GlobalExecutors.prioritizedScheduler.executor(16)).thenAcceptAsync(bytes -> {
                    if (this.cache.remove(pos, (Object)nbtFuture)) {
                        try {
                            class_1923 pos1 = new class_1923(pos);
                            class_2861 regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                            ByteBuffer byteBuffer = bytes.asByteBuffer();
                            byteBuffer.putInt(0, bytes.size() - 5 + 1);
                            ((IRegionFile)regionFile).invokeWriteChunk(pos1, byteBuffer);
                        }
                        catch (Throwable t) {
                            SneakyThrow.sneaky((Throwable)t);
                        }
                    }
                }, this.executor)).handleAsync((unused, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error("Error writing chunk %s".formatted(new class_1923(pos)), throwable);
                    }
                    return null;
                }, this.executor);
                this.writeFutures.add((Object)future);
            }
        }, this.executor);
        this.writeFutures.add(writeFuture1.toCompletableFuture());
    }

    private record WriteRequest(long pos, Either<class_2487, byte[]> nbt) {
    }

    private record ReadRequest(long pos, CompletableFuture<class_2487> future, @Nullable class_6836 scanner) {
    }
}

