/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.dfc.common.gen;

import com.ishland.c2me.opts.dfc.common.ast.AstNode;
import com.ishland.c2me.opts.dfc.common.ast.EvalType;
import com.ishland.c2me.opts.dfc.common.ast.McToAst;
import com.ishland.c2me.opts.dfc.common.ast.dfvisitor.StripBlending;
import com.ishland.c2me.opts.dfc.common.ast.misc.ConstantNode;
import com.ishland.c2me.opts.dfc.common.ast.misc.RootNode;
import com.ishland.c2me.opts.dfc.common.gen.CompiledDensityFunction;
import com.ishland.c2me.opts.dfc.common.gen.CompiledEntry;
import com.ishland.c2me.opts.dfc.common.util.ArrayCache;
import com.ishland.c2me.opts.dfc.common.vif.AstVanillaInterface;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_6492;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AnalyzerAdapter;
import org.objectweb.asm.commons.InstructionAdapter;
import org.spongepowered.asm.util.Files;

public class BytecodeGen {
    private static final File exportDir = new File("./cache/c2me-dfc");
    private static final AtomicLong ordinal = new AtomicLong();
    public static final Hash.Strategy<AstNode> RELAXED_STRATEGY;
    private static final Object2ReferenceMap<AstNode, Class<?>> compilationCache;

    public static class_6910 compile(class_6910 densityFunction, Reference2ReferenceMap<class_6910, class_6910> tempCache) {
        class_6910 cached = (class_6910)tempCache.get((Object)densityFunction);
        if (cached != null) {
            return cached;
        }
        if (densityFunction instanceof AstVanillaInterface) {
            AstVanillaInterface vif = (AstVanillaInterface)densityFunction;
            AstNode ast = vif.getAstNode();
            return new CompiledDensityFunction(BytecodeGen.compile0(ast), vif.getBlendingFallback());
        }
        AstNode ast = McToAst.toAst(densityFunction.method_40469((class_6910.class_6915)StripBlending.INSTANCE));
        if (ast instanceof ConstantNode) {
            ConstantNode constantNode = (ConstantNode)ast;
            return class_6916.method_40480((double)constantNode.getValue());
        }
        CompiledDensityFunction compiled = new CompiledDensityFunction(BytecodeGen.compile0(ast), densityFunction);
        tempCache.put((Object)densityFunction, (Object)compiled);
        return compiled;
    }

    public static synchronized CompiledEntry compile0(AstNode node) {
        Class cached = (Class)compilationCache.get((Object)node);
        ClassWriter writer = new ClassWriter(3);
        String name = cached != null ? String.format("DfcCompiled_discarded", new Object[0]) : String.format("DfcCompiled_%d", ordinal.getAndIncrement());
        writer.visit(65, 17, name, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(CompiledEntry.class)});
        RootNode rootNode = new RootNode(node);
        Context genContext = new Context(writer, name);
        genContext.newSingleMethod0((adapter, localVarConsumer) -> rootNode.doBytecodeGenSingle(genContext, (InstructionAdapter)adapter, (Context.LocalVarConsumer)localVarConsumer), "evalSingle", true);
        genContext.newMultiMethod0((adapter, localVarConsumer) -> rootNode.doBytecodeGenMulti(genContext, (InstructionAdapter)adapter, (Context.LocalVarConsumer)localVarConsumer), "evalMulti", true);
        List args = genContext.args.entrySet().stream().sorted(Comparator.comparingInt(o -> ((Context.FieldRecord)o.getValue()).ordinal())).map(Map.Entry::getKey).collect(Collectors.toCollection(ArrayList::new));
        if (cached != null) {
            try {
                return (CompiledEntry)cached.getConstructor(List.class).newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        BytecodeGen.genConstructor(genContext);
        BytecodeGen.genGetArgs(genContext);
        BytecodeGen.genNewInstance(genContext);
        ListIterator iterator = args.listIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
        }
        byte[] bytes = writer.toByteArray();
        BytecodeGen.dumpClass(genContext.className, bytes);
        Class<?> defined = BytecodeGen.defineClass(genContext.className, bytes);
        compilationCache.put((Object)node, defined);
        try {
            return (CompiledEntry)defined.getConstructor(List.class).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void genConstructor(Context context) {
        InstructionAdapter m = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(context.className, 1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(List.class)}), context.classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(List.class)}), null, null)));
        Label start = new Label();
        Label end = new Label();
        m.visitLabel(start);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.invokespecial(Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        for (Map.Entry entry : context.args.entrySet().stream().sorted(Comparator.comparingInt(o -> ((Context.FieldRecord)o.getValue()).ordinal())).toList()) {
            String name = ((Context.FieldRecord)entry.getValue()).name();
            Class<?> type = ((Context.FieldRecord)entry.getValue()).type();
            int ordinal = ((Context.FieldRecord)entry.getValue()).ordinal();
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.iconst(ordinal);
            m.invokeinterface(Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)InstructionAdapter.OBJECT_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
            m.checkcast(Type.getType(type));
            m.putfield(context.className, name, Type.getDescriptor(type));
        }
        for (String postProcessingMethod : context.postProcessMethods.stream().sorted().toList()) {
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.invokevirtual(context.className, postProcessingMethod, "()V", false);
        }
        m.areturn(Type.VOID_TYPE);
        m.visitLabel(end);
        m.visitLocalVariable("this", context.classDesc, null, start, end, 0);
        m.visitLocalVariable("list", Type.getDescriptor(List.class), null, start, end, 1);
        m.visitMaxs(0, 0);
    }

    private static void genGetArgs(Context context) {
        InstructionAdapter m = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(context.className, 17, "getArgs", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[0]), context.classWriter.visitMethod(17, "getArgs", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[0]), null, null)));
        Label start = new Label();
        Label end = new Label();
        m.visitLabel(start);
        m.anew(Type.getType(ArrayList.class));
        m.dup();
        m.iconst(context.args.size());
        m.invokespecial(Type.getInternalName(ArrayList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        m.store(1, InstructionAdapter.OBJECT_TYPE);
        for (Map.Entry entry : context.args.entrySet().stream().sorted(Comparator.comparingInt(o -> ((Context.FieldRecord)o.getValue()).ordinal())).toList()) {
            String name = ((Context.FieldRecord)entry.getValue()).name();
            Class<?> type = ((Context.FieldRecord)entry.getValue()).type();
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.getfield(context.className, name, Type.getDescriptor(type));
            m.invokeinterface(Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{InstructionAdapter.OBJECT_TYPE}));
            m.pop();
        }
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.areturn(InstructionAdapter.OBJECT_TYPE);
        m.visitLabel(end);
        m.visitLocalVariable("this", context.classDesc, null, start, end, 0);
        m.visitLocalVariable("list", Type.getDescriptor(List.class), null, start, end, 1);
        m.visitMaxs(0, 0);
    }

    private static void genNewInstance(Context context) {
        InstructionAdapter m = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(context.className, 17, "newInstance", Type.getMethodDescriptor((Type)Type.getType(CompiledEntry.class), (Type[])new Type[]{Type.getType(List.class)}), context.classWriter.visitMethod(17, "newInstance", Type.getMethodDescriptor((Type)Type.getType(CompiledEntry.class), (Type[])new Type[]{Type.getType(List.class)}), null, null)));
        Label start = new Label();
        Label end = new Label();
        m.visitLabel(start);
        m.anew(Type.getType((String)context.classDesc));
        m.dup();
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.invokespecial(context.className, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(List.class)}), false);
        m.areturn(InstructionAdapter.OBJECT_TYPE);
        m.visitLabel(end);
        m.visitLocalVariable("this", context.classDesc, null, start, end, 0);
        m.visitLocalVariable("list", Type.getDescriptor(List.class), null, start, end, 1);
        m.visitMaxs(0, 0);
    }

    private static void dumpClass(String className, byte[] bytes) {
        File outputFile = new File(exportDir, className + ".class");
        outputFile.getParentFile().mkdirs();
        try {
            com.google.common.io.Files.write((byte[])bytes, (File)outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Class<?> defineClass(final String className, final byte[] bytes) {
        ClassLoader classLoader = new ClassLoader(BytecodeGen.class.getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.equals(className)) {
                    return super.defineClass(name, bytes, 0, bytes.length);
                }
                return super.loadClass(name);
            }
        };
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Files.deleteRecursively((File)exportDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RELAXED_STRATEGY = new Hash.Strategy<AstNode>(){

            public int hashCode(AstNode o) {
                return o.relaxedHashCode();
            }

            public boolean equals(AstNode a, AstNode b) {
                return a.relaxedEquals(b);
            }
        };
        compilationCache = Object2ReferenceMaps.synchronize((Object2ReferenceMap)new Object2ReferenceOpenCustomHashMap(RELAXED_STRATEGY));
    }

    public static class Context {
        public static final String SINGLE_DESC = Type.getMethodDescriptor((Type)Type.getType(Double.TYPE), (Type[])new Type[]{Type.getType(Integer.TYPE), Type.getType(Integer.TYPE), Type.getType(Integer.TYPE), Type.getType(EvalType.class)});
        public static final String MULTI_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(double[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(EvalType.class), Type.getType(ArrayCache.class)});
        public final ClassWriter classWriter;
        public final String className;
        public final String classDesc;
        private int methodIdx = 0;
        private final Object2ReferenceOpenHashMap<AstNode, String> singleMethods = new Object2ReferenceOpenHashMap();
        private final Object2ReferenceOpenHashMap<AstNode, String> multiMethods = new Object2ReferenceOpenHashMap();
        private final Object2ReferenceOpenHashMap<class_6492<class_6916.class_7076.class_7136, class_6916.class_7076.class_7135>, String> splineMethods = new Object2ReferenceOpenHashMap();
        private final ObjectOpenHashSet<String> postProcessMethods = new ObjectOpenHashSet();
        private final Reference2ObjectOpenHashMap<Object, FieldRecord> args = new Reference2ObjectOpenHashMap();

        public Context(ClassWriter classWriter, String className) {
            this.classWriter = Objects.requireNonNull(classWriter);
            this.className = Objects.requireNonNull(className);
            this.classDesc = String.format("L%s;", this.className);
        }

        public String nextMethodName() {
            return String.format("method_%d", this.methodIdx++);
        }

        public String nextMethodName(String suffix) {
            return String.format("method_%d_%s", this.methodIdx++, suffix);
        }

        public String newSingleMethod(AstNode node) {
            return (String)this.singleMethods.computeIfAbsent((Object)node, node1 -> this.newSingleMethod((adapter, localVarConsumer) -> node1.doBytecodeGenSingle(this, (InstructionAdapter)adapter, (LocalVarConsumer)localVarConsumer), this.nextMethodName(node.getClass().getSimpleName())));
        }

        public String newSingleMethod(BiConsumer<InstructionAdapter, LocalVarConsumer> generator) {
            return this.newSingleMethod(generator, this.nextMethodName());
        }

        public String newSingleMethod(BiConsumer<InstructionAdapter, LocalVarConsumer> generator, String name) {
            this.newSingleMethod0(generator, name, false);
            return name;
        }

        private void newSingleMethod0(BiConsumer<InstructionAdapter, LocalVarConsumer> generator, String name, boolean isPublic) {
            InstructionAdapter adapter = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(this.className, (isPublic ? 1 : 2) | 0x10, name, SINGLE_DESC, this.classWriter.visitMethod((isPublic ? 1 : 2) | 0x10, name, SINGLE_DESC, null, null)));
            ArrayList extraLocals = new ArrayList();
            Label start = new Label();
            Label end = new Label();
            adapter.visitLabel(start);
            generator.accept(adapter, (localName, localDesc) -> {
                int ordinal = extraLocals.size() + 5;
                extraLocals.add(IntObjectPair.of((int)ordinal, (Object)Pair.of((Object)localName, (Object)localDesc)));
                return ordinal;
            });
            adapter.visitLabel(end);
            adapter.visitLocalVariable("this", this.classDesc, null, start, end, 0);
            adapter.visitLocalVariable("x", Type.INT_TYPE.getDescriptor(), null, start, end, 1);
            adapter.visitLocalVariable("y", Type.INT_TYPE.getDescriptor(), null, start, end, 2);
            adapter.visitLocalVariable("z", Type.INT_TYPE.getDescriptor(), null, start, end, 3);
            adapter.visitLocalVariable("evalType", Type.getType(EvalType.class).getDescriptor(), null, start, end, 4);
            for (IntObjectPair local : extraLocals) {
                adapter.visitLocalVariable((String)((Pair)local.right()).left(), (String)((Pair)local.right()).right(), null, start, end, local.leftInt());
            }
            adapter.visitMaxs(0, 0);
        }

        public String newMultiMethod(AstNode node) {
            return (String)this.multiMethods.computeIfAbsent((Object)node, node1 -> this.newMultiMethod((adapter, localVarConsumer) -> node1.doBytecodeGenMulti(this, (InstructionAdapter)adapter, (LocalVarConsumer)localVarConsumer), this.nextMethodName(node.getClass().getSimpleName())));
        }

        public String newMultiMethod(BiConsumer<InstructionAdapter, LocalVarConsumer> generator) {
            return this.newMultiMethod(generator, this.nextMethodName());
        }

        public String newMultiMethod(BiConsumer<InstructionAdapter, LocalVarConsumer> generator, String name) {
            this.newMultiMethod0(generator, name, false);
            return name;
        }

        private void newMultiMethod0(BiConsumer<InstructionAdapter, LocalVarConsumer> generator, String name, boolean isPublic) {
            InstructionAdapter adapter = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(this.className, (isPublic ? 1 : 2) | 0x10, name, MULTI_DESC, this.classWriter.visitMethod((isPublic ? 1 : 2) | 0x10, name, MULTI_DESC, null, null)));
            ArrayList extraLocals = new ArrayList();
            Label start = new Label();
            Label end = new Label();
            adapter.visitLabel(start);
            generator.accept(adapter, (localName, localDesc) -> {
                int ordinal = extraLocals.size() + 7;
                extraLocals.add(IntObjectPair.of((int)ordinal, (Object)Pair.of((Object)localName, (Object)localDesc)));
                return ordinal;
            });
            adapter.visitLabel(end);
            adapter.visitLocalVariable("this", this.classDesc, null, start, end, 0);
            adapter.visitLocalVariable("res", Type.getType(double[].class).getDescriptor(), null, start, end, 1);
            adapter.visitLocalVariable("x", Type.getType(double[].class).getDescriptor(), null, start, end, 2);
            adapter.visitLocalVariable("y", Type.getType(double[].class).getDescriptor(), null, start, end, 3);
            adapter.visitLocalVariable("z", Type.getType(double[].class).getDescriptor(), null, start, end, 4);
            adapter.visitLocalVariable("evalType", Type.getType(EvalType.class).getDescriptor(), null, start, end, 5);
            adapter.visitLocalVariable("arrayCache", Type.getType(ArrayCache.class).getDescriptor(), null, start, end, 6);
            for (IntObjectPair local : extraLocals) {
                adapter.visitLocalVariable((String)((Pair)local.right()).left(), (String)((Pair)local.right()).right(), null, start, end, local.leftInt());
            }
            adapter.visitMaxs(0, 0);
        }

        public String getCachedSplineMethod(class_6492<class_6916.class_7076.class_7136, class_6916.class_7076.class_7135> spline) {
            return (String)this.splineMethods.get(spline);
        }

        public void cacheSplineMethod(class_6492<class_6916.class_7076.class_7136, class_6916.class_7076.class_7135> spline, String method) {
            this.splineMethods.put(spline, (Object)method);
        }

        public void callDelegateSingle(InstructionAdapter m, String target) {
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.load(1, Type.INT_TYPE);
            m.load(2, Type.INT_TYPE);
            m.load(3, Type.INT_TYPE);
            m.load(4, InstructionAdapter.OBJECT_TYPE);
            m.invokevirtual(this.className, target, SINGLE_DESC, false);
        }

        public void callDelegateMulti(InstructionAdapter m, String target) {
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(2, InstructionAdapter.OBJECT_TYPE);
            m.load(3, InstructionAdapter.OBJECT_TYPE);
            m.load(4, InstructionAdapter.OBJECT_TYPE);
            m.load(5, InstructionAdapter.OBJECT_TYPE);
            m.load(6, InstructionAdapter.OBJECT_TYPE);
            m.invokevirtual(this.className, target, MULTI_DESC, false);
        }

        public <T> String newField(Class<T> type, T data) {
            FieldRecord existing = (FieldRecord)this.args.get(data);
            if (existing != null) {
                return existing.name();
            }
            int size = this.args.size();
            String name = String.format("field_%d", size);
            this.classWriter.visitField(2, name, Type.getDescriptor(type), null, null);
            this.args.put(data, (Object)new FieldRecord(name, size, type));
            return name;
        }

        public void doCountedLoop(InstructionAdapter m, LocalVarConsumer localVarConsumer, IntConsumer bodyGenerator) {
            int loopIdx = localVarConsumer.createLocalVariable("loopIdx", Type.INT_TYPE.getDescriptor());
            m.iconst(0);
            m.store(loopIdx, Type.INT_TYPE);
            Label start = new Label();
            Label end = new Label();
            m.visitLabel(start);
            m.load(loopIdx, Type.INT_TYPE);
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.arraylength();
            m.ificmpge(end);
            bodyGenerator.accept(loopIdx);
            m.iinc(loopIdx, 1);
            m.goTo(start);
            m.visitLabel(end);
        }

        public void delegateToSingle(InstructionAdapter m, LocalVarConsumer localVarConsumer, AstNode current) {
            String singleMethod = this.newSingleMethod(current);
            this.doCountedLoop(m, localVarConsumer, idx -> {
                m.load(1, InstructionAdapter.OBJECT_TYPE);
                m.load(idx, Type.INT_TYPE);
                m.load(0, InstructionAdapter.OBJECT_TYPE);
                m.load(2, InstructionAdapter.OBJECT_TYPE);
                m.load(idx, Type.INT_TYPE);
                m.aload(Type.INT_TYPE);
                m.load(3, InstructionAdapter.OBJECT_TYPE);
                m.load(idx, Type.INT_TYPE);
                m.aload(Type.INT_TYPE);
                m.load(4, InstructionAdapter.OBJECT_TYPE);
                m.load(idx, Type.INT_TYPE);
                m.aload(Type.INT_TYPE);
                m.load(5, InstructionAdapter.OBJECT_TYPE);
                m.invokevirtual(this.className, singleMethod, SINGLE_DESC, false);
                m.astore(Type.DOUBLE_TYPE);
            });
        }

        public void genPostprocessingMethod(String name, Consumer<InstructionAdapter> generator) {
            if (this.postProcessMethods.contains((Object)name)) {
                return;
            }
            InstructionAdapter adapter = new InstructionAdapter((MethodVisitor)new AnalyzerAdapter(this.className, 18, name, "()V", this.classWriter.visitMethod(18, name, "()V", null, null)));
            Label start = new Label();
            Label end = new Label();
            adapter.visitLabel(start);
            generator.accept(adapter);
            adapter.visitLabel(end);
            adapter.visitMaxs(0, 0);
            adapter.visitLocalVariable("this", this.classDesc, null, start, end, 0);
            this.postProcessMethods.add((Object)name);
        }

        public static interface LocalVarConsumer {
            public int createLocalVariable(String var1, String var2);
        }

        private record FieldRecord(String name, int ordinal, Class<?> type) {
        }
    }

    @FunctionalInterface
    public static interface EvalMultiInterface {
        public void evalMulti(double[] var1, int[] var2, int[] var3, int[] var4, EvalType var5);
    }

    @FunctionalInterface
    public static interface EvalSingleInterface {
        public double evalSingle(int var1, int var2, int var3, EvalType var4);
    }
}

