/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.model.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import net.minecraft.class_778;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_778.class})
public class ModelBlockRendererMixin {
    @Unique
    private static final ThreadLocal<class_5819> RANDOM = ThreadLocal.withInitial(() -> new class_6575(42L));
    @Unique
    private static final ThreadLocal<List<class_10889>> LIST = ThreadLocal.withInitial(() -> new ObjectArrayList());

    @Unique
    private static void renderQuads(class_4587.class_4665 matrices, VertexBufferWriter writer, int defaultColor, List<class_777> quads, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            class_777 bakedQuad = quads.get(i);
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = quad.hasColor() ? defaultColor : -1;
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, false);
            if (quad.getSprite() == null) continue;
            SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
        }
    }

    @Inject(method={"method_3367(Lnet/minecraft/class_4587$class_4665;Lnet/minecraft/class_4588;Lnet/minecraft/class_1087;FFFII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderFast(class_4587.class_4665 entry, class_4588 vertexConsumer, class_1087 bakedModel, float red, float green, float blue, int light, int overlay, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        class_5819 random = RANDOM.get();
        red = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
        green = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
        blue = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        random.method_43052(42L);
        List<class_10889> list = LIST.get();
        list.clear();
        bakedModel.method_68513(random, list);
        for (class_10889 part : list) {
            for (class_2350 direction : DirectionUtil.ALL_DIRECTIONS) {
                List quads = part.method_68509(direction);
                if (quads.isEmpty()) continue;
                ModelBlockRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
            }
            List quads = part.method_68509(null);
            if (quads.isEmpty()) continue;
            ModelBlockRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
        }
    }
}

