/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud;

import java.io.Closeable;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.bingo.client.common.event.ClientConfigChangedEvent;
import me.jfenn.bingo.client.common.event.HudStateChangedEvent;
import me.jfenn.bingo.client.common.hud.BingoCardColors;
import me.jfenn.bingo.client.common.hud.BingoEndFireworkRenderer;
import me.jfenn.bingo.client.common.hud.BingoMessageRenderer;
import me.jfenn.bingo.client.common.hud.ReadyHudRenderer;
import me.jfenn.bingo.client.common.hud.card.ClientCardBufferRenderer;
import me.jfenn.bingo.client.common.hud.card.ClientCardManager;
import me.jfenn.bingo.client.common.hud.card.ClientCardRenderer;
import me.jfenn.bingo.client.common.hud.screen.BingoHudScreen;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.common.state.ClientCard;
import me.jfenn.bingo.client.common.state.ClientCardBase;
import me.jfenn.bingo.client.common.utils.Interpolate;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.client.platform.IClient;
import me.jfenn.bingo.client.platform.IKeyBinding;
import me.jfenn.bingo.client.platform.IKeyBindingManager;
import me.jfenn.bingo.client.platform.IOptionsAccessor;
import me.jfenn.bingo.client.platform.event.model.ClientReloadEvent;
import me.jfenn.bingo.client.platform.event.model.ClientServerEvent;
import me.jfenn.bingo.client.platform.event.model.ClientTickEvent;
import me.jfenn.bingo.client.platform.event.model.HudRenderEvent;
import me.jfenn.bingo.client.platform.event.model.InvalidateRenderStateEvent;
import me.jfenn.bingo.client.platform.event.model.ScreenEvent;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.CardAlignment;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.game.GameOverPacket;
import me.jfenn.bingo.common.game.GameStatusPacket;
import me.jfenn.bingo.common.map.CardDisplay;
import me.jfenn.bingo.common.map.CardDisplayPacket;
import me.jfenn.bingo.common.map.CardShuffledPacket;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTilesPacket;
import me.jfenn.bingo.common.map.CardUpdatePacket;
import me.jfenn.bingo.common.map.CardView;
import me.jfenn.bingo.common.menu.tooltips.TooltipPacket;
import me.jfenn.bingo.common.ready.ReadyUpdatePacket;
import me.jfenn.bingo.common.ready.SetReadyPacket;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.scoring.CardCompletedPacket;
import me.jfenn.bingo.common.scoring.GameMessagePacket;
import me.jfenn.bingo.common.scoring.ScoreMessagePacket;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import me.jfenn.bingo.platform.event.model.ServerEvent;
import me.jfenn.bingo.platform.text.IText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ1\u0010&\u001a\u00020%2 \u0010$\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"0 H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001b\u0010(\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"H\u0002\u00a2\u0006\u0004\b(\u0010)J\r\u0010+\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020*\u00a2\u0006\u0004\b-\u0010,J\u0011\u0010/\u001a\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00103\u001a\u00020%2\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b3\u00104J\u0017\u00105\u001a\u00020%2\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b5\u00104J\u000f\u00106\u001a\u00020%H\u0002\u00a2\u0006\u0004\b6\u00107J\u001d\u0010;\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020908H\u0002\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010?\u001a\u00020%2\u0006\u0010>\u001a\u00020=H\u0002\u00a2\u0006\u0004\b?\u0010@J\u001d\u0010B\u001a\u00020%2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020A08H\u0002\u00a2\u0006\u0004\bB\u0010<J\u001d\u0010C\u001a\u00020%2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=08H\u0002\u00a2\u0006\u0004\bC\u0010<J\u001d\u0010E\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020D08H\u0002\u00a2\u0006\u0004\bE\u0010<J\u001d\u0010G\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020F08H\u0002\u00a2\u0006\u0004\bG\u0010<J%\u0010J\u001a\u00020%2\u0014\u0010I\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020H0 H\u0002\u00a2\u0006\u0004\bJ\u0010'J\u001d\u0010L\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020K08H\u0002\u00a2\u0006\u0004\bL\u0010<J\u001d\u0010M\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020K08H\u0002\u00a2\u0006\u0004\bM\u0010<J\u0019\u0010Q\u001a\u00020%2\b\u0010N\u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0004\bO\u0010PJ\u001d\u0010S\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020R08H\u0002\u00a2\u0006\u0004\bS\u0010<J\u001d\u0010U\u001a\u00020%2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020T08H\u0002\u00a2\u0006\u0004\bU\u0010<J\u0017\u0010X\u001a\u00020%2\u0006\u0010W\u001a\u00020VH\u0002\u00a2\u0006\u0004\bX\u0010YR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010ZR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010[R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\\R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010]R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010^R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010_R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010`R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010aR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010bR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010cR\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010dR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010eR\u0016\u0010f\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010h\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010gR\u0014\u0010j\u001a\u00020i8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010kR\u0014\u0010l\u001a\u00020i8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010kR\u0018\u0010n\u001a\u0004\u0018\u00010m8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0014\u0010q\u001a\u00020p8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bq\u0010rR\u0014\u0010s\u001a\u00020p8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bs\u0010rR\u0014\u0010t\u001a\u00020p8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bt\u0010rR\u0016\u0010v\u001a\u00020u8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010wR\u0016\u0010x\u001a\u00020u8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010wR\u0014\u0010z\u001a\u00020y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bz\u0010{\u00a8\u0006|"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoHudController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/client/platform/IOptionsAccessor;", "optionsAccessor", "Lme/jfenn/bingo/common/config/ConfigService;", "configService", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/common/hud/card/ClientCardRenderer;", "renderer", "Lme/jfenn/bingo/client/common/hud/card/ClientCardManager;", "clientCardManager", "Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;", "itemScoredRenderer", "Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer;", "readyHudRenderer", "Lme/jfenn/bingo/client/common/hud/screen/BingoHudScreen$Factory;", "endScreenFactory", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/client/platform/IKeyBindingManager;", "keyBindingManager", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "packetEvents", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/client/platform/IClient;", "client", "<init>", "(Lme/jfenn/bingo/client/platform/IOptionsAccessor;Lme/jfenn/bingo/common/config/ConfigService;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/common/hud/card/ClientCardRenderer;Lme/jfenn/bingo/client/common/hud/card/ClientCardManager;Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer;Lme/jfenn/bingo/client/common/hud/screen/BingoHudScreen$Factory;Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/client/platform/IKeyBindingManager;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/client/platform/IClient;)V", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "Lkotlin/Pair;", "", "cardPositions", "", "onCardHudClosed", "(Ljava/util/Map;)V", "getCardPos", "()Lkotlin/Pair;", "", "isCardMouseOver", "()Z", "isCardFocused", "Lme/jfenn/bingo/client/common/state/ClientCard;", "getSelectedCard", "()Lme/jfenn/bingo/client/common/state/ClientCard;", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "drawHudCards", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;)V", "drawHudInfo", "updateGameOverViews", "()V", "Lme/jfenn/bingo/client/platform/ClientPacket;", "Lme/jfenn/bingo/common/game/GameOverPacket;", "clientPacket", "onGameOver", "(Lme/jfenn/bingo/client/platform/ClientPacket;)V", "Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "packet", "onMessagePacket", "(Lme/jfenn/bingo/common/scoring/GameMessagePacket;)V", "Lme/jfenn/bingo/common/scoring/ScoreMessagePacket;", "onScoreMessage", "onGameMessage", "Lme/jfenn/bingo/common/map/CardUpdatePacket;", "onCardUpdate", "Lme/jfenn/bingo/common/ready/ReadyUpdatePacket;", "onReadyUpdate", "Lme/jfenn/bingo/common/map/CardDisplay;", "displays", "onCardDisplay", "Lme/jfenn/bingo/common/map/CardDisplayPacket;", "onCardDisplayV1", "onCardDisplayV2", "teamKey", "scheduleCardUpdates-2vhwn7g", "(Ljava/lang/String;)V", "scheduleCardUpdates", "Lme/jfenn/bingo/common/map/CardTilesPacket;", "onCardTiles", "Lme/jfenn/bingo/common/map/CardShuffledPacket;", "onCardShuffled", "Lnet/minecraft/class_3300;", "manager", "loadCardColors", "(Lnet/minecraft/class_3300;)V", "Lme/jfenn/bingo/client/platform/IOptionsAccessor;", "Lme/jfenn/bingo/common/config/ConfigService;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/common/hud/card/ClientCardRenderer;", "Lme/jfenn/bingo/client/common/hud/card/ClientCardManager;", "Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;", "Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer;", "Lme/jfenn/bingo/client/common/hud/screen/BingoHudScreen$Factory;", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/client/platform/IClient;", "cardHudWasClicked", "Z", "openCardKeyAlreadyPressed", "Lme/jfenn/bingo/client/platform/IKeyBinding;", "openCardKey", "Lme/jfenn/bingo/client/platform/IKeyBinding;", "toggleHudKey", "Lme/jfenn/bingo/client/common/hud/BingoEndFireworkRenderer;", "fireworkRenderer", "Lme/jfenn/bingo/client/common/hud/BingoEndFireworkRenderer;", "Lme/jfenn/bingo/client/common/utils/Interpolate;", "interpolateCardX", "Lme/jfenn/bingo/client/common/utils/Interpolate;", "interpolateCardY", "interpolateCardScale", "", "scaledWindowWidth", "I", "scaledWindowHeight", "Lnet/minecraft/class_2960;", "cardColorsId", "Lnet/minecraft/class_2960;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoHudController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoHudController.kt\nme/jfenn/bingo/client/common/hud/BingoHudController\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,666:1\n64#2:667\n64#2:668\n64#2:669\n64#2:677\n64#2:678\n1#3:670\n1374#4:671\n1460#4,5:672\n774#4:679\n865#4,2:680\n1669#4,8:682\n1011#4,2:690\n1869#4,2:706\n1252#4,4:710\n1761#4,3:721\n1869#4,2:725\n1869#4,2:727\n1869#4,2:729\n382#5,7:692\n382#5,7:699\n463#5:708\n413#5:709\n382#5,7:714\n80#6:724\n*S KotlinDebug\n*F\n+ 1 BingoHudController.kt\nme/jfenn/bingo/client/common/hud/BingoHudController\n*L\n99#1:667\n104#1:668\n109#1:669\n252#1:677\n253#1:678\n243#1:671\n243#1:672,5\n275#1:679\n275#1:680,2\n277#1:682,8\n310#1:690,2\n369#1:706,2\n385#1:710,4\n427#1:721,3\n459#1:725,2\n531#1:727,2\n661#1:729,2\n328#1:692,7\n362#1:699,7\n385#1:708\n385#1:709\n410#1:714,7\n452#1:724\n*E\n"})
public final class BingoHudController
extends BingoComponent {
    @NotNull
    private final IOptionsAccessor optionsAccessor;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ClientCardRenderer renderer;
    @NotNull
    private final ClientCardManager clientCardManager;
    @NotNull
    private final BingoMessageRenderer itemScoredRenderer;
    @NotNull
    private final ReadyHudRenderer readyHudRenderer;
    @NotNull
    private final BingoHudScreen.Factory endScreenFactory;
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final IClient client;
    private boolean cardHudWasClicked;
    private boolean openCardKeyAlreadyPressed;
    @NotNull
    private final IKeyBinding openCardKey;
    @NotNull
    private final IKeyBinding toggleHudKey;
    @Nullable
    private BingoEndFireworkRenderer fireworkRenderer;
    @NotNull
    private final Interpolate interpolateCardX;
    @NotNull
    private final Interpolate interpolateCardY;
    @NotNull
    private final Interpolate interpolateCardScale;
    private int scaledWindowWidth;
    private int scaledWindowHeight;
    @NotNull
    private final class_2960 cardColorsId;

    public BingoHudController(@NotNull IOptionsAccessor optionsAccessor, @NotNull ConfigService configService, @NotNull BingoConfig config, @NotNull ClientCardRenderer renderer, @NotNull ClientCardManager clientCardManager, @NotNull BingoMessageRenderer itemScoredRenderer, @NotNull ReadyHudRenderer readyHudRenderer, @NotNull BingoHudScreen.Factory endScreenFactory, @NotNull BingoHudState state, @NotNull TextProvider text, @NotNull IKeyBindingManager keyBindingManager, @NotNull ClientPacketEvents packetEvents, @NotNull IEventBus eventBus, @NotNull IClient client) {
        Intrinsics.checkNotNullParameter((Object)optionsAccessor, (String)"optionsAccessor");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)clientCardManager, (String)"clientCardManager");
        Intrinsics.checkNotNullParameter((Object)itemScoredRenderer, (String)"itemScoredRenderer");
        Intrinsics.checkNotNullParameter((Object)readyHudRenderer, (String)"readyHudRenderer");
        Intrinsics.checkNotNullParameter((Object)endScreenFactory, (String)"endScreenFactory");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)keyBindingManager, (String)"keyBindingManager");
        Intrinsics.checkNotNullParameter((Object)packetEvents, (String)"packetEvents");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.optionsAccessor = optionsAccessor;
        this.configService = configService;
        this.config = config;
        this.renderer = renderer;
        this.clientCardManager = clientCardManager;
        this.itemScoredRenderer = itemScoredRenderer;
        this.readyHudRenderer = readyHudRenderer;
        this.endScreenFactory = endScreenFactory;
        this.state = state;
        this.text = text;
        this.eventBus = eventBus;
        this.client = client;
        this.openCardKey = keyBindingManager.registerKey(ConstantsKt.getKEYBIND_OPEN_CARD(), 89, StringKey.FullName.getKey());
        this.toggleHudKey = keyBindingManager.registerKey(ConstantsKt.getKEYBIND_TOGGLE_HUD(), -1, StringKey.FullName.getKey());
        this.interpolateCardX = new Interpolate(0.0f, 0.0f, null, null, 12, null);
        this.interpolateCardY = new Interpolate(0.0f, 0.0f, null, null, 12, null);
        this.interpolateCardScale = new Interpolate(0.0f, 0.0f, null, null, 12, null);
        class_2960 class_29602 = class_2960.method_43902((String)"yet-another-minecraft-bingo", (String)"gui/card_colors.json");
        Intrinsics.checkNotNull((Object)class_29602);
        this.cardColorsId = class_29602;
        this.eventBus.register((IReturnEvent)packetEvents.getCardResetV1(), arg_0 -> BingoHudController._init_$lambda$0(this, arg_0));
        this.eventBus.register((IReturnEvent)packetEvents.getCardDisplayV1(), p0$clientPacket -> {
            this.onCardDisplayV1((ClientPacket<CardDisplayPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardDisplayV1(), p0$clientPacket -> {
            this.onCardDisplayV1((ClientPacket<CardDisplayPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardDisplayV2(), p0$clientPacket -> {
            this.onCardDisplayV2((ClientPacket<CardDisplayPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardUpdateV2(), p0$clientPacket -> {
            this.onCardUpdate((ClientPacket<CardUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardUpdateV3(), p0$clientPacket -> {
            this.onCardUpdate((ClientPacket<CardUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardUpdateV4(), p0$clientPacket -> {
            this.onCardUpdate((ClientPacket<CardUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardUpdateV5(), p0$clientPacket -> {
            this.onCardUpdate((ClientPacket<CardUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardUpdateV6(), p0$clientPacket -> {
            this.onCardUpdate((ClientPacket<CardUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardTilesV1(), p0$clientPacket -> {
            this.onCardTiles((ClientPacket<CardTilesPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardTilesV2(), p0$clientPacket -> {
            this.onCardTiles((ClientPacket<CardTilesPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardShuffledV1(), p0$clientPacket -> {
            this.onCardShuffled((ClientPacket<CardShuffledPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getCardCompletedV1(), arg_0 -> BingoHudController._init_$lambda$7(this, arg_0));
        this.eventBus.register((IReturnEvent)packetEvents.getScoreMessageV1(), p0$packet -> {
            this.onScoreMessage((ClientPacket<ScoreMessagePacket>)p0$packet);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getScoreMessageV2(), p0$packet -> {
            this.onScoreMessage((ClientPacket<ScoreMessagePacket>)p0$packet);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getScoreMessageV3(), p0$packet -> {
            this.onScoreMessage((ClientPacket<ScoreMessagePacket>)p0$packet);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameStatusV1(), arg_0 -> BingoHudController._init_$lambda$10(this, arg_0));
        this.eventBus.register((IReturnEvent)packetEvents.getGameMessageV1(), p0$packet -> {
            this.onGameMessage((ClientPacket<GameMessagePacket>)p0$packet);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameMessageClearV1(), arg_0 -> BingoHudController._init_$lambda$11(this, arg_0));
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV1(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV2(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV3(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV4(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV5(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV6(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV7(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getGameOverV8(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getReadyUpdateV1(), p0$clientPacket -> {
            this.onReadyUpdate((ClientPacket<ReadyUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getReadyUpdateV2(), p0$clientPacket -> {
            this.onReadyUpdate((ClientPacket<ReadyUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getReadyUpdateV3(), p0$clientPacket -> {
            this.onReadyUpdate((ClientPacket<ReadyUpdatePacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        this.eventBus.register((IReturnEvent)packetEvents.getTooltipV1(), arg_0 -> BingoHudController._init_$lambda$21(this, arg_0));
        this.eventBus.register(HudRenderEvent.Companion, arg_0 -> BingoHudController._init_$lambda$22(this, arg_0));
        this.eventBus.register(HudRenderEvent.Companion, arg_0 -> BingoHudController._init_$lambda$23(this, arg_0));
        this.eventBus.register(ClientServerEvent.Join.INSTANCE, arg_0 -> BingoHudController._init_$lambda$24(this, arg_0));
        this.eventBus.register(ClientServerEvent.Disconnect.INSTANCE, arg_0 -> BingoHudController._init_$lambda$25(this, arg_0));
        this.eventBus.register(ServerEvent.Started.INSTANCE, arg_0 -> BingoHudController._init_$lambda$26(this, arg_0));
        this.eventBus.register(ServerEvent.Stopped.INSTANCE, arg_0 -> BingoHudController._init_$lambda$27(this, arg_0));
        this.eventBus.register(InvalidateRenderStateEvent.Companion, arg_0 -> BingoHudController._init_$lambda$28(this, arg_0));
        this.eventBus.register(ClientTickEvent.End.INSTANCE, arg_0 -> BingoHudController._init_$lambda$29(this, packetEvents, arg_0));
        this.eventBus.register(ScreenEvent.AfterInit.INSTANCE, arg_0 -> BingoHudController._init_$lambda$30(this, arg_0));
        this.eventBus.register(ClientReloadEvent.Companion, arg_0 -> BingoHudController._init_$lambda$31(this, arg_0));
        this.eventBus.register(ClientConfigChangedEvent.INSTANCE, arg_0 -> BingoHudController._init_$lambda$32(this, arg_0));
    }

    private final void onCardHudClosed(Map<BingoTeamKey, Pair<Float, Float>> cardPositions) {
        Interpolate interpolate;
        Instant now = Instant.now();
        ClientCard clientCard = this.getSelectedCard();
        String string = clientCard != null ? clientCard.getTeamKey-fzvlhXk() : null;
        Pair<Float, Float> pair = cardPositions.get(string != null ? BingoTeamKey.box-impl(string) : null);
        if (pair == null) {
            return;
        }
        Pair<Float, Float> lastPosition = pair;
        Interpolate $this$onCardHudClosed_u24lambda_u240 = interpolate = this.interpolateCardX;
        boolean bl = false;
        $this$onCardHudClosed_u24lambda_u240.setFrom(((Number)lastPosition.getFirst()).floatValue());
        int $this$milliseconds$iv = 250;
        boolean $i$f$getMilliseconds = false;
        Duration duration2 = Duration.ofMillis($this$milliseconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        $this$onCardHudClosed_u24lambda_u240.setDuration(duration2);
        Intrinsics.checkNotNull((Object)now);
        $this$onCardHudClosed_u24lambda_u240.setStartedAt(now);
        Interpolate $this$onCardHudClosed_u24lambda_u241 = interpolate = this.interpolateCardY;
        boolean bl2 = false;
        $this$onCardHudClosed_u24lambda_u241.setFrom(((Number)lastPosition.getSecond()).floatValue());
        $this$milliseconds$iv = 250;
        $i$f$getMilliseconds = false;
        Duration duration3 = Duration.ofMillis($this$milliseconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
        $this$onCardHudClosed_u24lambda_u241.setDuration(duration3);
        $this$onCardHudClosed_u24lambda_u241.setStartedAt(now);
        Interpolate $this$onCardHudClosed_u24lambda_u242 = interpolate = this.interpolateCardScale;
        boolean bl3 = false;
        $this$onCardHudClosed_u24lambda_u242.setFrom(1.0f);
        $this$milliseconds$iv = 250;
        $i$f$getMilliseconds = false;
        Duration duration4 = Duration.ofMillis($this$milliseconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMillis(...)");
        $this$onCardHudClosed_u24lambda_u242.setDuration(duration4);
        $this$onCardHudClosed_u24lambda_u242.setStartedAt(now);
    }

    private final Pair<Float, Float> getCardPos() {
        float cardScale = Interpolate.get$default(this.interpolateCardScale, Interpolate.Easing.IN_OUT, null, 2, null);
        CardAlignment cardAlignment = this.config.getClient().getCardAlignment();
        int offsetX = this.config.getClient().getCardOffsetX() * (cardAlignment.getX() > 0 ? -1 : 1);
        int offsetY = this.config.getClient().getCardOffsetY() * (cardAlignment.getY() > 0 ? -1 : 1);
        float x = (float)cardAlignment.getX() * ((float)this.scaledWindowWidth - (float)122 * cardScale) + (float)offsetX;
        float y = (float)cardAlignment.getY() * ((float)this.scaledWindowHeight - (float)132 * cardScale) + (float)offsetY;
        this.interpolateCardX.setTo(x);
        this.interpolateCardY.setTo(y);
        return new Pair((Object)Float.valueOf(Interpolate.get$default(this.interpolateCardX, Interpolate.Easing.IN_OUT, null, 2, null)), (Object)Float.valueOf(Interpolate.get$default(this.interpolateCardY, Interpolate.Easing.IN_OUT, null, 2, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCardMouseOver() {
        Pair<Float, Float> pair = this.getCardPos();
        float x = ((Number)pair.component1()).floatValue();
        float y = ((Number)pair.component2()).floatValue();
        Vector2i it = this.client.getMouse();
        boolean bl = false;
        Pair pair2 = new Pair((Object)it.x, (Object)it.y);
        int mouseX = ((Number)pair2.component1()).intValue();
        int mouseY = ((Number)pair2.component2()).intValue();
        if (!(this.client.getScreen() instanceof class_408)) return false;
        float f = x + (float)122 * this.config.getClient().getCardScale();
        float f2 = mouseX;
        if (!(x <= f2)) return false;
        if (!(f2 <= f)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        f = y + (float)132 * this.config.getClient().getCardScale();
        f2 = mouseY;
        if (!(y <= f2)) return false;
        if (!(f2 <= f)) return false;
        return true;
    }

    public final boolean isCardFocused() {
        return this.config.getClient().getCardAlignment() != CardAlignment.BOTTOM_LEFT && this.isCardMouseOver();
    }

    private final ClientCard getSelectedCard() {
        ClientCard clientCard;
        Set<BingoTeamKey> teamKeys = this.state.getCards().keySet();
        if (teamKeys.isEmpty()) {
            return null;
        }
        String selectedTeam = this.state.getSelectedTeam-fzvlhXk();
        String string = selectedTeam;
        if (teamKeys.contains(string != null ? BingoTeamKey.box-impl(string) : null)) {
            String string2 = selectedTeam;
            clientCard = this.state.getCards().get(string2 != null ? BingoTeamKey.box-impl(string2) : null);
        } else {
            BingoTeamKey bingoTeamKey = (BingoTeamKey)CollectionsKt.firstOrNull((Iterable)this.state.getCards().keySet());
            String it = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            boolean bl = false;
            String string3 = it;
            clientCard = this.state.getCards().get(string3 != null ? BingoTeamKey.box-impl(string3) : null);
        }
        return clientCard;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHudCards(IDrawService drawService) {
        int xDirection;
        Interpolate interpolate;
        ClientCard clientCard = this.getSelectedCard();
        if (clientCard == null) {
            return;
        }
        ClientCard view = clientCard;
        this.state.setSelectedTeam-2vhwn7g(view.getTeamKey-fzvlhXk());
        Interpolate $this$drawHudCards_u24lambda_u240 = interpolate = this.interpolateCardScale;
        boolean bl = false;
        $this$drawHudCards_u24lambda_u240.setTo(this.config.getClient().getCardScale());
        float cardScale = Interpolate.get$default(interpolate, Interpolate.Easing.IN_OUT, null, 2, null);
        CardAlignment cardAlignment = this.config.getClient().getCardAlignment();
        Pair<Float, Float> pair = this.getCardPos();
        float x = ((Number)pair.component1()).floatValue();
        float y = ((Number)pair.component2()).floatValue();
        BingoEndFireworkRenderer bingoEndFireworkRenderer = this.fireworkRenderer;
        boolean bl2 = bingoEndFireworkRenderer != null ? bingoEndFireworkRenderer.isDone() : false;
        if (bl2) {
            this.fireworkRenderer = null;
        } else {
            BingoEndFireworkRenderer bingoEndFireworkRenderer2 = this.fireworkRenderer;
            if (bingoEndFireworkRenderer2 != null) {
                bingoEndFireworkRenderer2.render(drawService, (int)x + 61, (int)y + 66, this.state.getNow());
            }
        }
        Vector2i it = drawService.getMouse();
        boolean $i$a$-let-BingoHudController$drawHudCards$232 = false;
        Pair pair2 = new Pair((Object)it.x, (Object)it.y);
        int mouseX = ((Number)pair2.component1()).intValue();
        int mouseY = ((Number)pair2.component2()).intValue();
        ClientCardRenderer $i$a$-let-BingoHudController$drawHudCards$232 = this.renderer;
        int n = this.config.getClient().getCardOverlap().getZ();
        boolean bl3 = this.isCardMouseOver();
        boolean n2 = this.isCardFocused();
        ClientCardRenderer.draw$default($i$a$-let-BingoHudController$drawHudCards$232, drawService, view, x, y, n, cardScale, mouseX, mouseY, n2, bl3, false, 1024, null);
        if (this.interpolateCardX.isDone()) {
            BingoMessageRenderer.drawMessages$default(this.itemScoredRenderer, drawService, (int)x, (int)y + (int)((float)132 * cardScale * (float)(1 - this.config.getClient().getCardAlignment().getY())), this.config.getClient().getCardOverlap().getZ(), this.config.getClient().getMessageScale(), this.config.getClient().getCardAlignment(), 0.0f, null, 192, null);
        }
        int n3 = xDirection = cardAlignment.getX() > 0 ? -1 : 1;
        if (this.config.getClient().getShowMultipleCards()) {
            List remainingViews = CollectionsKt.minus((Iterable)this.state.getCards().values(), (Object)view);
            Iterator iterator = ((Iterable)remainingViews).iterator();
            boolean bl4 = false;
            while (iterator.hasNext()) {
                void var14_22;
                void i = var14_22++;
                ClientCard remainingView = (ClientCard)iterator.next();
                float cardX = x + (float)((i + true) * xDirection * 122) * cardScale;
                float cardEndX = x + (float)((i + 2) * xDirection * 122) * cardScale;
                if (cardEndX < 0.0f || cardEndX > (float)drawService.getWindow().getScaledWindowWidth()) continue;
                ClientCardRenderer.draw$default(this.renderer, drawService, remainingView, cardX, y, this.config.getClient().getCardOverlap().getZ(), cardScale, 0, 0, false, false, false, 1984, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHudInfo(IDrawService drawService) {
        Instant tooltipStartedAt;
        Instant instant;
        List<IText> tooltipText;
        Object it;
        Iterator $this$flatMap$iv;
        this.readyHudRenderer.drawReadyHud(drawService, drawService.getWindow().getScaledWindowWidth() / 2 - 50, 40, 100);
        Instant now = this.state.getNow();
        TooltipPacket tooltipPacket = this.state.getTooltip();
        Object object = tooltipPacket;
        if (object != null && (object = ((TooltipPacket)object).getText()) != null) {
            Object tooltipText2 = object;
            boolean bl = false;
            v1 = tooltipPacket.getClientWrappedText();
            if (v1 == null) {
                void $this$flatMapTo$iv$iv;
                $this$flatMap$iv = (Iterable)tooltipText2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    IText line = (IText)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = drawService.getFont().wrapLines(line, 200);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                it = $this$flatMap$iv = (List)destination$iv$iv;
                boolean bl3 = false;
                tooltipPacket.setClientWrappedText((List<? extends IText>)it);
                v1 = $this$flatMap$iv;
            }
        } else {
            v1 = tooltipText = null;
        }
        if ((instant = this.state.getTooltipStartedAt()) == null) {
            instant = tooltipStartedAt = Instant.MIN;
        }
        if (tooltipText != null && this.client.getScreen() == null) {
            Comparable comparable;
            $this$flatMap$iv = ((Iterable)tooltipText).iterator();
            if (!$this$flatMap$iv.hasNext()) {
                comparable = null;
            } else {
                it = (IText)$this$flatMap$iv.next();
                boolean bl = false;
                Object object2 = drawService.getFont().getTextWidth((IText)it);
                while ($this$flatMap$iv.hasNext()) {
                    Object it2 = (IText)$this$flatMap$iv.next();
                    $i$a$-maxOfOrNull-BingoHudController$drawHudInfo$tooltipSize$1 = false;
                    it2 = drawService.getFont().getTextWidth((IText)it2);
                    if (object2.compareTo(it2) >= 0) continue;
                    object2 = it2;
                }
                comparable = object2;
            }
            Integer n = (Integer)comparable;
            int tooltipSize = n != null ? n : 0;
            int tooltipX = drawService.getWindow().getScaledWindowWidth() / 2 - tooltipSize / 2 - 12;
            int tooltipY = (int)((double)drawService.getWindow().getScaledWindowHeight() * 0.5) + 18 + 12;
            Intrinsics.checkNotNull((Object)tooltipStartedAt);
            Duration duration2 = DurationKt.minus(now, tooltipStartedAt);
            int $this$milliseconds$iv = 250;
            boolean $i$f$getMilliseconds = false;
            Duration duration3 = Duration.ofMillis($this$milliseconds$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
            double fadeIn = RangesKt.coerceIn((double)DurationKt.div(duration2, duration3), (double)0.0, (double)1.0);
            Instant instant2 = tooltipPacket.getCreatedAt();
            int $this$milliseconds$iv2 = 100;
            boolean $i$f$getMilliseconds2 = false;
            Duration duration4 = Duration.ofMillis($this$milliseconds$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMillis(...)");
            Instant instant3 = instant2.plus(duration4);
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"plus(...)");
            Duration duration5 = DurationKt.minus(now, instant3);
            int $this$milliseconds$iv3 = 250;
            boolean $i$f$getMilliseconds3 = false;
            Duration duration6 = Duration.ofMillis($this$milliseconds$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofMillis(...)");
            double fadeOut = 1.0 - RangesKt.coerceIn((double)DurationKt.div(duration5, duration6), (double)0.0, (double)1.0);
            drawService.setShaderColor(1.0f, 1.0f, 1.0f, (float)(fadeIn * fadeOut));
            drawService.drawTooltip(tooltipText, tooltipX, tooltipY);
            drawService.drawTooltipImmediate();
            drawService.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (fadeOut <= 0.0) {
                this.state.setTooltip(null);
                this.state.setTooltipStartedAt(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateGameOverViews() {
        void $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        BingoHudState.GameOver gameOver = this.state.getGameOver();
        if (gameOver == null) {
            return;
        }
        BingoHudState.GameOver gameOver2 = gameOver;
        Iterable iterable = CollectionsKt.plus(this.state.getCards().values(), (Iterable)gameOver2.getCards());
        BingoHudState.GameOver gameOver3 = gameOver2;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientCardBase it = (ClientCardBase)element$iv$iv;
            boolean bl = false;
            if (!(it.getTeamKey-fzvlhXk() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            ClientCardBase it = (ClientCardBase)e$iv;
            boolean bl = false;
            String string = it.getTeamKey-fzvlhXk();
            if (string == null) {
                string = null;
            }
            if (!set$iv.add(key$iv = string)) continue;
            list$iv.add(e$iv);
        }
        gameOver3.setCards(list$iv);
    }

    private final void onGameOver(ClientPacket<GameOverPacket> clientPacket) {
        GameOverPacket packet = clientPacket.component1();
        BingoHudState.GameOver gameOver = this.state.getGameOver();
        if (gameOver == null) {
            gameOver = new BingoHudState.GameOver(packet, CollectionsKt.emptyList(), null, false, 12, null);
        }
        BingoHudState.GameOver gameOver2 = gameOver;
        this.state.setGameOver(gameOver2);
        this.updateGameOverViews();
        if (!packet.isUpdate()) {
            ClientCard clientCard = this.getSelectedCard();
            this.client.setScreen(this.endScreenFactory.create-UI-dlyM(gameOver2, clientCard != null ? clientCard.getTeamKey-fzvlhXk() : null, this.getCardPos(), false, (Function1<? super BingoHudScreen, Unit>)((Function1)arg_0 -> BingoHudController.onGameOver$lambda$0(this, arg_0))));
        }
    }

    private final void onMessagePacket(GameMessagePacket packet) {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        BingoHudState.ScoreMessage scoreMessage = new BingoHudState.ScoreMessage(instant, packet, null, 0, 12, null);
        if (!packet.isUpdate()) {
            this.state.getMessages().add(scoreMessage);
        }
        this.state.getPastMessages().removeIf(arg_0 -> BingoHudController.onMessagePacket$lambda$1(arg_0 -> BingoHudController.onMessagePacket$lambda$0(packet, arg_0), arg_0));
        this.state.getPastMessages().add(scoreMessage);
        List<BingoHudState.ScoreMessage> $this$sortBy$iv = this.state.getPastMessages();
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BingoHudState.ScoreMessage it = (BingoHudState.ScoreMessage)a;
                    boolean bl = false;
                    Comparable comparable = it.getPacket().getTimeElapsed();
                    it = (BingoHudState.ScoreMessage)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getPacket().getTimeElapsed());
                }
            });
        }
        this.eventBus.emit(HudStateChangedEvent.INSTANCE, Unit.INSTANCE);
    }

    private final void onScoreMessage(ClientPacket<ScoreMessagePacket> packet) {
        if (packet.getPacket().isViewerOnTeam() || this.config.getClient().getMessageFromOtherTeams()) {
            this.onMessagePacket(packet.getPacket().toGameMessagePacket());
        }
    }

    private final void onGameMessage(ClientPacket<GameMessagePacket> packet) {
        this.onMessagePacket(packet.getPacket());
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardUpdate(ClientPacket<CardUpdatePacket> clientPacket) {
        Object object;
        void $this$getOrPut$iv;
        CardUpdatePacket packet = clientPacket.getPacket();
        Map<BingoTeamKey, ClientCardBase> map = this.state.getCards();
        String string = packet.getView().getTeamKey-fzvlhXk();
        BingoTeamKey key$iv = string != null ? BingoTeamKey.box-impl(string) : null;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ClientCardBase answer$iv = ClientCardManager.newCard$default(this.clientCardManager, packet.getView(), 0.0f, 2, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ClientCardBase clientCard = (ClientCardBase)object;
        clientCard.setView(packet.getView());
        this.updateGameOverViews();
    }

    /*
     * Unable to fully structure code
     */
    private final void onReadyUpdate(ClientPacket<ReadyUpdatePacket> clientPacket) {
        packet = clientPacket.getPacket();
        v0 = this.state.getReady();
        v1 = v0 != null ? v0.getCanSendReady() == packet.getCanSendReady() : false;
        if (!v1) ** GOTO lbl-1000
        v2 = this.state.getReady();
        v3 = v2 != null ? v2.isReady() == packet.isReady() : false;
        if (!v3) ** GOTO lbl-1000
        v4 = this.state.getReady();
        if (!(v4 != null ? v4.isRunning() == packet.isRunning() : false)) lbl-1000:
        // 3 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        isStateChanged = v5;
        this.state.setReady(packet);
        if (isStateChanged) {
            this.eventBus.emit(HudStateChangedEvent.INSTANCE, Unit.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardDisplay(Map<BingoTeamKey, CardDisplay> displays) {
        Iterator<Map.Entry<BingoTeamKey, ClientCardBase>> cardsIterator = this.state.getCards().entrySet().iterator();
        Iterator<Map.Entry<BingoTeamKey, Object>> iterator = cardsIterator;
        while (iterator.hasNext()) {
            Map.Entry<BingoTeamKey, ClientCardBase> entry = iterator.next();
            BingoTeamKey bingoTeamKey = entry.getKey();
            String key2 = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            ClientCardBase card = entry.getValue();
            String string = key2;
            if (displays.containsKey(string != null ? BingoTeamKey.box-impl(string) : null)) continue;
            Object object = this.state.getGameOver();
            if (!(object != null && (object = ((BingoHudState.GameOver)object).getCards()) != null ? object.contains(card) : false)) {
                card.close();
            }
            cardsIterator.remove();
        }
        for (Map.Entry<BingoTeamKey, Object> entry : displays.entrySet()) {
            Object object;
            void $this$getOrPut$iv;
            BingoTeamKey bingoTeamKey = entry.getKey();
            String key2 = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            CardDisplay display2 = (CardDisplay)entry.getValue();
            Map<BingoTeamKey, ClientCardBase> map = this.state.getCards();
            String string = key2;
            BingoTeamKey key$iv = string != null ? BingoTeamKey.box-impl(string) : null;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ClientCardBase answer$iv = ClientCardManager.newCard$default(this.clientCardManager, new CardView(key2, display2, new ArrayList(), null), 0.0f, 2, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ClientCardBase clientCard = (ClientCardBase)object;
            clientCard.setView(CardView.copy-LF857-w$default(clientCard.getView(), null, display2, null, 5, null));
            clientCard.setColors(this.state.getCardColors().getTeamColors-vRxwntw(key2, display2.getTeamColor()));
        }
        Iterable $this$forEach$iv = displays.keySet();
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            BingoTeamKey bingoTeamKey = (BingoTeamKey)element$iv;
            String it = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            boolean bl2 = false;
            this.clientCardManager.markDirty-2vhwn7g(it);
        }
        this.updateGameOverViews();
        if (displays.isEmpty() && this.state.getGameStatus().isDefaultInstance()) {
            this.state.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardDisplayV1(ClientPacket<CardDisplayPacket> clientPacket) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<BingoTeamKey, CardDisplay> map = clientPacket.getPacket().getDisplay();
        BingoHudController bingoHudController = this;
        boolean $i$f$mapValues = false;
        void var4_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            CardDisplay cardDisplay;
            CardDisplay cardDisplay2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            BingoTeamKey bingoTeamKey = (BingoTeamKey)entry2.getKey();
            String key2 = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            CardDisplay display2 = (CardDisplay)entry2.getValue();
            String string = key2;
            ClientCardBase clientCardBase = this.state.getCards().get(string != null ? BingoTeamKey.box-impl(string) : null);
            CardDisplay cardDisplay3 = clientCardBase != null && (cardDisplay2 = clientCardBase.getDisplay()) != null && (cardDisplay = CardDisplay.copy$default(cardDisplay2, display2.getTeamColor(), null, null, 6, null)) != null ? cardDisplay : display2;
            map3.put(k, cardDisplay3);
        }
        bingoHudController.onCardDisplay(destination$iv$iv$iv);
    }

    private final void onCardDisplayV2(ClientPacket<CardDisplayPacket> clientPacket) {
        this.onCardDisplay(clientPacket.getPacket().getDisplay());
    }

    private final void scheduleCardUpdates-2vhwn7g(String teamKey2) {
        long delay = 500L;
        long l = ProgressionUtilKt.getProgressionLastElement((long)500L, (long)4500L, (long)500L);
        if (delay <= l) {
            while (true) {
                CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS, this.client.getExecutor()).execute(() -> BingoHudController.scheduleCardUpdates_2vhwn7g$lambda$0(this, teamKey2));
                if (delay == l) break;
                delay += 500L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardTiles(ClientPacket<CardTilesPacket> clientPacket) {
        boolean bl;
        List tiles;
        ClientCardBase clientCard;
        CardTilesPacket packet;
        block12: {
            Object object;
            int n;
            void $this$getOrPut$iv;
            packet = clientPacket.getPacket();
            Map<BingoTeamKey, ClientCardBase> map = this.state.getCards();
            String string = packet.getTeamKey-fzvlhXk();
            BingoTeamKey key$iv22 = string != null ? BingoTeamKey.box-impl(string) : null;
            boolean $i$f$getOrPut22 = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv22);
            if (value$iv == null) {
                n = 0;
                ClientCardBase answer$iv = ClientCardManager.newCard$default(this.clientCardManager, new CardView(packet.getTeamKey-fzvlhXk(), new CardDisplay(null, null, null, 7, null), new ArrayList(), null), 0.0f, 2, null);
                $this$getOrPut$iv.put(key$iv22, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            clientCard = (ClientCardBase)object;
            int key$iv22 = 25;
            ArrayList<CardTile> $i$f$getOrPut22 = new ArrayList<CardTile>(key$iv22);
            for (int i = 0; i < key$iv22; ++i) {
                Instant instant;
                CardTile newTile;
                void it;
                int answer$iv = n = i;
                ArrayList<CardTile> arrayList = $i$f$getOrPut22;
                boolean bl2 = false;
                CardTile existingTile = (CardTile)CollectionsKt.getOrNull(clientCard.getTiles(), (int)it);
                CardTile cardTile = packet.getTiles().get((int)it);
                if (cardTile == null && (cardTile = existingTile) == null) {
                    cardTile = newTile = CardTile.Companion.getEMPTY();
                }
                if (!packet.getShouldNotify()) {
                    instant = null;
                } else {
                    CardTile cardTile2 = existingTile;
                    if (!Intrinsics.areEqual((Object)newTile.getId(), (Object)(cardTile2 != null ? cardTile2.getId() : null))) {
                        instant = this.state.getNow();
                    } else {
                        CardTile cardTile3 = existingTile;
                        instant = cardTile3 != null ? cardTile3.getUpdatedAt() : null;
                    }
                }
                newTile.setUpdatedAt(instant);
                arrayList.add(newTile);
            }
            tiles = $i$f$getOrPut22;
            Iterable $this$any$iv = tiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CardTile it = (CardTile)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getUpdatedAt(), (Object)this.state.getNow())) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            this.scheduleCardUpdates-2vhwn7g(packet.getTeamKey-fzvlhXk());
        }
        clientCard.setView(CardView.copy-LF857-w$default(clientCard.getView(), null, null, tiles, 3, null));
        this.updateGameOverViews();
        this.clientCardManager.markDirty-2vhwn7g(packet.getTeamKey-fzvlhXk());
    }

    private final void onCardShuffled(ClientPacket<CardShuffledPacket> clientPacket) {
        CardShuffledPacket packet = clientPacket.getPacket();
        String string = packet.getTeamKey-fzvlhXk();
        ClientCardBase clientCard = this.state.getCards().get(string != null ? BingoTeamKey.box-impl(string) : null);
        if (clientCard != null && DurationKt.minus(this.state.getNow(), clientCard.getShuffledAt()).compareTo(ClientCardBufferRenderer.Companion.getSHUFFLE_DURATION()) > 0) {
            clientCard.setShuffledAt(this.state.getNow());
            clientCard.setShufflePositions(CollectionsKt.shuffled((Iterable)clientCard.getShufflePositions()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void loadCardColors(class_3300 manager) {
        v0 = this.state;
        v1 = manager.method_14486(this.cardColorsId);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getResource(...)");
        var2_2 = (class_3298)OptionalsKt.getOrNull((Optional)v1);
        if (var2_2 == null || (var3_3 = var2_2.method_14482()) == null) ** GOTO lbl-1000
        var5_4 = var3_3;
        var12_6 = v0;
        var6_7 = null;
        try {
            it = (InputStream)var5_4;
            $i$a$-use-BingoHudController$loadCardColors$1 = false;
            var9_13 = JsonKt.getJson();
            stream$iv = it;
            $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            it = (BingoCardColors)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)BingoCardColors.Companion.serializer()), (InputStream)stream$iv);
        }
        catch (Throwable $i$a$-use-BingoHudController$loadCardColors$1) {
            var6_7 = $i$a$-use-BingoHudController$loadCardColors$1;
            throw $i$a$-use-BingoHudController$loadCardColors$1;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var5_4, (Throwable)var6_7);
        }
        v0 = var12_6;
        var4_17 = it;
        if (var4_17 != null) {
            v2 = var4_17;
        } else lbl-1000:
        // 2 sources

        {
            v2 = new BingoCardColors(null, null, 3, null);
        }
        v0.setCardColors((BingoCardColors)v2);
        for (ClientCardBase card : this.state.getCards().values()) {
            card.setColors(this.state.getCardColors().getTeamColors-vRxwntw(card.getTeamKey-fzvlhXk(), card.getDisplay().getTeamColor()));
            card.getDisplay().setClientTeamName(null);
            $this$forEach$iv = card.getTiles();
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                tile = (CardTile)element$iv;
                $i$a$-forEach-BingoHudController$loadCardColors$2 = false;
                tile.setClientTooltip(null);
            }
            this.clientCardManager.markDirty-2vhwn7g(card.getTeamKey-fzvlhXk());
        }
    }

    private static final Unit onGameOver$lambda$0(BingoHudController this$0, BingoHudScreen it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onCardHudClosed(it.getCardPositions());
        return Unit.INSTANCE;
    }

    private static final boolean onMessagePacket$lambda$0(GameMessagePacket $packet, BingoHudState.ScoreMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getPacket().getId(), (Object)$packet.getId());
    }

    private static final boolean onMessagePacket$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void scheduleCardUpdates_2vhwn7g$lambda$0(BingoHudController this$0, String $teamKey) {
        this$0.clientCardManager.markDirty-2vhwn7g($teamKey);
    }

    private static final Unit _init_$lambda$0(BingoHudController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.state.reset();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(BingoHudController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((CardCompletedPacket)it.getPacket()).isWinner()) {
            this$0.fireworkRenderer = new BingoEndFireworkRenderer(this$0.text, null, (int)((float)100 * this$0.config.getClient().getCardScale()), 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(BingoHudController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.state.setGameStatus((GameStatusPacket)it.getPacket());
        this$0.eventBus.emit(HudStateChangedEvent.INSTANCE, Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(BingoHudController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.state.clearMessages();
        this$0.eventBus.emit(HudStateChangedEvent.INSTANCE, Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$21(BingoHudController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.state.setTooltip((TooltipPacket)it.getPacket());
        if (this$0.state.getTooltipStartedAt() == null) {
            this$0.state.setTooltipStartedAt(((TooltipPacket)it.getPacket()).getCreatedAt());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$22(BingoHudController this$0, HudRenderEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BingoHudState bingoHudState = this$0.state;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        bingoHudState.setNow(instant);
        this$0.scaledWindowWidth = it.getDrawService().getWindow().getScaledWindowWidth();
        this$0.scaledWindowHeight = it.getDrawService().getWindow().getScaledWindowHeight();
        Iterable $this$forEach$iv = this$0.state.getCards().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientCardBase card = (ClientCardBase)element$iv;
            boolean bl = false;
            ClientCardManager.resizeCard$default(this$0.clientCardManager, card, 0.0f, 2, null);
            this$0.clientCardManager.resizeCard(card.getGuiCard(), 1.0f);
        }
        this$0.clientCardManager.updateCards();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$23(BingoHudController this$0, HudRenderEvent it) {
        String string;
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.optionsAccessor.isHudHidden()) {
            return Unit.INSTANCE;
        }
        boolean isDebugEnabled = this$0.optionsAccessor.isDebugEnabled();
        boolean isChatOpen = this$0.client.getScreen() instanceof class_408;
        boolean isPlayerListOpen = this$0.optionsAccessor.isPlayerListPressed();
        class_437 class_4372 = this$0.client.getScreen();
        boolean bl = class_4372 != null && (clazz = class_4372.getClass()) != null && (string = clazz.getPackageName()) != null ? StringsKt.startsWith$default((String)string, (String)"me.jfenn.bingo", (boolean)false, (int)2, null) : false;
        if (bl) {
            return Unit.INSTANCE;
        }
        if (!(!this$0.config.getClient().getEnableHud() || this$0.config.getClient().getHideOnF3() && isDebugEnabled || this$0.config.getClient().getHideOnChat() && isChatOpen)) {
            this$0.drawHudCards(it.getDrawService());
        }
        if (!(isDebugEnabled || isChatOpen || isPlayerListOpen)) {
            this$0.drawHudInfo(it.getDrawService());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$24(BingoHudController this$0, ClientServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.execute((Function0<Unit>)((Function0)() -> BingoHudController.lambda$24$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$24$0(BingoHudController this$0) {
        this$0.state.resetAll();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$25(BingoHudController this$0, ClientServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.execute((Function0<Unit>)((Function0)() -> BingoHudController.lambda$25$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$25$0(BingoHudController this$0) {
        this$0.state.resetAll();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$26(BingoHudController this$0, ServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.execute((Function0<Unit>)((Function0)() -> BingoHudController.lambda$26$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$26$0(BingoHudController this$0) {
        this$0.state.reset();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$27(BingoHudController this$0, ServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.execute((Function0<Unit>)((Function0)() -> BingoHudController.lambda$27$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$27$0(BingoHudController this$0) {
        this$0.state.resetAll();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$28(BingoHudController this$0, InvalidateRenderStateEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.execute((Function0<Unit>)((Function0)() -> BingoHudController.lambda$28$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$28$0(BingoHudController this$0) {
        this$0.state.reset();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$29(BingoHudController this$0, ClientPacketEvents $packetEvents, ClientTickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.client.isPaused()) {
            return Unit.INSTANCE;
        }
        boolean openCardKeyWasPressed = false;
        while (this$0.openCardKey.wasPressed()) {
            openCardKeyWasPressed = true;
        }
        boolean shouldSendReady = false;
        boolean shouldOpenCard = false;
        if (this$0.cardHudWasClicked && this$0.client.getScreen() instanceof class_408) {
            shouldOpenCard = true;
            this$0.cardHudWasClicked = false;
        }
        if (openCardKeyWasPressed && !this$0.openCardKeyAlreadyPressed) {
            ReadyUpdatePacket readyUpdatePacket = this$0.state.getReady();
            boolean bl = readyUpdatePacket != null ? readyUpdatePacket.getCanSendReady() : false;
            if (bl && this$0.optionsAccessor.isSneakPressed()) {
                shouldSendReady = true;
            } else {
                shouldOpenCard = true;
            }
            this$0.openCardKeyAlreadyPressed = true;
        } else if (!this$0.openCardKey.isPressed()) {
            this$0.openCardKeyAlreadyPressed = false;
        }
        if (shouldSendReady) {
            ReadyUpdatePacket readyUpdatePacket = this$0.state.getReady();
            boolean bl = readyUpdatePacket != null ? readyUpdatePacket.isRunning() : false;
            if (bl) {
                ReadyUpdatePacket readyUpdatePacket2 = this$0.state.getReady();
                $packetEvents.getReadySetV1().send(new SetReadyPacket(!(readyUpdatePacket2 != null ? readyUpdatePacket2.isReady() : false)));
            }
        }
        if (shouldOpenCard) {
            ClientCard clientCard;
            BingoHudState.GameOver gameOver = this$0.state.getGameOver();
            if (gameOver != null || !this$0.state.getCards().isEmpty()) {
                clientCard = this$0.getSelectedCard();
            } else {
                this$0.client.getPlayer().sendHotbarMessage(this$0.text.string(StringKey.CardNoCards));
                return Unit.INSTANCE;
            }
            class_437 hudScreen = this$0.endScreenFactory.create-UI-dlyM(gameOver, clientCard != null ? clientCard.getTeamKey-fzvlhXk() : null, this$0.getCardPos(), true, (Function1<? super BingoHudScreen, Unit>)((Function1)arg_0 -> BingoHudController.lambda$29$0(this$0, arg_0)));
            this$0.client.setScreen(hudScreen);
        }
        if (this$0.toggleHudKey.wasPressed()) {
            this$0.config.getClient().setEnableHud(!this$0.config.getClient().getEnableHud());
            this$0.configService.writeConfig(this$0.config);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$29$0(BingoHudController this$0, BingoHudScreen it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onCardHudClosed(it.getCardPositions());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$30(BingoHudController this$0, ScreenEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getScreen().getScreen() instanceof class_408) {
            it.getScreen().onAfterLeftClick((Function1<? super Vector2i, Unit>)((Function1)arg_0 -> BingoHudController.lambda$30$0(this$0, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$30$0(BingoHudController this$0, Vector2i it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.isCardFocused()) {
            this$0.cardHudWasClicked = true;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$31(BingoHudController this$0, ClientReloadEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.loadCardColors(it.getResourceManager());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$32(BingoHudController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.state.getCards().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientCardBase it2 = (ClientCardBase)element$iv;
            boolean bl = false;
            this$0.clientCardManager.markDirty-2vhwn7g(it2.getTeamKey-fzvlhXk());
        }
        return Unit.INSTANCE;
    }
}

