/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.menu;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.Sounds;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.datapack.LobbyWorldService;
import me.jfenn.bingo.common.event.InteractionEntityEvents;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.menu.MenuInstance;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.scope.ScopeManager;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.BingoTeamPreset;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.Vector3dKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.EntityType;
import me.jfenn.bingo.platform.IEntityManager;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IInteractionEntity;
import me.jfenn.bingo.platform.ILevelStorage;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.ITextDisplayEntity;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.block.IBlockState;
import me.jfenn.bingo.platform.block.IWallSignBlockState;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.EntityLoadEvent;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.particle.IParticleFactory;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2435;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4d;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001YB\u0087\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\r\u0010%\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010*\u001a\b\u0012\u0004\u0012\u00020'0)2\b\b\u0002\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\b\u0012\u0004\u0012\u00020,0)H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0019\u00102\u001a\u0004\u0018\u0001012\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b2\u00103J#\u00106\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u000205042\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020$2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b8\u00109J7\u0010D\u001a\u00020$2\u0006\u00100\u001a\u00020/2\u0006\u0010;\u001a\u00020:2\u0006\u0010=\u001a\u00020<2\u0006\u0010?\u001a\u00020>2\u0006\u0010A\u001a\u00020@H\u0002\u00a2\u0006\u0004\bB\u0010CR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010ER\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010FR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010GR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010HR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010IR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010JR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010KR\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010LR\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010MR\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010NR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010OR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010PR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010QR\u0018\u0010S\u001a\u0004\u0018\u00010R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010X\u00a8\u0006Z"}, d2={"Lme/jfenn/bingo/common/menu/MenuController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/scope/ScopeManager;", "scopeManager", "Lorg/slf4j/Logger;", "log", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/IEntityManager;", "entityManager", "Lme/jfenn/bingo/common/event/InteractionEntityEvents;", "interactionEntityEvents", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/ILevelStorage;", "levelStorage", "Lme/jfenn/bingo/platform/particle/IParticleFactory;", "particleFactory", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "taskExecutor", "Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "lobbyWorldService", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/scope/ScopeManager;Lorg/slf4j/Logger;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/IEntityManager;Lme/jfenn/bingo/common/event/InteractionEntityEvents;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/ILevelStorage;Lme/jfenn/bingo/platform/particle/IParticleFactory;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/common/datapack/LobbyWorldService;)V", "", "prepareLobbyFiles", "()V", "", "margin", "Lkotlin/sequences/Sequence;", "everyChunkIndex", "(I)Lkotlin/sequences/Sequence;", "Lme/jfenn/bingo/platform/block/BlockPosition;", "searchLobbyBlocks", "()Lkotlin/sequences/Sequence;", "Lnet/minecraft/class_3218;", "lobbyWorld", "Lorg/joml/Matrix4d;", "getMenuPosition", "(Lnet/minecraft/class_3218;)Lorg/joml/Matrix4d;", "Lkotlin/Pair;", "", "getLobbySpawnPosition", "(Lnet/minecraft/class_3218;)Lkotlin/Pair;", "spawnTeamEntities", "(Lnet/minecraft/class_3218;)V", "Lorg/joml/Vector3d;", "position", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "teamKey", "Lme/jfenn/bingo/common/team/BingoTeamPreset;", "teamPreset", "", "instanceTag", "spawnTeamEntity-1xyU8Nk", "(Lnet/minecraft/class_3218;Lorg/joml/Vector3d;Ljava/lang/String;Lme/jfenn/bingo/common/team/BingoTeamPreset;Ljava/lang/String;)V", "spawnTeamEntity", "Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/IEntityManager;", "Lme/jfenn/bingo/common/event/InteractionEntityEvents;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/ILevelStorage;", "Lme/jfenn/bingo/platform/particle/IParticleFactory;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "Lme/jfenn/bingo/common/menu/MenuInstance;", "menu", "Lme/jfenn/bingo/common/menu/MenuInstance;", "Lme/jfenn/bingo/koin/core/scope/Scope;", "koinScope", "Lme/jfenn/bingo/koin/core/scope/Scope;", "Ljava/lang/String;", "Cache", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMenuController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MenuController.kt\nme/jfenn/bingo/common/menu/MenuController\n+ 2 Logger.kt\nme/jfenn/bingo/common/utils/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n10#2,8:421\n10#2,5:430\n16#2,2:444\n10#2,8:446\n10#2,8:454\n1#3:429\n1285#4,2:435\n1299#4,4:437\n1740#4,3:441\n774#4:462\n865#4,2:463\n1869#4,2:465\n*S KotlinDebug\n*F\n+ 1 MenuController.kt\nme/jfenn/bingo/common/menu/MenuController\n*L\n166#1:421,8\n247#1:430,5\n247#1:444,2\n304#1:446,8\n336#1:454,8\n256#1:435,2\n256#1:437,4\n261#1:441,3\n148#1:462\n148#1:463,2\n149#1:465,2\n*E\n"})
public final class MenuController
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IEntityManager entityManager;
    @NotNull
    private final InteractionEntityEvents interactionEntityEvents;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final ILevelStorage levelStorage;
    @NotNull
    private final IParticleFactory particleFactory;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;
    @NotNull
    private final IExecutors.IServerTaskExecutor taskExecutor;
    @NotNull
    private final LobbyWorldService lobbyWorldService;
    @Nullable
    private MenuInstance menu;
    @NotNull
    private final Scope koinScope;
    @NotNull
    private final String instanceTag;

    public MenuController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull ScopeManager scopeManager, @NotNull Logger log, @NotNull MinecraftServer server, @NotNull IEntityManager entityManager, @NotNull InteractionEntityEvents interactionEntityEvents, @NotNull BingoState state, @NotNull ScopedData data, @NotNull TeamService teamService, @NotNull TextProvider text, @NotNull ILevelStorage levelStorage, @NotNull IParticleFactory particleFactory, @NotNull IServerWorldFactory serverWorldFactory, @NotNull IExecutors.IServerTaskExecutor taskExecutor, @NotNull LobbyWorldService lobbyWorldService) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)interactionEntityEvents, (String)"interactionEntityEvents");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)levelStorage, (String)"levelStorage");
        Intrinsics.checkNotNullParameter((Object)particleFactory, (String)"particleFactory");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)lobbyWorldService, (String)"lobbyWorldService");
        this.log = log;
        this.server = server;
        this.entityManager = entityManager;
        this.interactionEntityEvents = interactionEntityEvents;
        this.state = state;
        this.data = data;
        this.teamService = teamService;
        this.text = text;
        this.levelStorage = levelStorage;
        this.particleFactory = particleFactory;
        this.serverWorldFactory = serverWorldFactory;
        this.taskExecutor = taskExecutor;
        this.lobbyWorldService = lobbyWorldService;
        Scope scope = scopeManager.getScope(this.server);
        Intrinsics.checkNotNull((Object)scope);
        this.koinScope = scope;
        this.instanceTag = "bingo-" + UUID.randomUUID();
        if (this.state.isLobbyMode()) {
            this.prepareLobbyFiles();
        }
        ScopedEvents.onEnter$default(events, GameState.PREGAME, false, arg_0 -> MenuController._init_$lambda$0(this, arg_0), 2, null);
        eventBus.register(EntityLoadEvent.Companion, arg_0 -> MenuController._init_$lambda$1(this, arg_0));
        eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> MenuController._init_$lambda$2(this, arg_0));
        events.onStateChange((Function1<? super StateChangedEvent, Unit>)((Function1)arg_0 -> MenuController._init_$lambda$3(this, arg_0)));
        events.onChangeOptions((Function1<? super Unit, Unit>)((Function1)arg_0 -> MenuController._init_$lambda$4(this, arg_0)));
        events.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> MenuController._init_$lambda$5(this, arg_0)));
        events.onPlayerDisconnect((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> MenuController._init_$lambda$6(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void prepareLobbyFiles() {
        void $this$measureTime$iv;
        Logger logger = this.log;
        String message$iv = "[MenuController] Preparing the BINGO lobby...";
        boolean $i$f$measureTime = false;
        long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        $this$measureTime$iv.info(message$iv);
        try {
            boolean bl = false;
            Path path = this.levelStorage.getLevelSaveDir(ConstantsKt.getLOBBY_WORLD_ID());
            if (path == null) {
                MenuController $this$prepareLobbyFiles_u24lambda_u240_u240 = this;
                boolean bl2 = false;
                $this$prepareLobbyFiles_u24lambda_u240_u240.log.error("Unable to find world storage dir for " + ConstantsKt.getLOBBY_WORLD_ID());
            } else {
                Path storageDir = path;
                Instant lobbyWorldModified = this.lobbyWorldService.readLastModified();
                if (lobbyWorldModified.isAfter(Cache.INSTANCE.getLobbyWorldModified())) {
                    Cache.INSTANCE.setSpawnPosition(null);
                    Cache.INSTANCE.setMenuPosition(null);
                    Cache.INSTANCE.setTeamPositions(null);
                    Cache.INSTANCE.setLobbyWorldModified(lobbyWorldModified);
                }
                Closeable closeable = this.lobbyWorldService.openLobbyZip();
                Throwable throwable = null;
                try {
                    ZipInputStream zipStream = (ZipInputStream)closeable;
                    boolean bl3 = false;
                    while (zipStream.getNextEntry() != null) {
                        ZipEntry entry;
                        if (entry.isDirectory()) continue;
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String entryName = StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null);
                        if (StringsKt.startsWith$default((String)entryName, (String)"entities/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)entryName, (String)"region/", (boolean)false, (int)2, null)) {
                            Path outPath = storageDir.resolve(entryName);
                            if (!outPath.startsWith(storageDir)) {
                                this.log.error("[MenuController] Tried to create a file outside of the world location: " + outPath);
                                continue;
                            }
                            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                            this.log.debug("Copying file -> {}", (Object)outPath);
                            try {
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(zipStream, outPath, copyOptionArray);
                            }
                            catch (IOException e) {
                                this.log.error("[MenuController] Error copying lobby file " + entryName, (Throwable)e);
                            }
                        }
                        zipStream.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
        }
    }

    private final Sequence<Integer> everyChunkIndex(int margin) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(margin, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $margin;
            {
                this.$margin = $margin;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var2_2 = (SequenceScope)this.L$0;
                    var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            x = this.$margin;
                            var4_5 = 16 - this.$margin;
lbl8:
                            // 2 sources

                            while (x < var4_5) {
                                z = this.$margin;
                                var6_7 = 16 - this.$margin;
lbl11:
                                // 2 sources

                                while (z < var6_7) {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = x;
                                    this.I$1 = var4_5;
                                    this.I$2 = z;
                                    this.I$3 = var6_7;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)Boxing.boxInt((int)(x + z * 16)), (Continuation)this);
                                    if (v0 == var7_3) {
                                        return var7_3;
                                    }
                                    ** GOTO lbl31
                                }
                                break block0;
                            }
                            break block7;
                        }
                        case 1: {
                            var6_7 = this.I$3;
                            z = this.I$2;
                            var4_5 = this.I$1;
                            x = this.I$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl31:
                            // 2 sources

                            ++z;
                            ** GOTO lbl11
                        }
                    }
                    ++x;
                    ** GOTO lbl8
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    static /* synthetic */ Sequence everyChunkIndex$default(MenuController menuController, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return menuController.everyChunkIndex(n);
    }

    private final Sequence<BlockPosition> searchLobbyBlocks() {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super BlockPosition>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int I$5;
            int I$6;
            int I$7;
            int I$8;
            int I$9;
            int I$10;
            int I$11;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MenuController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block10: {
                    block9: {
                        var2_2 = (SequenceScope)this.L$0;
                        var20_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var4_4 = new Integer[]{Boxing.boxInt((int)0), Boxing.boxInt((int)1), Boxing.boxInt((int)-1), Boxing.boxInt((int)2), Boxing.boxInt((int)-2)};
                                chunkIndices = var4_4;
                                v0 = ConstantsKt.getLobbyWorld(MenuController.access$getServer$p(this.this$0));
                                bottomY = v0 != null ? v0.method_31607() : 0;
                                var5_7 = 0;
                                var6_8 = chunkIndices.length;
lbl12:
                                // 2 sources

                                while (var5_7 < var6_8) {
                                    chunkX = chunkIndices[var5_7];
                                    var8_10 = 0;
                                    var9_11 = chunkIndices.length;
lbl16:
                                    // 2 sources

                                    while (var8_10 < var9_11) {
                                        chunkZ = chunkIndices[var8_10];
                                        v1 = ConstantsKt.getLobbyWorld(MenuController.access$getServer$p(this.this$0));
                                        if (v1 == null || (v1 = v1.method_22342(chunkX, chunkZ, class_2806.field_12803)) == null) break block0;
                                        chunk = v1;
                                        heightmap = chunk.method_12032(class_2902.class_2903.field_13202);
                                        var13_15 = MenuController.everyChunkIndex$default(this.this$0, 0, 1, null).iterator();
lbl23:
                                        // 3 sources

                                        while (var13_15.hasNext()) {
                                            i = ((Number)var13_15.next()).intValue();
                                            x = i % 16;
                                            height = heightmap.method_12603(x, z = i / 16) + 3;
                                            y = height;
                                            if (bottomY > y) continue;
lbl29:
                                            // 2 sources

                                            while (true) {
                                                blockPos = chunk.method_12004().method_35231(x, y, z);
                                                Intrinsics.checkNotNull((Object)blockPos);
                                                this.L$0 = $this$sequence;
                                                this.L$1 = chunkIndices;
                                                this.L$2 = chunk;
                                                this.L$3 = heightmap;
                                                this.L$4 = var13_15;
                                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)blockPos);
                                                this.I$0 = bottomY;
                                                this.I$1 = var5_7;
                                                this.I$2 = var6_8;
                                                this.I$3 = chunkX;
                                                this.I$4 = var8_10;
                                                this.I$5 = var9_11;
                                                this.I$6 = chunkZ;
                                                this.I$7 = i;
                                                this.I$8 = x;
                                                this.I$9 = z;
                                                this.I$10 = height;
                                                this.I$11 = y;
                                                this.label = 1;
                                                v2 = $this$sequence.yield((Object)BlockPosition.Companion.fromBlockPos(blockPos), (Continuation)this);
                                                if (v2 == var20_3) {
                                                    return var20_3;
                                                }
                                                ** GOTO lbl78
                                                break;
                                            }
                                        }
                                        break block0;
                                    }
                                    break block9;
                                }
                                break block10;
                            }
                            case 1: {
                                y = this.I$11;
                                height = this.I$10;
                                z = this.I$9;
                                x = this.I$8;
                                i = this.I$7;
                                chunkZ = this.I$6;
                                var9_11 = this.I$5;
                                var8_10 = this.I$4;
                                chunkX = this.I$3;
                                var6_8 = this.I$2;
                                var5_7 = this.I$1;
                                bottomY = this.I$0;
                                blockPos = (class_2338)this.L$5;
                                var13_15 = (Iterator)this.L$4;
                                heightmap = (class_2902)this.L$3;
                                chunk = (class_2791)this.L$2;
                                chunkIndices = (Integer[])this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl78:
                                // 2 sources

                                if (y == bottomY) ** GOTO lbl23
                                --y;
                                ** continue;
                            }
                        }
                        ++var8_10;
                        ** GOTO lbl16
                    }
                    ++var5_7;
                    ** GOTO lbl12
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super BlockPosition> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Matrix4d getMenuPosition(class_3218 lobbyWorld) {
        Matrix4d matrix4d;
        Matrix4d matrix4d2;
        MenuController $this$getMenuPosition_u24lambda_u240 = this;
        boolean bl = false;
        Matrix4d matrix4d3 = Cache.INSTANCE.getMenuPosition();
        if (matrix4d3 != null) {
            Matrix4d it = matrix4d3;
            boolean bl2 = false;
            matrix4d2 = it;
        } else {
            Matrix4d matrix4d4;
            void $this$measureTime$iv;
            Logger logger = $this$getMenuPosition_u24lambda_u240.log;
            String message$iv = "[MenuController] Locating menu position...";
            boolean $i$f$measureTime = false;
            long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            $this$measureTime$iv.info(message$iv);
            try {
                Matrix4d matrix4d5;
                block12: {
                    boolean bl3 = false;
                    IServerWorld lobbyWorldImpl = $this$getMenuPosition_u24lambda_u240.serverWorldFactory.forWorld(lobbyWorld);
                    for (BlockPosition pos : $this$getMenuPosition_u24lambda_u240.searchLobbyBlocks()) {
                        boolean bl4;
                        Map blocks;
                        block11: {
                            void $this$associateWithTo$iv$iv;
                            void $this$associateWith$iv;
                            Object object = new class_2338[]{BlockPosition.move$default(pos, 0, 1, 0, 5, null).toBlockPos(), pos.toBlockPos(), BlockPosition.move$default(pos, 0, -1, 0, 5, null).toBlockPos()};
                            object = CollectionsKt.listOf((Object[])object);
                            boolean $i$f$associateWith = false;
                            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                            Iterator iterator = $this$associateWith$iv;
                            Map destination$iv$iv = result$iv;
                            boolean $i$f$associateWithTo = false;
                            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                                void it;
                                class_2338 class_23382 = (class_2338)element$iv$iv;
                                Object t = element$iv$iv;
                                Map map = destination$iv$iv;
                                boolean bl5 = false;
                                IBlockState iBlockState = lobbyWorldImpl.getBlockState(BlockPosition.Companion.fromBlockPos((class_2338)it));
                                IWallSignBlockState iWallSignBlockState = iBlockState instanceof IWallSignBlockState ? (IWallSignBlockState)iBlockState : null;
                                map.put(t, iWallSignBlockState);
                            }
                            blocks = destination$iv$iv;
                            Iterable $this$all$iv = blocks.values();
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    IWallSignBlockState it = (IWallSignBlockState)element$iv;
                                    boolean bl6 = false;
                                    IWallSignBlockState iWallSignBlockState = it;
                                    if (Intrinsics.areEqual((Object)(iWallSignBlockState != null ? iWallSignBlockState.getIdentifier() : null), (Object)"minecraft:oak_wall_sign")) continue;
                                    bl4 = false;
                                    break block11;
                                }
                                bl4 = true;
                            }
                        }
                        boolean isMenuPos = bl4;
                        IWallSignBlockState centerState = (IWallSignBlockState)CollectionsKt.first((Iterable)blocks.values());
                        if (!isMenuPos || centerState == null) continue;
                        Vector3i directionVec = centerState.getFacing();
                        double yaw = Math.atan2(directionVec.x, directionVec.z);
                        Matrix4d matrix4d6 = new Matrix4d();
                        matrix4d6.translate((Vector3fc)pos.toVector3f());
                        matrix4d6.rotateY(yaw);
                        matrix4d5 = matrix4d6;
                        break block12;
                    }
                    matrix4d5 = null;
                }
                matrix4d4 = matrix4d5;
            }
            finally {
                $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
            }
            matrix4d2 = matrix4d4;
        }
        Matrix4d menuPosition = matrix4d = matrix4d2;
        boolean bl7 = false;
        Cache.INSTANCE.setMenuPosition(menuPosition);
        Matrix4d matrix4d7 = menuPosition;
        this.log.info("Set menu position to " + (matrix4d7 != null ? matrix4d7.transform(new Vector4d()) : null));
        if (menuPosition != null) {
            Vector4d vector4d;
            Vector4d it = vector4d = new Vector4d();
            boolean bl8 = false;
            menuPosition.transform(it);
            it = vector4d;
            boolean bl9 = false;
            BlockPosition blockPos = new BlockPosition(MathKt.roundToInt((double)it.x), MathKt.roundToInt((double)it.y), MathKt.roundToInt((double)it.z));
            this.taskExecutor.execute(() -> MenuController.getMenuPosition$lambda$1$2(blockPos, lobbyWorld));
        }
        return matrix4d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<BlockPosition, Float> getLobbySpawnPosition(class_3218 lobbyWorld) {
        Pair pair;
        Pair pair2;
        MenuController $this$getLobbySpawnPosition_u24lambda_u240 = this;
        boolean bl = false;
        Pair pair3 = Cache.INSTANCE.getSpawnPosition();
        if (pair3 != null) {
            Pair it = pair3;
            boolean bl2 = false;
            pair2 = it;
        } else {
            Pair pair4;
            void $this$measureTime$iv;
            Logger logger = $this$getLobbySpawnPosition_u24lambda_u240.log;
            String message$iv = "[MenuController] Locating spawn position...";
            boolean $i$f$measureTime = false;
            long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            $this$measureTime$iv.info(message$iv);
            try {
                Pair pair5;
                block6: {
                    boolean bl3 = false;
                    for (BlockPosition pos : $this$getLobbySpawnPosition_u24lambda_u240.searchLobbyBlocks()) {
                        class_2680 blockState = lobbyWorld.method_8320(pos.toBlockPos());
                        boolean isPlayerHead = Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10432);
                        if (!isPlayerHead) continue;
                        Integer rotation = (Integer)blockState.method_11654((class_2769)class_2435.field_11505);
                        float yaw = (float)(rotation - 8) * 360.0f / 16.0f;
                        pair5 = new Pair((Object)pos, (Object)Float.valueOf(yaw));
                        break block6;
                    }
                    class_2791 chunk = lobbyWorld.method_22342(0, 0, class_2806.field_12803);
                    class_2902 heightmap = chunk.method_12032(class_2902.class_2903.field_13197);
                    int spawnY = heightmap.method_12603(0, 0);
                    pair5 = TuplesKt.to((Object)new BlockPosition(0, spawnY, 0), (Object)Float.valueOf(180.0f));
                }
                pair4 = pair5;
            }
            finally {
                $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
            }
            pair2 = pair4;
        }
        Pair it = pair = pair2;
        boolean bl4 = false;
        Cache.INSTANCE.setSpawnPosition(it);
        this.log.info("Set lobby spawnpoint to " + it);
        this.taskExecutor.execute(() -> MenuController.getLobbySpawnPosition$lambda$1$0(lobbyWorld, it));
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void spawnTeamEntities(class_3218 lobbyWorld) {
        IServerWorld lobbyWorldImpl = this.serverWorldFactory.forWorld(lobbyWorld);
        Map map = Cache.INSTANCE.getTeamPositions();
        if (map == null) {
            Map map2;
            void $this$measureTime$iv;
            Object object = this.log;
            String message$iv = "[MenuController] Locating team entities...";
            boolean $i$f$measureTime = false;
            long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            $this$measureTime$iv.info(message$iv);
            try {
                boolean bl = false;
                Map ret = new LinkedHashMap();
                for (BlockPosition blockPosition : this.searchLobbyBlocks()) {
                    Object v1;
                    BlockPosition blockPos;
                    block7: {
                        int z;
                        int y;
                        int x = blockPosition.component1();
                        boolean isLodestone = Intrinsics.areEqual((Object)lobbyWorld.method_8320(new class_2338(x, (y = blockPosition.component2()) - 1, z = blockPosition.component3())).method_26204(), (Object)class_2246.field_23261);
                        if (!isLodestone) continue;
                        blockPos = new BlockPosition(x, y, z);
                        IBlockState blockState = lobbyWorldImpl.getBlockState(blockPos);
                        Iterable iterable = this.data.getTeamPresets().entrySet();
                        for (Object t : iterable) {
                            Map.Entry it = (Map.Entry)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)((BingoTeamPreset)it.getValue()).getBlockId(), (Object)blockState.getIdentifier())) continue;
                            v1 = t;
                            break block7;
                        }
                        v1 = null;
                    }
                    Map.Entry entry = v1;
                    if (entry == null) continue;
                    String teamId = ((BingoTeamKey)entry.getKey()).unbox-impl();
                    ret.put(BingoTeamKey.box-impl(teamId), blockPos);
                }
                map2 = ret;
            }
            finally {
                $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
            }
            map = map2;
        }
        Map teamPositions = map;
        for (Object object : teamPositions.entrySet()) {
            BingoTeamPreset team;
            String teamKey2 = ((BingoTeamKey)object.getKey()).unbox-impl();
            BlockPosition blockPos = (BlockPosition)object.getValue();
            if (this.data.getTeamPresets().get(BingoTeamKey.box-impl(teamKey2)) == null) continue;
            this.spawnTeamEntity-1xyU8Nk(lobbyWorld, new Vector3d((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5), teamKey2, team, this.instanceTag);
            this.taskExecutor.execute(() -> MenuController.spawnTeamEntities$lambda$1(lobbyWorld, blockPos));
        }
    }

    private final void spawnTeamEntity-1xyU8Nk(class_3218 lobbyWorld, Vector3d position, String string, BingoTeamPreset teamPreset, String instanceTag) {
        IInteractionEntity iInteractionEntity;
        ITextDisplayEntity iTextDisplayEntity;
        ITextDisplayEntity $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240 = iTextDisplayEntity = this.entityManager.createEntity(EntityType.Companion.getTEXT_DISPLAY(), lobbyWorld);
        boolean bl = false;
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setPos(Vector3dKt.plus(position, new Vector3d(0.0, 1.5, 0.0)));
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setValue(BingoTeam.getName$default(BingoTeam.Companion.fromPreset-3J0cPAY(string, teamPreset), this.text, false, true, false, null, 26, null));
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setBillboard(ITextDisplayEntity.Billboard.VERTICAL);
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setAlignment(ITextDisplayEntity.TextAlignment.CENTER);
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setBackground(0);
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u240.setShadow(true);
        ITextDisplayEntity it = iTextDisplayEntity;
        boolean bl2 = false;
        it.setCommandTags(SetsKt.plus(it.getCommandTags(), (Object)instanceTag));
        it = iTextDisplayEntity;
        boolean bl3 = false;
        this.entityManager.spawnEntity(lobbyWorld, it);
        ITextDisplayEntity $this$spawnTeamEntity_1xyU8Nk_u24lambda_u243 = iTextDisplayEntity = this.entityManager.createEntity(EntityType.Companion.getTEXT_DISPLAY(), lobbyWorld);
        boolean bl4 = false;
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u243.setPos(Vector3dKt.plus(position, new Vector3d(0.0, 1.0, 0.0)));
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u243.setValue(this.text.string(StringKey.LobbyClickToJoin));
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u243.setBillboard(ITextDisplayEntity.Billboard.VERTICAL);
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u243.setAlignment(ITextDisplayEntity.TextAlignment.CENTER);
        it = iTextDisplayEntity;
        boolean bl5 = false;
        it.setCommandTags(SetsKt.plus(it.getCommandTags(), (Object)instanceTag));
        it = iTextDisplayEntity;
        boolean bl6 = false;
        this.entityManager.spawnEntity(lobbyWorld, it);
        IInteractionEntity $this$spawnTeamEntity_1xyU8Nk_u24lambda_u246 = iInteractionEntity = this.entityManager.createEntity(EntityType.Companion.getINTERACTION(), lobbyWorld);
        boolean bl7 = false;
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u246.setPos(Vector3dKt.plus(position, new Vector3d(0.0, -1.0, 0.0)));
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u246.setWidth(2.0f);
        $this$spawnTeamEntity_1xyU8Nk_u24lambda_u246.setHeight(4.0f);
        IInteractionEntity it2 = iInteractionEntity;
        boolean bl8 = false;
        it2.setCommandTags(SetsKt.plus(it2.getCommandTags(), (Object)instanceTag));
        it2 = iInteractionEntity;
        boolean bl9 = false;
        this.entityManager.spawnEntity(lobbyWorld, it2);
        IInteractionEntity interactionListenerEntity = iInteractionEntity;
        this.interactionEntityEvents.onInteract(interactionListenerEntity, (Function1<? super IPlayerHandle, Unit>)((Function1)arg_0 -> MenuController.spawnTeamEntity_1xyU8Nk$lambda$9(string, teamPreset, this, position, arg_0)));
    }

    private static final Unit _init_$lambda$0(MenuController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (this$0.menu != null) {
            this$0.log.error("BUG: GameState.PREGAME onEnter handler has been invoked already!");
            return Unit.INSTANCE;
        }
        if (!this$0.state.isLobbyMode()) {
            this$0.log.info("[MenuController] Not spawning lobby, as isLobbyMode=false");
            return Unit.INSTANCE;
        }
        class_3218 lobbyWorld = ConstantsKt.getLobbyWorld(this$0.server);
        if (lobbyWorld == null) {
            this$0.log.error("[MenuController] Not spawning lobby, as the dimension does not exist");
            return Unit.INSTANCE;
        }
        Pair<BlockPosition, Float> pair = this$0.getLobbySpawnPosition(lobbyWorld);
        BlockPosition lobbySpawnPos = (BlockPosition)pair.component1();
        float lobbySpawnYaw = ((Number)pair.component2()).floatValue();
        this$0.state.setLobbySpawnPos(lobbySpawnPos);
        this$0.state.setLobbySpawnYaw(lobbySpawnYaw);
        Matrix4d menuPos = this$0.getMenuPosition(lobbyWorld);
        if (menuPos != null) {
            MenuInstance menuInstance;
            this$0.log.info("[MenuController] Spawning lobby menu at " + menuPos.getTranslation(new Vector3d()));
            this$0.menu = menuInstance = new MenuInstance(this$0.log, this$0.koinScope, lobbyWorld, this$0.entityManager, this$0.interactionEntityEvents, menuPos, this$0.instanceTag);
        } else {
            this$0.log.warn("[MenuController] Not spawning menu entities as the lobby has no menu position.");
        }
        this$0.spawnTeamEntities(lobbyWorld);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MenuController this$0, EntityLoadEvent it) {
        Object v2;
        class_3218 lobbyWorld;
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            class_3218 class_32182 = ConstantsKt.getLobbyWorld(this$0.server);
            if (class_32182 == null) {
                return Unit.INSTANCE;
            }
            lobbyWorld = class_32182;
            Set set = it.getEntity().method_5752();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getCommandTags(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                String it2 = (String)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (!StringsKt.startsWith$default((String)it2, (String)"bingo-", (boolean)false, (int)2, null)) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return Unit.INSTANCE;
        }
        String bingoTag = string;
        if (Intrinsics.areEqual((Object)it.getWorld(), (Object)lobbyWorld) && !it.getEntity().method_31747() && !Intrinsics.areEqual((Object)bingoTag, (Object)this$0.instanceTag)) {
            this$0.log.warn("Discarding an existing lobby world entity: " + it.getEntity().method_5864());
            it.getEntity().method_31472();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MenuController this$0, TickEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MenuInstance menuInstance = this$0.menu;
            if (menuInstance == null) break block0;
            menuInstance.tick();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(MenuController this$0, StateChangedEvent stateChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)stateChangedEvent, (String)"<destruct>");
        GameState to = stateChangedEvent.component2();
        if (to != GameState.PREGAME) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            MenuInstance menuInstance = this$0.menu;
            if (menuInstance != null) {
                menuInstance.cleanup();
            }
            this$0.menu = null;
            class_3218 class_32182 = ConstantsKt.getLobbyWorld(this$0.server);
            if (class_32182 == null) {
                return Unit.INSTANCE;
            }
            class_3218 lobbyWorld = class_32182;
            Iterable iterable = lobbyWorld.method_27909();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateEntities(...)");
            Iterable iterable2 = iterable;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_1297 it = (class_1297)element$iv$iv;
                boolean bl = false;
                if (!(!it.method_31747() && it.method_5752().contains(this$0.instanceTag))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_1297 it = (class_1297)element$iv;
                boolean bl = false;
                it.method_31472();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MenuController this$0, Unit it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MenuInstance menuInstance = this$0.menu;
            if (menuInstance == null) break block0;
            menuInstance.markDirty();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(MenuController this$0, PlayerEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MenuInstance menuInstance = this$0.menu;
            if (menuInstance == null) break block0;
            menuInstance.markDirty();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(MenuController this$0, PlayerEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MenuInstance menuInstance = this$0.menu;
            if (menuInstance == null) break block0;
            menuInstance.markDirty();
        }
        return Unit.INSTANCE;
    }

    private static final void getMenuPosition$lambda$1$2(BlockPosition $blockPos, class_3218 $lobbyWorld) {
        int n;
        int y = $blockPos.getY() - 1;
        if (y <= (n = $blockPos.getY() + 1)) {
            while (true) {
                $lobbyWorld.method_8501(BlockPosition.copy$default($blockPos, 0, y, 0, 5, null).toBlockPos(), class_2246.field_10124.method_9564());
                if (y == n) break;
                ++y;
            }
        }
    }

    private static final void getLobbySpawnPosition$lambda$1$0(class_3218 $lobbyWorld, Pair $it) {
        $lobbyWorld.method_8501(((BlockPosition)$it.getFirst()).toBlockPos(), class_2246.field_10124.method_9564());
    }

    private static final void spawnTeamEntities$lambda$1(class_3218 $lobbyWorld, BlockPosition $blockPos) {
        $lobbyWorld.method_8501($blockPos.toBlockPos(), class_2246.field_10124.method_9564());
    }

    private static final Unit spawnTeamEntity_1xyU8Nk$lambda$9(String string, BingoTeamPreset $teamPreset, MenuController this$0, Vector3d $position, IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BingoTeam team = BingoTeam.Companion.fromPreset-3J0cPAY(string, $teamPreset);
        Integer n = team.getTextColor().method_532();
        this$0.particleFactory.createDustParticle(n != null ? n : 0, 1.0f).spawn(player, $position, 10, new Vector3d(1.0), 0.2);
        Sounds.INSTANCE.playTeamChanged(player);
        this$0.teamService.joinTeam(player, team);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MinecraftServer access$getServer$p(MenuController $this) {
        return $this.server;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR0\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR0\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\f\u0018\u00010\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lme/jfenn/bingo/common/menu/MenuController$Cache;", "", "<init>", "()V", "Ljava/time/Instant;", "lobbyWorldModified", "Ljava/time/Instant;", "getLobbyWorldModified", "()Ljava/time/Instant;", "setLobbyWorldModified", "(Ljava/time/Instant;)V", "Lkotlin/Pair;", "Lme/jfenn/bingo/platform/block/BlockPosition;", "", "spawnPosition", "Lkotlin/Pair;", "getSpawnPosition", "()Lkotlin/Pair;", "setSpawnPosition", "(Lkotlin/Pair;)V", "Lorg/joml/Matrix4d;", "menuPosition", "Lorg/joml/Matrix4d;", "getMenuPosition", "()Lorg/joml/Matrix4d;", "setMenuPosition", "(Lorg/joml/Matrix4d;)V", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "teamPositions", "Ljava/util/Map;", "getTeamPositions", "()Ljava/util/Map;", "setTeamPositions", "(Ljava/util/Map;)V", "bingo-common"})
    private static final class Cache {
        @NotNull
        public static final Cache INSTANCE = new Cache();
        @NotNull
        private static Instant lobbyWorldModified;
        @Nullable
        private static Pair<BlockPosition, Float> spawnPosition;
        @Nullable
        private static Matrix4d menuPosition;
        @Nullable
        private static Map<BingoTeamKey, BlockPosition> teamPositions;

        private Cache() {
        }

        @NotNull
        public final Instant getLobbyWorldModified() {
            return lobbyWorldModified;
        }

        public final void setLobbyWorldModified(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            lobbyWorldModified = instant;
        }

        @Nullable
        public final Pair<BlockPosition, Float> getSpawnPosition() {
            return spawnPosition;
        }

        public final void setSpawnPosition(@Nullable Pair<BlockPosition, Float> pair) {
            spawnPosition = pair;
        }

        @Nullable
        public final Matrix4d getMenuPosition() {
            return menuPosition;
        }

        public final void setMenuPosition(@Nullable Matrix4d matrix4d) {
            menuPosition = matrix4d;
        }

        @Nullable
        public final Map<BingoTeamKey, BlockPosition> getTeamPositions() {
            return teamPositions;
        }

        public final void setTeamPositions(@Nullable Map<BingoTeamKey, BlockPosition> map) {
            teamPositions = map;
        }

        static {
            Instant instant = Instant.MIN;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
            lobbyWorldModified = instant;
        }
    }
}

