/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.ready;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.platform.IPlayerHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u000f\u0010\u0019\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0019\u0010\u0016J\r\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0003R\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\"\u0010%\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b%\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010'\u00a8\u0006+"}, d2={"Lme/jfenn/bingo/common/ready/ReadyTimerState;", "", "<init>", "()V", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "players", "", "updatePlayers", "(Ljava/util/List;)V", "Ljava/util/UUID;", "player", "", "isReady", "(Ljava/util/UUID;)Z", "ready", "setReady", "(Ljava/util/UUID;Z)V", "Ljava/time/Duration;", "duration", "startTimer", "(Ljava/time/Duration;)V", "()Ljava/time/Duration;", "totalTime", "elapsedTime", "remainingTime", "reset", "totalPlayers", "Ljava/util/List;", "", "readyPlayers", "Ljava/util/Set;", "Ljava/time/Instant;", "startedAt", "Ljava/time/Instant;", "totalDuration", "Ljava/time/Duration;", "isCancelled", "Z", "()Z", "setCancelled", "(Z)V", "isRunning", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nReadyTimerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadyTimerState.kt\nme/jfenn/bingo/common/ready/ReadyTimerState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1563#2:71\n1634#2,3:72\n1788#2,4:75\n*S KotlinDebug\n*F\n+ 1 ReadyTimerState.kt\nme/jfenn/bingo/common/ready/ReadyTimerState\n*L\n25#1:71\n25#1:72,3\n45#1:75,4\n*E\n"})
public final class ReadyTimerState {
    @NotNull
    private List<UUID> totalPlayers = CollectionsKt.emptyList();
    @NotNull
    private final Set<UUID> readyPlayers = new LinkedHashSet();
    @Nullable
    private Instant startedAt;
    @Nullable
    private Duration totalDuration;
    private boolean isCancelled;

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    public final void setCancelled(boolean bl) {
        this.isCancelled = bl;
    }

    public final boolean isRunning() {
        return this.startedAt != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePlayers(@NotNull List<? extends IPlayerHandle> players) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Iterable iterable = players;
        ReadyTimerState readyTimerState = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IPlayerHandle iPlayerHandle = (IPlayerHandle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUuid());
        }
        readyTimerState.totalPlayers = (List)destination$iv$iv;
    }

    public final boolean isReady(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.readyPlayers.contains(player);
    }

    public final void setReady(@NotNull UUID player, boolean ready) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean bl = ready ? this.readyPlayers.add(player) : this.readyPlayers.remove(player);
    }

    public final void startTimer(@NotNull Duration duration2) {
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        this.isCancelled = false;
        this.startedAt = Instant.now();
        this.totalDuration = duration2;
    }

    @Nullable
    public final Duration duration() {
        int n;
        Iterable $this$count$iv = this.totalPlayers;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UUID it = (UUID)element$iv;
                boolean bl = false;
                if (!this.isReady(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        float readyRatio = (float)n / RangesKt.coerceAtLeast((float)this.totalPlayers.size(), (float)1.0f);
        Duration duration2 = this.totalDuration;
        if (duration2 == null) {
            return null;
        }
        float millis = (1.0f - readyRatio) * (float)duration2.toMillis();
        return Duration.ofMillis((long)millis);
    }

    @Nullable
    public final Duration totalTime() {
        return this.totalDuration;
    }

    @Nullable
    public final Duration elapsedTime() {
        Instant now = Instant.now();
        Intrinsics.checkNotNull((Object)now);
        Instant instant = this.startedAt;
        if (instant == null) {
            return null;
        }
        return DurationKt.minus(now, instant);
    }

    @Nullable
    public final Duration remainingTime() {
        Duration duration2 = this.duration();
        if (duration2 == null) {
            return null;
        }
        Duration totalDuration = duration2;
        Duration duration3 = this.elapsedTime();
        if (duration3 == null) {
            return null;
        }
        Duration elapsedDuration = duration3;
        return totalDuration.minus(elapsedDuration);
    }

    public final void reset() {
        this.readyPlayers.clear();
        this.startedAt = null;
        this.totalDuration = null;
        this.isCancelled = false;
    }
}

