/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.state;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.bingo.platform.IJsonSerializers;
import me.jfenn.bingo.platform.IPersistentStateManager;
import me.jfenn.bingo.platform.IPersistentStateType;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ServerEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001/B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ=\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\"\b\b\u0000\u0010\r*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0018\u001a\u00028\u0000\"\b\b\u0000\u0010\r*\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001c\u001a\u00020\u001b\"\b\b\u0000\u0010\r*\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R$\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lme/jfenn/bingo/common/state/PersistentStateManager;", "Lme/jfenn/bingo/platform/IPersistentStateManager;", "Lorg/slf4j/Logger;", "logger", "Lme/jfenn/bingo/platform/IJsonSerializers;", "serializers", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/IJsonSerializers;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/platform/event/IEventBus;)V", "", "T", "", "id", "Lkotlin/reflect/KType;", "kType", "Lkotlin/Function0;", "default", "Lme/jfenn/bingo/platform/IPersistentStateType;", "register", "(Ljava/lang/String;Lkotlin/reflect/KType;Lkotlin/jvm/functions/Function0;)Lme/jfenn/bingo/platform/IPersistentStateType;", "type", "getFromWorld", "(Lme/jfenn/bingo/platform/IPersistentStateType;)Ljava/lang/Object;", "value", "", "put", "(Lme/jfenn/bingo/platform/IPersistentStateType;Ljava/lang/Object;)V", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "getServerWorldFactory", "()Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "", "Lme/jfenn/bingo/common/state/PersistentStateManager$Type;", "registeredTypes", "Ljava/util/Map;", "", "Ljava/nio/file/OpenOption;", "writeOptions", "[Ljava/nio/file/OpenOption;", "Type", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nPersistentStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentStateManager.kt\nme/jfenn/bingo/common/state/PersistentStateManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1869#3,2:122\n*S KotlinDebug\n*F\n+ 1 PersistentStateManager.kt\nme/jfenn/bingo/common/state/PersistentStateManager\n*L\n115#1:122,2\n*E\n"})
public final class PersistentStateManager
implements IPersistentStateManager {
    @NotNull
    private final Logger logger;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;
    @NotNull
    private final Json json;
    @NotNull
    private final Map<String, Type<?>> registeredTypes;
    @NotNull
    private final OpenOption[] writeOptions;

    public PersistentStateManager(@NotNull Logger logger, @NotNull IJsonSerializers serializers, @NotNull IServerWorldFactory serverWorldFactory, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.logger = logger;
        this.serverWorldFactory = serverWorldFactory;
        this.json = JsonKt.Json((Json)serializers.getJson(), PersistentStateManager::json$lambda$0);
        this.registeredTypes = new LinkedHashMap();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        this.writeOptions = openOptionArray;
        eventBus.register(ServerEvent.Saved.INSTANCE, arg_0 -> PersistentStateManager._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final IServerWorldFactory getServerWorldFactory() {
        return this.serverWorldFactory;
    }

    @Override
    @NotNull
    public <T> IPersistentStateType<T> register(@NotNull String id, @NotNull KType kType, @NotNull Function0<? extends T> function0) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Path path = this.serverWorldFactory.getOverworld().getDirectory().resolve("data").resolve(id + ".json.gz");
        Intrinsics.checkNotNull((Object)path);
        KSerializer kSerializer = SerializersKt.serializer((KType)kType);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of me.jfenn.bingo.common.state.PersistentStateManager.register>");
        Type<Object> type = new Type<Object>(id, path, kSerializer, function0.invoke());
        this.registeredTypes.put(type.getId(), type);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> T getFromWorld(@NotNull IPersistentStateType<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!(type instanceof Type)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = ((Type)type).getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Object object;
                void it;
                this.logger.debug("Reading persistent state " + ((Type)type).getId() + "...");
                Type type2 = (Type)type;
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                int n = 8192;
                Object object2 = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                Type type3 = type2;
                boolean bl = false;
                closeable = new GZIPInputStream((InputStream)it);
                object2 = null;
                try {
                    GZIPInputStream it2 = (GZIPInputStream)closeable;
                    boolean bl2 = false;
                    object = JvmStreamsKt.decodeFromStream((Json)this.json, (DeserializationStrategy)((DeserializationStrategy)((Type)type).getSerializer()), (InputStream)it2);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
                type3.setValue(object);
            }
            catch (Throwable e) {
                this.logger.error("Error decoding persistent state " + ((Type)type).getId(), e);
            }
        }
        return ((Type)type).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(@NotNull IPersistentStateType<T> type, @NotNull T value) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!(type instanceof Type)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = ((Type)type).getPath();
        try {
            this.logger.debug("Writing persistent state " + ((Type)type).getId() + "...");
            OpenOption[] openOptionArray = this.writeOptions;
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            int n = 8192;
            BufferedOutputStream it = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            boolean bl = false;
            closeable = new GZIPOutputStream(it);
            Throwable throwable = null;
            try {
                GZIPOutputStream it2 = (GZIPOutputStream)closeable;
                boolean bl2 = false;
                JvmStreamsKt.encodeToStream((Json)this.json, (SerializationStrategy)((SerializationStrategy)((Type)type).getSerializer()), value, (OutputStream)it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            this.logger.error("Error encoding persistent state " + ((Type)type).getId(), e);
        }
        ((Type)type).setValue(value);
        this.logger.debug("Writing persistent state " + ((Type)type).getId() + "... Done!");
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(PersistentStateManager this$0, ServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.registeredTypes.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it2 = (Type)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type me.jfenn.bingo.common.state.PersistentStateManager.Type<kotlin.Any>");
            this$0.put(it2, it2.getValue());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B-\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\n\u001a\u00028\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/common/state/PersistentStateManager$Type;", "", "T", "Lme/jfenn/bingo/platform/IPersistentStateType;", "", "id", "Ljava/nio/file/Path;", "path", "Lkotlinx/serialization/KSerializer;", "serializer", "value", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Lkotlinx/serialization/KSerializer;Ljava/lang/Object;)V", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "Lkotlinx/serialization/KSerializer;", "getSerializer", "()Lkotlinx/serialization/KSerializer;", "Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "bingo-common"})
    private static final class Type<T>
    implements IPersistentStateType<T> {
        @NotNull
        private final String id;
        @NotNull
        private final Path path;
        @NotNull
        private final KSerializer<T> serializer;
        @NotNull
        private T value;

        public Type(@NotNull String id, @NotNull Path path, @NotNull KSerializer<T> serializer2, @NotNull T value) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.id = id;
            this.path = path;
            this.serializer = serializer2;
            this.value = value;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final KSerializer<T> getSerializer() {
            return this.serializer;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        public final void setValue(@NotNull T t) {
            Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
            this.value = t;
        }
    }
}

