/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.timer;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.game.GameEndReason;
import me.jfenn.bingo.common.game.GameService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.platform.event.model.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/jfenn/bingo/common/timer/TimerCheck;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/game/GameService;", "gameService", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/game/GameService;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/game/GameService;", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nTimerCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimerCheck.kt\nme/jfenn/bingo/common/timer/TimerCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,61:1\n1#2:62\n65#3:63\n*S KotlinDebug\n*F\n+ 1 TimerCheck.kt\nme/jfenn/bingo/common/timer/TimerCheck\n*L\n43#1:63\n*E\n"})
public final class TimerCheck
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final GameService gameService;
    @NotNull
    private final Logger log;

    public TimerCheck(@NotNull ScopedEvents events, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull GameService gameService, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)gameService, (String)"gameService");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.state = state;
        this.options = options;
        this.gameService = gameService;
        this.log = log;
        ScopedEvents.onEnter$default(events, GameState.PLAYING, false, arg_0 -> TimerCheck._init_$lambda$0(this, arg_0), 2, null);
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> TimerCheck._init_$lambda$1(this, arg_0)));
    }

    private static final Unit _init_$lambda$0(TimerCheck this$0, GameState prevState) {
        Intrinsics.checkNotNullParameter((Object)((Object)prevState), (String)"prevState");
        if (prevState == GameState.PLAYING) {
            return Unit.INSTANCE;
        }
        this$0.state.setStartedAt(Instant.now());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TimerCheck this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() != GameState.PLAYING) {
            return Unit.INSTANCE;
        }
        Instant now = Instant.now();
        Instant instant = this$0.state.getUpdatedAt();
        if (instant != null) {
            Instant lastUpdate = instant;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)now);
            Duration duration2 = DurationKt.minus(now, lastUpdate);
            if (duration2 != null) {
                Duration duration3;
                Duration duration4;
                Duration it2 = duration4 = duration2;
                boolean bl2 = false;
                int $this$seconds$iv = 1;
                boolean $i$f$getSeconds = false;
                Duration duration5 = Duration.ofSeconds($this$seconds$iv);
                Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofSeconds(...)");
                Duration duration6 = duration3 = it2.compareTo(duration5) > 0 ? duration4 : null;
                if (duration3 != null) {
                    Duration pauseDuration = duration3;
                    boolean bl3 = false;
                    this$0.log.info("Game was inactive for " + pauseDuration + " - updating timer");
                    BingoState bingoState = this$0.state;
                    Duration duration7 = bingoState.getTimeOffline().plus(pauseDuration);
                    Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"plus(...)");
                    bingoState.setTimeOffline(duration7);
                }
            }
        }
        this$0.state.setUpdatedAt(now);
        Duration duration8 = this$0.state.ingameDuration();
        if (duration8 == null) {
            return Unit.INSTANCE;
        }
        Duration duration9 = duration8;
        Duration timeLimit = this$0.options.getTimeLimit();
        if (timeLimit != null && duration9.compareTo(timeLimit) >= 0) {
            this$0.gameService.end(GameEndReason.Timer.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

