/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.timer;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.timer.TimerPacket;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.packet.IServerPacketHandlerS2C;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/jfenn/bingo/common/timer/TimerPacketController;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packetManager", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "", "prevSecondsRemaining", "J", "bingo-common"})
public final class TimerPacketController {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ServerPacketEvents packetManager;
    private long prevSecondsRemaining;

    public TimerPacketController(@NotNull MinecraftServer server, @NotNull BingoState state, @NotNull ServerPacketEvents packetManager, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packetManager, (String)"packetManager");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.server = server;
        this.state = state;
        this.packetManager = packetManager;
        this.prevSecondsRemaining = -1L;
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> TimerPacketController._init_$lambda$0(this, arg_0)));
    }

    private static final Unit _init_$lambda$0(TimerPacketController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Duration duration2 = this$0.state.getOptions().getTimeLimit();
        if (duration2 == null) {
            return Unit.INSTANCE;
        }
        Duration timeLimit = duration2;
        Duration duration3 = this$0.state.ingameDuration();
        if (duration3 == null) {
            return Unit.INSTANCE;
        }
        Duration duration4 = duration3;
        long secondsRemaining = timeLimit.minus(duration4).getSeconds();
        if (secondsRemaining != this$0.prevSecondsRemaining && secondsRemaining >= 0L) {
            this$0.prevSecondsRemaining = secondsRemaining;
            TimerPacket packet = new TimerPacket((int)secondsRemaining);
            for (class_3222 player : this$0.server.method_3760().method_14571()) {
                IServerPacketHandlerS2C<TimerPacket> iServerPacketHandlerS2C = this$0.packetManager.getTimerV1();
                Intrinsics.checkNotNull((Object)player);
                iServerPacketHandlerS2C.send(player, packet);
            }
        }
        return Unit.INSTANCE;
    }
}

