/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.integrations.voice;

import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.PlayerConnectedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStoppedEvent;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.integrations.voice.SimpleVoiceApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R#\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lme/jfenn/bingo/integrations/voice/SimpleVoiceEntrypoint;", "Lde/maxhenkel/voicechat/api/VoicechatPlugin;", "<init>", "()V", "", "getPluginId", "()Ljava/lang/String;", "Lde/maxhenkel/voicechat/api/events/EventRegistration;", "registration", "", "registerEvents", "(Lde/maxhenkel/voicechat/api/events/EventRegistration;)V", "Lde/maxhenkel/voicechat/api/events/VoicechatServerStartedEvent;", "event", "onServerStarted", "(Lde/maxhenkel/voicechat/api/events/VoicechatServerStartedEvent;)V", "Lde/maxhenkel/voicechat/api/events/VoicechatServerStoppedEvent;", "onServerStopped", "(Lde/maxhenkel/voicechat/api/events/VoicechatServerStoppedEvent;)V", "Lde/maxhenkel/voicechat/api/events/PlayerConnectedEvent;", "onPlayerConnected", "(Lde/maxhenkel/voicechat/api/events/PlayerConnectedEvent;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lde/maxhenkel/voicechat/api/VoicechatServerApi;", "api", "Lde/maxhenkel/voicechat/api/VoicechatServerApi;", "getApi", "()Lde/maxhenkel/voicechat/api/VoicechatServerApi;", "setApi", "(Lde/maxhenkel/voicechat/api/VoicechatServerApi;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "onPlayerConnectedGroups", "Ljava/util/concurrent/ConcurrentHashMap;", "getOnPlayerConnectedGroups", "()Ljava/util/concurrent/ConcurrentHashMap;", "bingo-integration-voicechat"})
public final class SimpleVoiceEntrypoint
implements VoicechatPlugin {
    @NotNull
    public static final SimpleVoiceEntrypoint INSTANCE = new SimpleVoiceEntrypoint();
    private static final Logger logger = LoggerFactory.getLogger((String)"bingo");
    @Nullable
    private static VoicechatServerApi api;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> onPlayerConnectedGroups;

    private SimpleVoiceEntrypoint() {
    }

    @Nullable
    public final VoicechatServerApi getApi() {
        return api;
    }

    public final void setApi(@Nullable VoicechatServerApi voicechatServerApi) {
        api = voicechatServerApi;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, UUID> getOnPlayerConnectedGroups() {
        return onPlayerConnectedGroups;
    }

    @NotNull
    public String getPluginId() {
        return "yet-another-minecraft-bingo";
    }

    public void registerEvents(@NotNull EventRegistration registration) {
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(VoicechatServerStoppedEvent.class, this::onServerStopped);
        registration.registerEvent(PlayerConnectedEvent.class, this::onPlayerConnected);
    }

    public final void onServerStarted(@NotNull VoicechatServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("[SimpleVoiceEntrypoint] Voice server started");
        api = event.getVoicechat();
    }

    public final void onServerStopped(@NotNull VoicechatServerStoppedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("[SimpleVoiceEntrypoint] Voice server stopped");
        api = null;
    }

    public final void onPlayerConnected(@NotNull PlayerConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            UUID playerId = event.getConnection().getPlayer().getUuid();
            UUID groupId = onPlayerConnectedGroups.remove(event.getConnection().getPlayer().getUuid());
            if (groupId != null) {
                SimpleVoiceApi simpleVoiceApi = new SimpleVoiceApi();
                VoicechatServerApi voicechatServerApi = event.getVoicechat();
                Intrinsics.checkNotNullExpressionValue((Object)voicechatServerApi, (String)"getVoicechat(...)");
                SimpleVoiceApi.GroupHandle groupHandle = simpleVoiceApi.new SimpleVoiceApi.GroupHandle(voicechatServerApi, groupId);
                Intrinsics.checkNotNull((Object)playerId);
                groupHandle.addPlayer(playerId);
            }
        }
        catch (Throwable e) {
            logger.error("[SimpleVoiceEntrypoint] Error running onPlayerConnected:", e);
        }
    }

    static {
        onPlayerConnectedGroups = new ConcurrentHashMap();
    }
}

